/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.feature;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.config.feature.FeaturesLoader;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.tenancy.api.event.TenantArrivedEvent;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class FeaturesMapHolder {
    private final FeaturesLoader featuresLoader;
    private final ResettableLazyReference<Set<String>> enabledFeatures = new ResettableLazyReference<Set<String>>(){

        protected Set<String> create() throws Exception {
            Map allFeatures = FeaturesMapHolder.this.initFeatures(Iterables.concat((Iterable)ImmutableList.of((Object)FeaturesMapHolder.this.featuresLoader.loadCoreProperties()), (Iterable)FeaturesMapHolder.this.getPluginFeatures()));
            return FeaturesMapHolder.this.initEnabledFeatures(allFeatures);
        }
    };
    private volatile boolean jiraStarted;

    FeaturesMapHolder(FeaturesLoader featuresLoader) {
        this.featuresLoader = featuresLoader;
    }

    Set<String> enabledFeatures() {
        return (Set)this.enabledFeatures.get();
    }

    private Iterable<Properties> getPluginFeatures() {
        return this.jiraStarted ? this.featuresLoader.loadPluginsFeatureProperties() : Collections.emptyList();
    }

    private Map<String, Boolean> initFeatures(Iterable<Properties> allProperties) {
        HashMap<String, Boolean> collector = new HashMap<String, Boolean>();
        for (Properties singleProperties : allProperties) {
            for (String property : singleProperties.stringPropertyNames()) {
                collector.put(property, Boolean.valueOf(singleProperties.getProperty(property)));
            }
        }
        return ImmutableMap.copyOf(collector);
    }

    private Set<String> initEnabledFeatures(Map<String, Boolean> allFeatures) {
        return (Set)allFeatures.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(CollectorsUtil.toImmutableSet());
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        this.onPluginEvent(event.getPlugin());
    }

    @EventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        this.onPluginEvent(event.getPlugin());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearCache();
    }

    @EventListener
    public void onTenantArrived(TenantArrivedEvent event) {
        this.clearCache();
    }

    public void start() {
        this.jiraStarted = true;
        this.clearCache();
    }

    private void onPluginEvent(Plugin plugin) {
        if (!this.featuresLoader.hasFeatureResources(plugin)) {
            this.clearCache();
        }
    }

    void clearCache() {
        this.enabledFeatures.reset();
    }
}

