/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.managedconfiguration;

import com.atlassian.jira.config.managedconfiguration.ConfigurationItemAccessLevel;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItem;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemBuilder;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemStore;
import com.atlassian.jira.config.managedconfiguration.ManagedConfigurationItemType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultManagedConfigurationItemStore
implements ManagedConfigurationItemStore {
    public static final String ENTITY_NAME = "ManagedConfigurationItem";
    private static final Logger log = LoggerFactory.getLogger(DefaultManagedConfigurationItemStore.class);
    private final OfBizDelegator ofBizDelegator;

    public DefaultManagedConfigurationItemStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    @Nonnull
    public ManagedConfigurationItem updateManagedConfigurationItem(@Nonnull ManagedConfigurationItem item) {
        GenericValue registered;
        Assertions.notNull((String)"item", (Object)item);
        ManagedConfigurationItem existing = this.getManagedConfigurationItem(item.getItemId(), item.getItemType());
        if (existing != null) {
            item = new ManagedConfigurationItemBuilder().setId(existing.getId()).setItemId(item.getItemId()).setItemType(item.getItemType()).setManaged(item.isManaged()).setConfigurationItemAccessLevel(item.getConfigurationItemAccessLevel()).setSource(item.getSourceId()).setDescriptionI18nKey(item.getDescriptionI18nKey()).build();
            registered = this.ofBizDelegator.makeValue(ENTITY_NAME, DefaultManagedConfigurationItemStore.toGV(item));
            this.ofBizDelegator.store(registered);
        } else {
            registered = this.ofBizDelegator.createValue(ENTITY_NAME, DefaultManagedConfigurationItemStore.toGV(item));
        }
        ManagedConfigurationItem managedConfigurationItem = DefaultManagedConfigurationItemStore.fromGV(registered);
        log.info("Managed Configuration Item registered: " + managedConfigurationItem.toString());
        return managedConfigurationItem;
    }

    @Override
    public boolean deleteManagedConfigurationItem(@Nonnull ManagedConfigurationItem item) {
        Assertions.notNull((String)"item", (Object)item);
        int count = this.ofBizDelegator.removeByAnd(ENTITY_NAME, MapBuilder.build((Object)"itemId", (Object)item.getItemId(), (Object)"itemType", (Object)item.getItemType().toString()));
        if (count > 0) {
            log.info(String.format("Managed item %s successfully unregistered", item));
            return true;
        }
        log.info(String.format("Managed item %s was not unregistered", item));
        return false;
    }

    @Override
    @Nullable
    public ManagedConfigurationItem getManagedConfigurationItem(@Nonnull String itemId, @Nonnull ManagedConfigurationItemType type) {
        Assertions.notNull((String)"itemId", (Object)itemId);
        Assertions.notNull((String)"type", (Object)type);
        List existing = this.ofBizDelegator.findByAnd(ENTITY_NAME, MapBuilder.build((Object)"itemId", (Object)itemId, (Object)"itemType", (Object)type.toString()));
        if (!existing.isEmpty()) {
            return DefaultManagedConfigurationItemStore.fromGV((GenericValue)existing.iterator().next());
        }
        return null;
    }

    @Override
    @Nonnull
    public Collection<ManagedConfigurationItem> getManagedConfigurationItems(@Nonnull ManagedConfigurationItemType type) {
        Assertions.notNull((String)"type", (Object)type);
        List existing = this.ofBizDelegator.findByAnd(ENTITY_NAME, MapBuilder.build((Object)"itemType", (Object)type.toString()));
        return CollectionUtil.transform((Iterable)existing, (Function)new Function<GenericValue, ManagedConfigurationItem>(){

            public ManagedConfigurationItem get(GenericValue input) {
                return DefaultManagedConfigurationItemStore.fromGV(input);
            }
        });
    }

    static Map<String, Object> toGV(ManagedConfigurationItem item) {
        MapBuilder builder = MapBuilder.newBuilder();
        if (item.getId() != null) {
            builder.add((Object)"id", (Object)item.getId());
        }
        builder.add((Object)"itemId", (Object)item.getItemId()).add((Object)"itemType", (Object)item.getItemType().toString()).add((Object)"managed", (Object)(item.isManaged() ? "true" : null)).add((Object)"accessLevel", (Object)item.getConfigurationItemAccessLevel().toString()).add((Object)"source", (Object)item.getSourceId()).add((Object)"descriptionKey", (Object)item.getDescriptionI18nKey());
        return builder.toMap();
    }

    static ManagedConfigurationItem fromGV(GenericValue gv) {
        return new ManagedConfigurationItemBuilder().setId(gv.getLong("id")).setItemId(gv.getString("itemId")).setItemType(ManagedConfigurationItemType.valueOf((String)gv.getString("itemType"))).setManaged("true".equals(gv.getString("managed"))).setConfigurationItemAccessLevel(ConfigurationItemAccessLevel.valueOf((String)gv.getString("accessLevel"))).setSource(gv.getString("source")).setDescriptionI18nKey(gv.getString("descriptionKey")).build();
    }
}

