/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.MembershipAlreadyExistsException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.DelegatingUserWithAttributes;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.auditing.AffectedUser;
import com.atlassian.jira.auditing.AssociatedItem;
import com.atlassian.jira.auditing.AuditingCategory;
import com.atlassian.jira.auditing.AuditingManager;
import com.atlassian.jira.auditing.ChangedValue;
import com.atlassian.jira.auditing.RecordRequest;
import com.atlassian.jira.auditing.handlers.ChangedValuesBuilder;
import com.atlassian.jira.auditing.handlers.UserEventHandlerImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.crowd.embedded.ofbiz.AttributeKey;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.EagerOfBizUserCache;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.LazyOfBizUserCache;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizAttributesBuilder;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUserCache;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.SimpleUserOrGroupStub;
import com.atlassian.jira.crowd.embedded.ofbiz.UnsortedRestriction;
import com.atlassian.jira.crowd.embedded.ofbiz.UserAttributeEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.UserEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.UserEntityConditionFactory;
import com.atlassian.jira.crowd.embedded.ofbiz.UserNotFoundException;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.entity.Update;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.user.UserDeleteVeto;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Visitor;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class OfBizUserDao
implements UserDao {
    private static final Logger log = Logger.getLogger(OfBizUserDao.class);
    private static final List<String> ORDER_BY_ATTRIBUTE_ID = ImmutableList.of((Object)"id");
    private static final String DELETED_EXTERNALLY_SUFFIX = " [X]";
    private static final int PROCESS_USERS_FETCH_SIZE = 1000;
    final OfBizDelegator ofBizDelegator;
    final DirectoryDao directoryDao;
    private final InternalMembershipDao membershipDao;
    private final UserKeyStore userKeyStore;
    private final UserDeleteVeto userDeleteVeto;
    private final ApplicationProperties applicationProperties;
    private final OfBizUserCache userCaseInsensitiveCache;
    private final Cache<AttributeKey, Attributes> userAttributesCache;
    static final Function<GenericValue, String> TO_USERNAME_FUNCTION = new Function<GenericValue, String>(){

        public String get(GenericValue gvUser) {
            return gvUser.getString("userName");
        }
    };
    static final Function<GenericValue, OfBizUser> TO_USER_FUNCTION = new Function<GenericValue, OfBizUser>(){

        public OfBizUser get(GenericValue gvUser) {
            return OfBizUser.from(gvUser);
        }
    };

    public OfBizUserDao(OfBizDelegator ofBizDelegator, DirectoryDao directoryDao, InternalMembershipDao membershipDao, UserKeyStore userKeyStore, UserDeleteVeto userDeleteVeto, CacheManager cacheManager, ClusterLockService clusterLockService, ApplicationProperties applicationProperties) {
        this.ofBizDelegator = ofBizDelegator;
        this.directoryDao = directoryDao;
        this.membershipDao = membershipDao;
        this.userKeyStore = userKeyStore;
        this.userDeleteVeto = userDeleteVeto;
        this.applicationProperties = applicationProperties;
        this.userAttributesCache = cacheManager.getCache(OfBizUserDao.class.getName() + ".userAttributesCache", (CacheLoader)new UserAttributesCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build());
        if (this.useFullCache()) {
            log.info((Object)"Using full user cache");
            this.userCaseInsensitiveCache = new EagerOfBizUserCache(clusterLockService, cacheManager, directoryDao, ofBizDelegator);
        } else {
            log.info((Object)"Using lazy user cache");
            this.userCaseInsensitiveCache = new LazyOfBizUserCache(cacheManager, ofBizDelegator);
        }
    }

    public boolean useFullCache() {
        return this.applicationProperties.getOption("jira.fullUserCache");
    }

    @Nonnull
    public TimestampedUser findByName(long directoryId, String userName) throws UserNotFoundException {
        return this.findOfBizUser(directoryId, userName);
    }

    @Nonnull
    OfBizUser findOfBizUser(long directoryId, String userName) throws UserNotFoundException {
        OfBizUser user = this.findByNameOrNull(directoryId, userName);
        if (user == null) {
            throw new UserNotFoundException(userName);
        }
        return user;
    }

    @Nullable
    OfBizUser findByNameOrNull(long directoryId, @Nonnull String userName) {
        return this.userCaseInsensitiveCache.getCaseInsensitive(directoryId, userName);
    }

    @Nonnull
    List<OfBizUser> findAllByNameOrNull(long directoryId, @Nonnull Collection<String> userNames) {
        return this.userCaseInsensitiveCache.getAllCaseInsensitive(directoryId, userNames);
    }

    @Nonnull
    public OfBizUser findByExternalId(long directoryId, String externalId) throws UserNotFoundException {
        GenericValue user = (GenericValue)Select.columns(OfBizUser.SUPPORTED_FIELDS).from("User").whereEqual("directoryId", directoryId).andEqual("externalId", externalId).runWith(this.ofBizDelegator).singleValue();
        if (user == null) {
            throw new UserNotFoundException(externalId);
        }
        return OfBizUser.from(user);
    }

    @Nonnull
    public UserWithAttributes findByNameWithAttributes(long directoryId, String userName) throws UserNotFoundException {
        OfBizUser user = this.findOfBizUser(directoryId, userName);
        Attributes attributes = (Attributes)this.userAttributesCache.get((Object)new AttributeKey(directoryId, user.getId()));
        return new DelegatingUserWithAttributes((com.atlassian.crowd.model.user.User)user, attributes);
    }

    @Nullable
    public PasswordCredential getCredential(long directoryId, String userName) throws UserNotFoundException {
        GenericValue credentials = (GenericValue)Select.columns("credential").from("User").whereEqual("directoryId", directoryId).andEqual("lowerUserName", IdentifierUtils.toLowerCase((String)userName)).runWith(this.ofBizDelegator).singleValue();
        if (credentials == null) {
            throw new UserNotFoundException(userName);
        }
        String storedCredential = credentials.getString("credential");
        return storedCredential != null ? new PasswordCredential(storedCredential, true) : null;
    }

    public List<PasswordCredential> getCredentialHistory(long directoryId, String userName) throws UserNotFoundException {
        throw new UnsupportedOperationException("JIRA does not store User Credential History");
    }

    public com.atlassian.crowd.model.user.User add(com.atlassian.crowd.model.user.User user, PasswordCredential credential) throws UserAlreadyExistsException {
        if (credential != null) {
            Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted");
        }
        this.throwIfUserAlreadyExists(user);
        try {
            this.userKeyStore.ensureUniqueKeyForNewUser(user.getName());
            Timestamp currentTimestamp = OfBizUserDao.getCurrentTimestamp();
            Map<String, Object> userData = UserEntity.getData(user, credential, currentTimestamp, currentTimestamp);
            GenericValue gvUser = this.ofBizDelegator.createValue("User", userData);
            OfBizUser newUser = OfBizUser.from(gvUser);
            this.userCaseInsensitiveCache.refresh(newUser);
            return newUser;
        }
        catch (DataAccessException ex) {
            this.throwIfUserAlreadyExists(user);
            throw ex;
        }
    }

    @Nonnull
    public BatchResult<com.atlassian.crowd.model.user.User> addAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        BatchResult results = new BatchResult(users.size());
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                com.atlassian.crowd.model.user.User addedUser = this.add((com.atlassian.crowd.model.user.User)user, user.getCredential());
                results.addSuccess((Object)addedUser);
            }
            catch (UserAlreadyExistsException e) {
                results.addFailure((Object)user);
            }
            catch (IllegalArgumentException e) {
                results.addFailure((Object)user);
            }
            catch (DataAccessException e) {
                results.addFailure((Object)user);
            }
        }
        return results;
    }

    private void throwIfUserAlreadyExistsByField(long directoryId, String fieldName, String fieldValue) throws UserAlreadyExistsException {
        String existingUserName = (String)Select.stringColumn("userName").from("User").whereEqual("directoryId", directoryId).andEqual(fieldName, fieldValue).runWith(this.ofBizDelegator).singleValue();
        if (existingUserName != null) {
            throw new UserAlreadyExistsException(directoryId, existingUserName);
        }
    }

    private void throwIfUserAlreadyExists(com.atlassian.crowd.model.user.User user) throws UserAlreadyExistsException {
        long directoryId = user.getDirectoryId();
        String externalId = user.getExternalId();
        if (StringUtils.isNotEmpty((String)externalId)) {
            this.throwIfUserAlreadyExistsByField(directoryId, "externalId", externalId);
        }
        this.throwIfUserAlreadyExistsByField(directoryId, "lowerUserName", IdentifierUtils.toLowerCase((String)user.getName()));
    }

    public void storeAttributes(com.atlassian.crowd.model.user.User user, Map<String, Set<String>> attributes) throws UserNotFoundException {
        Long userId = this.findUserId(user);
        for (Map.Entry<String, Set<String>> entry : ((Map)Assertions.notNull(attributes)).entrySet()) {
            this.updateAttribute(userId, user, entry);
        }
        this.userAttributesCache.remove((Object)new AttributeKey(user.getDirectoryId(), userId));
    }

    private void updateAttribute(Long userId, com.atlassian.crowd.model.user.User user, Map.Entry<String, Set<String>> attribute) throws UserNotFoundException {
        GenericValue attributeGv;
        int i;
        List<GenericValue> oldAttributes = this.getAttributeValues(userId, attribute.getKey(), ORDER_BY_ATTRIBUTE_ID);
        int oldSize = oldAttributes.size();
        int newSize = attribute.getValue().size();
        int commonSize = Math.min(newSize, oldSize);
        Iterator<String> newValues = attribute.getValue().iterator();
        for (i = 0; i < commonSize; ++i) {
            attributeGv = oldAttributes.get(i);
            String oldValue = attributeGv.getString("value");
            String newValue = newValues.next();
            if (StringUtils.isNotEmpty((String)newValue)) {
                if (newValue.equals(oldValue)) continue;
                attributeGv.set("value", (Object)newValue);
                attributeGv.set("lowerValue", (Object)IdentifierUtils.toLowerCase((String)newValue));
                this.ofBizDelegator.store(attributeGv);
                continue;
            }
            this.ofBizDelegator.removeValue(attributeGv);
        }
        for (i = commonSize; i < newSize; ++i) {
            String newValue = newValues.next();
            if (!StringUtils.isNotEmpty((String)newValue)) continue;
            this.storeAttributeValue(user.getDirectoryId(), userId, attribute.getKey(), newValue);
        }
        for (i = commonSize; i < oldSize; ++i) {
            attributeGv = oldAttributes.get(i);
            this.ofBizDelegator.removeValue(attributeGv);
        }
    }

    private void storeAttributeValue(Long directoryId, Long userId, String name, String value) throws UserNotFoundException {
        this.ofBizDelegator.createValue("UserAttribute", UserAttributeEntity.getData(directoryId, userId, name, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttributeForAllInDirectory(long directoryId, String attrName, String attrValue) {
        try {
            new SetAttributeForAllInDirectoryOperation(directoryId, attrName, attrValue).perform();
        }
        finally {
            this.userAttributesCache.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.atlassian.crowd.model.user.User update(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        OfBizUser newUser;
        GenericValue oldUserGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        GenericValue newUserGenericValue = UserEntity.setData(user, (GenericValue)oldUserGenericValue.clone());
        if (this.userDeletedExternally(oldUserGenericValue)) {
            newUserGenericValue.set("deletedExternally", (Object)0);
            newUserGenericValue.set("active", (Object)1);
        }
        newUserGenericValue.set("userName", (Object)oldUserGenericValue.getString("userName"));
        newUserGenericValue.set("updatedDate", (Object)OfBizUserDao.getCurrentTimestamp());
        OfBizUser oldUser = OfBizUser.from(oldUserGenericValue);
        try {
            newUser = OfBizUser.from(this.storeUser(newUserGenericValue));
        }
        finally {
            this.userCaseInsensitiveCache.remove(DirectoryEntityKey.getKeyFor(oldUser));
        }
        this.userCaseInsensitiveCache.refresh(newUser);
        return newUser;
    }

    public void updateCredential(com.atlassian.crowd.model.user.User user, PasswordCredential credential, int credentialHistory) throws UserNotFoundException {
        Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted");
        GenericValue storeGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        storeGenericValue.set("credential", (Object)credential.getCredential());
        this.storeUser(storeGenericValue);
    }

    private GenericValue storeUser(GenericValue userGenericValue) {
        this.ofBizDelegator.store(userGenericValue);
        return userGenericValue;
    }

    public com.atlassian.crowd.model.user.User rename(com.atlassian.crowd.model.user.User oldUser, String newName) throws UserNotFoundException {
        boolean updateAppUserMapping;
        long directoryId = oldUser.getDirectoryId();
        if (IdentifierUtils.equalsInLowerCase((String)newName, (String)oldUser.getName())) {
            updateAppUserMapping = false;
        } else if (this.userKeyStore.getKeyForUsername(newName) == null) {
            updateAppUserMapping = true;
        } else {
            boolean userWillBeShadowed = this.userIsShadowed(newName, directoryId);
            boolean userAlreadyExistsInThisDirectory = this.userExists(newName, directoryId);
            if (userWillBeShadowed) {
                updateAppUserMapping = false;
                if (userAlreadyExistsInThisDirectory) {
                    this.remove((com.atlassian.crowd.model.user.User)this.findOfBizUser(directoryId, newName));
                }
            } else {
                updateAppUserMapping = true;
                String newNameWithQualifier = this.handleAppUserEviction(newName);
                if (userAlreadyExistsInThisDirectory) {
                    this.updateUsernameInCwdTables(directoryId, newName, newNameWithQualifier);
                }
            }
        }
        OfBizUser newUser = this.updateUsernameInCwdTables(directoryId, oldUser.getName(), newName);
        if (updateAppUserMapping) {
            boolean userIsCurrentlyShadowed = this.userIsShadowed(oldUser.getName(), directoryId);
            if (userIsCurrentlyShadowed) {
                this.userKeyStore.ensureUniqueKeyForNewUser(newName);
            } else {
                this.userKeyStore.renameUser(oldUser.getName(), newName);
                if (this.userExistsInAnyDirectory(oldUser.getName())) {
                    this.userKeyStore.ensureUniqueKeyForNewUser(oldUser.getName());
                }
            }
        }
        return newUser;
    }

    public boolean isCacheInitialized() {
        return this.userCaseInsensitiveCache.isCacheInitialized();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OfBizUser updateUsernameInCwdTables(long directoryId, String oldName, String newName) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(directoryId, oldName);
        userGenericValue.set("userName", (Object)newName);
        userGenericValue.set("lowerUserName", (Object)IdentifierUtils.toLowerCase((String)newName));
        userGenericValue.set("updatedDate", (Object)OfBizUserDao.getCurrentTimestamp());
        OfBizUser newUser = OfBizUser.from(this.storeUser(userGenericValue));
        try {
            this.updateGroupMembership(directoryId, oldName, newName);
        }
        finally {
            this.userCaseInsensitiveCache.remove(directoryId, oldName);
        }
        this.userCaseInsensitiveCache.refresh(newUser);
        return newUser;
    }

    protected void updateGroupMembership(long directoryId, String oldName, String newName) {
        FieldMap whereClause = FieldMap.build((String)"directoryId", (Object)directoryId).add("lowerChildName", (Object)IdentifierUtils.toLowerCase((String)oldName)).add("membershipType", (Object)MembershipType.GROUP_USER.name());
        List oldMemberships = this.ofBizDelegator.findByAnd("Membership", (Map)whereClause);
        this.membershipDao.removeAllUserMemberships(directoryId, oldName);
        for (GenericValue oldMembership : oldMemberships) {
            SimpleUserOrGroupStub userStub = new SimpleUserOrGroupStub(oldMembership.getLong("childId"), directoryId, newName);
            SimpleUserOrGroupStub groupStub = new SimpleUserOrGroupStub(oldMembership.getLong("parentId"), directoryId, oldMembership.getString("parentName"));
            try {
                this.membershipDao.addUserToGroup(directoryId, userStub, groupStub);
            }
            catch (MembershipAlreadyExistsException membershipAlreadyExistsException) {}
        }
    }

    private boolean userExistsInAnyDirectory(String username) {
        return Select.id().from("User").whereEqual("lowerUserName", IdentifierUtils.toLowerCase((String)username)).runWith(this.ofBizDelegator).count() > 0L;
    }

    private boolean userIsShadowed(String name, long directoryId) {
        for (Directory directory : this.directoryDao.findAll()) {
            if (directory.getId() == directoryId) {
                return false;
            }
            if (this.findByNameOrNull(directory.getId(), name) == null) continue;
            return true;
        }
        return false;
    }

    private String handleAppUserEviction(String fromUsername) {
        int count = 1;
        String toUsername = fromUsername + "#1";
        while (this.userKeyStore.getKeyForUsername(toUsername) != null) {
            if (count == Integer.MAX_VALUE) {
                throw new IllegalStateException("App user user eviction namespace exhausted");
            }
            toUsername = fromUsername + '#' + ++count;
        }
        this.userKeyStore.renameUser(fromUsername, toUsername);
        return toUsername;
    }

    public BatchResult<String> removeAllUsers(long directoryId, Set<String> userNames) {
        BatchResult results = new BatchResult(userNames.size());
        for (String userName : userNames) {
            try {
                this.remove((com.atlassian.crowd.model.user.User)this.findOfBizUser(directoryId, userName));
                results.addSuccess((Object)userName);
            }
            catch (UserNotFoundException e) {
                results.addFailure((Object)userName);
            }
        }
        return results;
    }

    public Set<String> getAllExternalIds(long directoryId) throws DirectoryNotFoundException {
        this.directoryDao.findById(directoryId);
        final ImmutableSet.Builder builder = ImmutableSet.builder();
        Select.stringColumn("externalId").from("User").whereEqual("directoryId", directoryId).runWith(this.ofBizDelegator).visitWith(new Visitor<String>(){

            public void visit(String externalId) {
                if (externalId != null) {
                    builder.add((Object)externalId);
                }
            }
        });
        return builder.build();
    }

    public long getUserCount(long directoryId) throws DirectoryNotFoundException {
        this.directoryDao.findById(directoryId);
        return Select.from("User").whereEqual("directoryId", directoryId).runWith(this.ofBizDelegator).count();
    }

    public long getUniqueUserCount(Set<Long> directoryIds) throws DirectoryNotFoundException {
        for (long directoryId : directoryIds) {
            this.directoryDao.findById(directoryId);
        }
        return ((GenericValue)Select.columns("count").from("UserNameCount").whereCondition((EntityCondition)new EntityExpr("directoryId", EntityOperator.IN, directoryIds)).runWith(this.ofBizDelegator).singleValue()).getLong("count");
    }

    public void removeAttribute(com.atlassian.crowd.model.user.User user, String attributeName) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        Long userId = userGenericValue.getLong("id");
        this.ofBizDelegator.removeByAnd("UserAttribute", PrimitiveMap.of("userId", (long)userGenericValue.getLong("id"), "name", attributeName));
        this.userAttributesCache.remove((Object)new AttributeKey(user.getDirectoryId(), userId));
    }

    private List<GenericValue> getAttributeValues(Long userId, String attributeName, List<String> orderBy) throws UserNotFoundException {
        return this.ofBizDelegator.findByAnd("UserAttribute", PrimitiveMap.of("userId", (long)userId, "name", attributeName), orderBy);
    }

    public void remove(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        if (!this.allowDeleteUser(user)) {
            this.disableUserDeletedExternally(user);
            return;
        }
        Long userId = this.findUserId(user);
        this.membershipDao.removeAllUserMemberships(user);
        this.ofBizDelegator.removeByAnd("UserAttribute", PrimitiveMap.of("userId", userId));
        int rows = Delete.from("User").whereEqual("directoryId", user.getDirectoryId()).andEqual("lowerUserName", OfBizUserDao.getLowerUserName(user)).execute(this.ofBizDelegator);
        if (rows == 0) {
            throw new UserNotFoundException(user.getName());
        }
        this.userCaseInsensitiveCache.remove(DirectoryEntityKey.getKeyLowerCase((DirectoryEntity)user));
        this.userAttributesCache.remove((Object)new AttributeKey(user.getDirectoryId(), userId));
        ((AuditingManager)ComponentAccessor.getComponent(AuditingManager.class)).store(new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.deleted").forObject((AssociatedItem)new AffectedUser(user)));
    }

    private boolean allowDeleteUser(com.atlassian.crowd.model.user.User user) {
        return this.userExistsInAnotherActiveDirectory(user) || this.userDeleteVeto.allowDeleteUser(ApplicationUsers.from((User)user));
    }

    private boolean userExistsInAnotherActiveDirectory(com.atlassian.crowd.model.user.User user) {
        for (Directory directory : this.directoryDao.findAll()) {
            OfBizUser userInDirectory;
            long directoryId = directory.getId();
            if (!directory.isActive() || directoryId == user.getDirectoryId() || (userInDirectory = this.findByNameOrNull(directoryId, user.getName())) == null) continue;
            return true;
        }
        return false;
    }

    private void disableUserDeletedExternally(com.atlassian.crowd.model.user.User user) {
        GenericValue userGenericValue;
        try {
            userGenericValue = UserEntity.setData(user, this.findUserGenericValue(user.getDirectoryId(), user.getName()));
        }
        catch (UserNotFoundException e) {
            return;
        }
        if (this.userDeletedExternally(userGenericValue)) {
            return;
        }
        OfBizUser oldUser = OfBizUser.from(userGenericValue);
        userGenericValue.set("updatedDate", (Object)OfBizUserDao.getCurrentTimestamp());
        userGenericValue.set("active", (Object)0);
        userGenericValue.set("deletedExternally", (Object)1);
        String displayName = user.getDisplayName();
        if (!displayName.endsWith(DELETED_EXTERNALLY_SUFFIX)) {
            userGenericValue.set("displayName", (Object)(user.getDisplayName() + DELETED_EXTERNALLY_SUFFIX));
        }
        OfBizUser newUser = OfBizUser.from(this.storeUser(userGenericValue));
        this.userCaseInsensitiveCache.refresh(newUser);
        ImmutableList<ChangedValue> changedValues = new ChangedValuesBuilder().addIfDifferent("common.words.fullname", oldUser.getDisplayName(), newUser.getDisplayName()).addIfDifferent("admin.common.phrases.active.inactive", UserEventHandlerImpl.stringBooleanToActiveInactive(oldUser.isActive()), UserEventHandlerImpl.stringBooleanToActiveInactive(newUser.isActive())).build();
        if (!changedValues.isEmpty()) {
            ((AuditingManager)ComponentAccessor.getComponent(AuditingManager.class)).store(new RecordRequest(AuditingCategory.USER_MANAGEMENT, "jira.auditing.user.updated").withChangedValues(changedValues).forObject((AssociatedItem)new AffectedUser(user)));
        }
    }

    private boolean userDeletedExternally(GenericValue userGenericValue) {
        Integer i = userGenericValue.getInteger("deletedExternally");
        return i != null && i != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        List results;
        SearchRestriction searchRestriction = query.getSearchRestriction();
        EntityCondition baseCondition = new UserEntityConditionFactory(this.ofBizDelegator).getEntityConditionFor(searchRestriction);
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        ArrayList<Object> entityConditions = new ArrayList<Object>(2);
        if (baseCondition != null) {
            entityConditions.add(baseCondition);
        }
        entityConditions.add(directoryCondition);
        EntityConditionList entityCondition = new EntityConditionList(entityConditions, EntityOperator.AND);
        EntityFindOptions findOptions = new EntityFindOptions();
        findOptions.setOffset(query.getStartIndex());
        if (query.getMaxResults() >= 0) {
            findOptions.setMaxResults(query.getMaxResults());
        }
        List<String> sortFields = searchRestriction instanceof UnsortedRestriction ? null : Collections.singletonList("lowerUserName");
        List<String> fieldsToSelect = query.getReturnType().equals(String.class) ? Collections.singletonList("userName") : null;
        try (OfBizListIterator iterator = this.ofBizDelegator.findListIteratorByCondition("User", (EntityCondition)entityCondition, null, fieldsToSelect, sortFields, findOptions);){
            results = iterator.getCompleteList();
        }
        ArrayList typedResults = new ArrayList(results.size());
        Class resultType = query.getReturnType();
        Object valueFunction = query.getReturnType().equals(String.class) ? TO_USERNAME_FUNCTION : TO_USER_FUNCTION;
        for (GenericValue result : results) {
            typedResults.add(resultType.cast(valueFunction.get((Object)result)));
        }
        return typedResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> findNamesOfUsersInGroups(Collection<String> groupNames) {
        HashSet<String> results = new HashSet<String>();
        List groupNamesLowerCase = groupNames.stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toList());
        EntityExpr membershipTypeCondition = new EntityExpr("membershipType", EntityOperator.EQUALS, (Object)MembershipType.GROUP_USER.name());
        EntityExpr nameCondition = new EntityExpr("lowerParentName", EntityOperator.IN, groupNamesLowerCase);
        EntityExprList condition = new EntityExprList((List)ImmutableList.of((Object)membershipTypeCondition, (Object)nameCondition), EntityOperator.AND);
        try (OfBizListIterator iterator = this.ofBizDelegator.findListIteratorByCondition("Membership", (EntityCondition)condition, null, (Collection)ImmutableSet.of((Object)"lowerChildName"), null, null);){
            GenericValue curItem;
            do {
                if ((curItem = iterator.next()) == null) continue;
                results.add(curItem.getString("lowerChildName"));
            } while (curItem != null);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllAttributeKeys() {
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        try (OfBizListIterator iterator = this.ofBizDelegator.findListIteratorByCondition("UserAttribute", null, null, Collections.singleton("name"), null, EntityFindOptions.findOptions().distinct());){
            GenericValue gv;
            do {
                if ((gv = iterator.next()) == null) continue;
                keys.add(gv.getString("name"));
            } while (gv != null);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUsers(Consumer<? super com.atlassian.crowd.model.user.User> userProcessor) {
        EntityExpr directoryCondition = new EntityExpr("directoryActive", EntityOperator.NOT_EQUAL, (Object)0);
        EntityFindOptions efo = EntityFindOptions.findOptions().fetchSize(1000);
        OfBizUser curUser = null;
        try (OfBizListIterator iterator = this.ofBizDelegator.findListIteratorByCondition("UserWithDirectory", (EntityCondition)directoryCondition, null, null, (List)ImmutableList.of((Object)"lowerUserName", (Object)"position"), efo);){
            GenericValue gv;
            do {
                if ((gv = iterator.next()) == null) continue;
                String gvUserName = gv.getString("lowerUserName");
                if (curUser != null && curUser.getLowerName().equals(gvUserName)) continue;
                curUser = OfBizUser.from(gv);
                userProcessor.accept((com.atlassian.crowd.model.user.User)curUser);
            } while (gv != null);
        }
    }

    public void flushCache() {
        this.userCaseInsensitiveCache.refresh();
        this.userAttributesCache.removeAll();
    }

    @Nonnull
    private GenericValue findUserGenericValue(long directoryId, String userName) throws UserNotFoundException {
        GenericValue userGenericValue = (GenericValue)Select.from("User").whereEqual("directoryId", directoryId).andEqual("lowerUserName", IdentifierUtils.toLowerCase((String)userName)).runWith(this.ofBizDelegator).singleValue();
        if (userGenericValue == null) {
            throw new UserNotFoundException(userName);
        }
        return userGenericValue;
    }

    @Nonnull
    private Long findUserId(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        Long id = (Long)Select.id().from("User").whereEqual("directoryId", user.getDirectoryId()).andEqual("lowerUserName", OfBizUserDao.getLowerUserName(user)).runWith(this.ofBizDelegator).singleValue();
        if (id == null) {
            throw new UserNotFoundException(user.getName());
        }
        return id;
    }

    private boolean userExists(String name, long directoryId) {
        return this.findByNameOrNull(directoryId, name) != null;
    }

    private static String getLowerUserName(com.atlassian.crowd.model.user.User user) {
        if (user instanceof OfBizUser) {
            return ((OfBizUser)user).getLowerName();
        }
        return IdentifierUtils.toLowerCase((String)user.getName());
    }

    private static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    class SetAttributeForAllInDirectoryOperation {
        private final Long directoryId;
        private final String attrName;
        private final String attrValue;
        private final String lowerAttrValue;
        private Set<Long> userIds = new HashSet<Long>(16384);
        private Set<Long> errors = new HashSet<Long>(64);
        private int updated = 0;
        private int created = 0;

        SetAttributeForAllInDirectoryOperation(long directoryId, String attrName, String attrValue) {
            this.directoryId = directoryId;
            this.attrName = attrName;
            this.attrValue = attrValue;
            this.lowerAttrValue = IdentifierUtils.toLowerCase((String)attrValue);
        }

        private void updateExisting() {
            this.updated = Update.into("UserAttribute").set("value", this.attrValue).set("lowerValue", this.lowerAttrValue).whereEqual("directoryId", this.directoryId).andEqual("name", this.attrName).execute(OfBizUserDao.this.ofBizDelegator);
        }

        private void collectAllUserIdsInDirectory() {
            Select.id().from("User").whereEqual("directoryId", this.directoryId).runWith(OfBizUserDao.this.ofBizDelegator).visitWith(new Visitor<Long>(){

                public void visit(Long userId) {
                    SetAttributeForAllInDirectoryOperation.this.userIds.add(userId);
                }
            });
        }

        private void discardUserIdsWithMatchingAttribute() {
            Select.columns("userId").from("UserAttribute").whereEqual("directoryId", this.directoryId).andEqual("name", this.attrName).runWith(OfBizUserDao.this.ofBizDelegator).visitWith(new Visitor<GenericValue>(){

                public void visit(GenericValue userIdHolder) {
                    SetAttributeForAllInDirectoryOperation.this.userIds.remove(userIdHolder.getLong("userId"));
                }
            });
        }

        private void createAttributeForRemainingUserIds() {
            for (Long userId : this.userIds) {
                this.createAttribute(userId);
            }
        }

        private void createAttribute(Long userId) {
            try {
                OfBizUserDao.this.ofBizDelegator.createValue("UserAttribute", (Map)new FieldMap().add("directoryId", (Object)this.directoryId).add("userId", (Object)userId).add("name", (Object)this.attrName).add("value", (Object)this.attrValue).add("lowerValue", (Object)this.lowerAttrValue));
                ++this.created;
            }
            catch (DataAccessException dae) {
                this.errors.add(userId);
                log.debug((Object)"Failed to create attribute", (Throwable)dae);
            }
        }

        void perform() {
            this.updateExisting();
            this.collectAllUserIdsInDirectory();
            this.discardUserIdsWithMatchingAttribute();
            this.createAttributeForRemainingUserIds();
            if (!this.errors.isEmpty()) {
                log.warn((Object)("setAttributeForAllInDirectory(" + this.directoryId + ", \"" + this.attrName + "\", \"" + this.attrValue + "\"): created=" + this.created + "; updated=" + this.updated + "; errors=" + this.errors));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("setAttributeForAllInDirectory(" + this.directoryId + ", \"" + this.attrName + "\", \"" + this.attrValue + "\"): created=" + this.created + "; updated=" + this.updated));
            }
        }
    }

    private class UserAttributesCacheLoader
    implements CacheLoader<AttributeKey, Attributes> {
        private UserAttributesCacheLoader() {
        }

        @Nonnull
        public Attributes load(@Nonnull AttributeKey key) {
            List<GenericValue> attributes = Select.columns(OfBizAttributesBuilder.SUPPORTED_FIELDS).from("UserAttribute").whereEqual("directoryId", key.getDirectoryId()).andEqual("userId", key.getUserId()).runWith(OfBizUserDao.this.ofBizDelegator).asList();
            return OfBizAttributesBuilder.toAttributes(attributes);
        }
    }
}

