/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.datetime;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeCompleteFormatter;
import com.atlassian.jira.datetime.DateTimeFormatStrategy;
import com.atlassian.jira.datetime.DateTimeFormatterServiceProvider;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.datetime.DateTimeTimeFormatter;
import com.atlassian.jira.datetime.JodaFormatterSupplier;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.concurrent.ThreadSafe;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

@ThreadSafe
class DateTimeRelativeFormatter
implements DateTimeFormatStrategy {
    private final DateTimeFormatterServiceProvider serviceProvider;
    private final JodaFormatterSupplier jodaFormatterSupplier;
    private final ApplicationProperties applicationProperties;
    private final Clock clock;
    private final DateTimeTimeFormatter timeFormatter;
    private final DateTimeCompleteFormatter completeFormatter;

    public DateTimeRelativeFormatter(DateTimeFormatterServiceProvider serviceProvider, JodaFormatterSupplier jodaFormatterSupplier, ApplicationProperties applicationProperties, Clock clock) {
        this.serviceProvider = serviceProvider;
        this.jodaFormatterSupplier = jodaFormatterSupplier;
        this.applicationProperties = applicationProperties;
        this.clock = clock;
        this.timeFormatter = new DateTimeTimeFormatter(serviceProvider, jodaFormatterSupplier);
        this.completeFormatter = new DateTimeCompleteFormatter(serviceProvider, jodaFormatterSupplier);
    }

    @Override
    public String format(DateTime dateTime, Locale locale) {
        DateTime todayStartOfDay;
        DateTime now = new DateTime((Object)this.clock.getCurrentDate(), dateTime.getZone());
        if (!this.isRelativeDateFormattingEnabled()) {
            return this.completeFormatter.format(dateTime, locale);
        }
        DateTime formatStartOfDay = new LocalDate((Object)dateTime).toDateTimeAtStartOfDay();
        int days = Days.daysBetween((ReadableInstant)formatStartOfDay, (ReadableInstant)(todayStartOfDay = new LocalDate((Object)now).toDateTimeAtStartOfDay())).getDays();
        if (days < 0) {
            return this.completeFormatter.format(dateTime, locale);
        }
        if (days < 1) {
            String todayFmt = this.serviceProvider.getUnescapedText("common.concepts.today");
            return new MessageFormat(todayFmt).format(new Object[]{this.timeFormatter.format(dateTime, locale)});
        }
        if (days < 2) {
            String yesterdayFmt = this.serviceProvider.getUnescapedText("common.concepts.yesterday");
            return new MessageFormat(yesterdayFmt).format(new Object[]{this.timeFormatter.format(dateTime, locale)});
        }
        if (days < 7) {
            String pattern = this.serviceProvider.getDefaultBackedString("jira.lf.date.day");
            return this.jodaFormatterSupplier.get(new JodaFormatterSupplier.Key(pattern, locale)).print((ReadableInstant)dateTime);
        }
        return this.completeFormatter.format(dateTime, locale);
    }

    @Override
    public Date parse(String text, DateTimeZone timeZone, Locale locale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DateTimeStyle style() {
        return DateTimeStyle.RELATIVE;
    }

    @Override
    public String pattern() {
        return this.completeFormatter.pattern();
    }

    protected boolean isRelativeDateFormattingEnabled() {
        return this.applicationProperties.getOption("jira.lf.date.relativize");
    }
}

