/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalIssue;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AbstractPersisterHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.parser.IssueParser;
import com.atlassian.jira.imports.project.parser.IssueParserImpl;
import com.atlassian.jira.imports.project.transformer.IssueTransformer;
import com.atlassian.jira.imports.project.transformer.IssueTransformerImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ImportUtils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuePersisterHandler
extends AbstractPersisterHandler
implements ImportOfBizEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(IssuePersisterHandler.class);
    private final ProjectImportPersister projectImportPersister;
    private final ProjectImportMapper projectImportMapper;
    private final ApplicationUser importAuthor;
    private final ProjectImportResults projectImportResults;
    private final Date importDate;
    private IssueParser issueParser;
    private IssueTransformer issueTransformer;
    private long largestIssueKeyNumber = 0L;

    public IssuePersisterHandler(ProjectImportPersister projectImportPersister, ProjectImportMapper projectImportMapper, ApplicationUser importAuthor, ProjectImportResults projectImportResults, Executor executor) {
        super(executor, projectImportResults);
        this.projectImportPersister = projectImportPersister;
        this.projectImportMapper = projectImportMapper;
        this.importAuthor = importAuthor;
        this.projectImportResults = projectImportResults;
        this.importDate = this.getImportDate();
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException, AbortImportException {
        if ("Issue".equals(entityName)) {
            final ExternalIssue oldIssue = this.getIssueParser().parse(attributes);
            final ExternalIssue transformedIssue = this.getIssueTransformer().transform(this.projectImportMapper, oldIssue);
            this.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ImportUtils.setSubvertSecurityScheme((boolean)true);
                        ImportUtils.setIndexIssues((boolean)false);
                        ImportUtils.setEnableNotifications((boolean)false);
                        Issue createdIssue = IssuePersisterHandler.this.projectImportPersister.createIssue(transformedIssue, IssuePersisterHandler.this.importDate, IssuePersisterHandler.this.importAuthor);
                        if (createdIssue != null) {
                            IssuePersisterHandler.this.projectImportMapper.getIssueMapper().mapValue(oldIssue.getId(), createdIssue.getId().toString());
                            IssuePersisterHandler.this.updateLargestIssueKeyNumber(createdIssue.getKey());
                            IssuePersisterHandler.this.projectImportResults.incrementIssuesCreatedCount();
                        } else {
                            IssuePersisterHandler.this.projectImportResults.addError(IssuePersisterHandler.this.projectImportResults.getI18n().getText("admin.errors.project.import.could.not.create.issue", oldIssue.getKey()));
                        }
                    }
                    finally {
                        ImportUtils.setSubvertSecurityScheme((boolean)false);
                        ImportUtils.setIndexIssues((boolean)true);
                        ImportUtils.setEnableNotifications((boolean)true);
                    }
                }
            });
        }
    }

    public long getLargestIssueKeyNumber() {
        return this.largestIssueKeyNumber;
    }

    IssueTransformer getIssueTransformer() {
        if (this.issueTransformer == null) {
            this.issueTransformer = new IssueTransformerImpl();
        }
        return this.issueTransformer;
    }

    IssueParser getIssueParser() {
        if (this.issueParser == null) {
            this.issueParser = new IssueParserImpl();
        }
        return this.issueParser;
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    Date getImportDate() {
        return new Date();
    }

    private void updateLargestIssueKeyNumber(String key) {
        int index = key.lastIndexOf(45);
        if (index == -1) {
            log.warn("Created an issue with a key with no '-' in it ('" + key + "').");
            return;
        }
        try {
            long keyNumber = Long.parseLong(key.substring(index + 1));
            if (keyNumber > this.largestIssueKeyNumber) {
                this.largestIssueKeyNumber = keyNumber;
            }
        }
        catch (NumberFormatException e) {
            log.warn("Unable to extract the numeric part of the Issue key '" + key + "'.");
        }
    }
}

