/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalAttachment;
import com.atlassian.jira.external.beans.ExternalChangeGroup;
import com.atlassian.jira.external.beans.ExternalComment;
import com.atlassian.jira.external.beans.ExternalComponent;
import com.atlassian.jira.external.beans.ExternalProjectRoleActor;
import com.atlassian.jira.external.beans.ExternalVoter;
import com.atlassian.jira.external.beans.ExternalWatcher;
import com.atlassian.jira.external.beans.ExternalWorklog;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.mapper.UserMapper;
import com.atlassian.jira.imports.project.parser.AttachmentParser;
import com.atlassian.jira.imports.project.parser.AttachmentParserImpl;
import com.atlassian.jira.imports.project.parser.ChangeGroupParser;
import com.atlassian.jira.imports.project.parser.ChangeGroupParserImpl;
import com.atlassian.jira.imports.project.parser.CommentParser;
import com.atlassian.jira.imports.project.parser.CommentParserImpl;
import com.atlassian.jira.imports.project.parser.ProjectRoleActorParser;
import com.atlassian.jira.imports.project.parser.ProjectRoleActorParserImpl;
import com.atlassian.jira.imports.project.parser.UserAssociationParser;
import com.atlassian.jira.imports.project.parser.UserAssociationParserImpl;
import com.atlassian.jira.imports.project.parser.WorklogParser;
import com.atlassian.jira.imports.project.parser.WorklogParserImpl;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import java.util.Map;

public class UserMapperHandler
implements ImportOfBizEntityHandler {
    private final BackupProject backupProject;
    private final UserMapper userMapper;
    private final AttachmentStore attachmentStore;
    private CommentParser commentParser;
    private WorklogParser worklogParser;
    private ChangeGroupParser changeGroupParser;
    private ProjectRoleActorParser projectRoleActorParser;
    private UserAssociationParser userAssociationParser;
    private AttachmentParser attachmentParser;
    private final ProjectImportOptions projectImportOptions;

    public UserMapperHandler(ProjectImportOptions projectImportOptions, BackupProject backupProject, UserMapper userMapper, AttachmentStore attachmentStore) {
        this.projectImportOptions = projectImportOptions;
        this.backupProject = backupProject;
        this.userMapper = userMapper;
        this.attachmentStore = attachmentStore;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if ("UserAssociation".equals(entityName)) {
            this.handleUserAssociation(attributes);
        } else if ("Action".equals(entityName)) {
            this.handleAction(attributes);
        } else if ("Worklog".equals(entityName)) {
            this.handleWorklog(attributes);
        } else if ("ChangeGroup".equals(entityName)) {
            this.handleChangeGroup(attributes);
        } else if ("FileAttachment".equals(entityName)) {
            this.handleAttachment(attributes);
        } else if ("ProjectRoleActor".equals(entityName)) {
            this.handleProjectRoleActor(attributes);
        }
    }

    private void handleProjectRoleActor(Map attributes) throws ParseException {
        ExternalProjectRoleActor externalProjectRoleActor = this.getProjectRoleActorParser().parse(attributes);
        if (this.backupProject.getProject().getId().equals(externalProjectRoleActor.getProjectId()) && externalProjectRoleActor.isUserActor()) {
            this.userMapper.flagUserAsInUse(externalProjectRoleActor.getRoleActor());
        }
    }

    private void handleChangeGroup(Map attributes) throws ParseException {
        ExternalChangeGroup externalChangeGroup = this.getChangeGroupParser().parse(attributes);
        if (externalChangeGroup != null && this.backupProject.containsIssue(externalChangeGroup.getIssueId())) {
            this.userMapper.flagUserAsInUse(externalChangeGroup.getAuthor());
        }
    }

    private void handleWorklog(Map attributes) throws ParseException {
        ExternalWorklog externalWorklog = this.getWorklogParser().parse(attributes);
        if (externalWorklog != null && this.backupProject.containsIssue(externalWorklog.getIssueId())) {
            this.userMapper.flagUserAsInUse(externalWorklog.getAuthor());
            this.userMapper.flagUserAsInUse(externalWorklog.getUpdateAuthor());
        }
    }

    private void handleAction(Map attributes) throws ParseException {
        ExternalComment externalComment = this.getCommentParser().parse(attributes);
        if (externalComment != null && this.backupProject.containsIssue(externalComment.getIssueId())) {
            this.userMapper.flagUserAsInUse(externalComment.getUsername());
            this.userMapper.flagUserAsInUse(externalComment.getUpdateAuthor());
        }
    }

    private void handleAttachment(Map<String, String> attributes) throws ParseException {
        ExternalAttachment externalAttachment;
        if (this.projectImportOptions != null && this.projectImportOptions.getAttachmentPath() != null && (externalAttachment = this.getAttachmentParser().parse(attributes)) != null && this.backupProject.containsIssue(externalAttachment.getIssueId())) {
            this.userMapper.flagUserAsInUse(externalAttachment.getAttacher());
        }
    }

    private void handleUserAssociation(Map attributes) throws ParseException {
        ExternalWatcher externalWatcher;
        ExternalVoter externalVoter = this.getUserAssociationParser().parseVoter(attributes);
        if (externalVoter != null && this.backupProject.containsIssue(externalVoter.getIssueId())) {
            this.userMapper.flagUserAsInUse(externalVoter.getVoter());
        }
        if ((externalWatcher = this.getUserAssociationParser().parseWatcher(attributes)) != null && this.backupProject.containsIssue(externalWatcher.getIssueId())) {
            this.userMapper.flagUserAsInUse(externalWatcher.getWatcher());
        }
    }

    public void endDocument() {
        if (this.projectImportOptions != null && this.projectImportOptions.overwriteProjectDetails()) {
            this.userMapper.flagUserAsMandatory(this.backupProject.getProject().getLead());
        }
        for (ExternalComponent externalComponent : this.backupProject.getProjectComponents()) {
            if (externalComponent.getLead() == null) continue;
            this.userMapper.flagUserAsMandatory(externalComponent.getLead());
        }
    }

    ChangeGroupParser getChangeGroupParser() {
        if (this.changeGroupParser == null) {
            this.changeGroupParser = new ChangeGroupParserImpl();
        }
        return this.changeGroupParser;
    }

    ProjectRoleActorParser getProjectRoleActorParser() {
        if (this.projectRoleActorParser == null) {
            this.projectRoleActorParser = new ProjectRoleActorParserImpl();
        }
        return this.projectRoleActorParser;
    }

    UserAssociationParser getUserAssociationParser() {
        if (this.userAssociationParser == null) {
            this.userAssociationParser = new UserAssociationParserImpl();
        }
        return this.userAssociationParser;
    }

    WorklogParser getWorklogParser() {
        if (this.worklogParser == null) {
            this.worklogParser = new WorklogParserImpl();
        }
        return this.worklogParser;
    }

    CommentParser getCommentParser() {
        if (this.commentParser == null) {
            this.commentParser = new CommentParserImpl();
        }
        return this.commentParser;
    }

    AttachmentParser getAttachmentParser() {
        if (this.attachmentParser == null) {
            this.attachmentParser = new AttachmentParserImpl(this.attachmentStore, this.projectImportOptions.getAttachmentPath());
        }
        return this.attachmentParser;
    }

    public void startDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserMapperHandler that = (UserMapperHandler)o;
        if (this.attachmentParser != null ? !this.attachmentParser.equals(that.attachmentParser) : that.attachmentParser != null) {
            return false;
        }
        if (this.backupProject != null ? !this.backupProject.equals(that.backupProject) : that.backupProject != null) {
            return false;
        }
        if (this.changeGroupParser != null ? !this.changeGroupParser.equals(that.changeGroupParser) : that.changeGroupParser != null) {
            return false;
        }
        if (this.commentParser != null ? !this.commentParser.equals(that.commentParser) : that.commentParser != null) {
            return false;
        }
        if (this.userAssociationParser != null ? !this.userAssociationParser.equals(that.userAssociationParser) : that.userAssociationParser != null) {
            return false;
        }
        if (this.userMapper != null ? !this.userMapper.equals(that.userMapper) : that.userMapper != null) {
            return false;
        }
        return !(this.worklogParser != null ? !this.worklogParser.equals(that.worklogParser) : that.worklogParser != null);
    }

    public int hashCode() {
        int result = this.backupProject != null ? this.backupProject.hashCode() : 0;
        result = 31 * result + (this.userMapper != null ? this.userMapper.hashCode() : 0);
        result = 31 * result + (this.commentParser != null ? this.commentParser.hashCode() : 0);
        result = 31 * result + (this.worklogParser != null ? this.worklogParser.hashCode() : 0);
        result = 31 * result + (this.changeGroupParser != null ? this.changeGroupParser.hashCode() : 0);
        result = 31 * result + (this.userAssociationParser != null ? this.userAssociationParser.hashCode() : 0);
        result = 31 * result + (this.attachmentParser != null ? this.attachmentParser.hashCode() : 0);
        return result;
    }
}

