/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.taskprogress;

import com.atlassian.jira.imports.project.taskprogress.AbstractSubtaskProgressProcessor;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressInterval;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressProcessor;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;

public class EntityCountTaskProgressProcessor
extends AbstractSubtaskProgressProcessor
implements TaskProgressProcessor {
    private final TaskProgressSink taskProgressSink;
    private final String subTaskName;
    private final I18nHelper i18n;

    public EntityCountTaskProgressProcessor(TaskProgressInterval taskProgressInterval, String subTaskName, int numEntities, I18nHelper i18n) {
        super(taskProgressInterval, numEntities);
        this.taskProgressSink = taskProgressInterval == null ? null : taskProgressInterval.getTaskProgressSink();
        this.subTaskName = subTaskName;
        this.i18n = i18n;
    }

    @Override
    public void processTaskProgress(String entityTypeName, int entityTypeCount, long entityCount, long currentEntityCount) {
        this.processTaskProgress(entityTypeName, entityCount);
    }

    public void processTaskProgress(String entityTypeName, long entityCount) {
        if (this.taskProgressSink == null) {
            return;
        }
        long percent = this.getOverallPercentageComplete(entityCount);
        this.taskProgressSink.makeProgress(percent, this.subTaskName + ". " + this.i18n.getText("admin.message.task.progress.processing", entityTypeName), this.i18n.getText("admin.message.task.progress.entity.of", entityCount + "", this.getNumEntities() + ""));
    }
}

