/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.util;

import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFiles;
import com.atlassian.jira.util.TempDirectoryUtil;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectImportTemporaryFilesImpl
implements ProjectImportTemporaryFiles {
    private static final Logger log = LoggerFactory.getLogger(ProjectImportTemporaryFilesImpl.class);
    private final File parentDirectory;
    private final Map<String, File> entityToXmlFileMap;
    private final String encoding;
    private final Map<String, PrintWriter> writers;

    public ProjectImportTemporaryFilesImpl(String projectKey, Set<String> entities, String encoding) throws IOException {
        this.parentDirectory = TempDirectoryUtil.createTempDirectory("JiraProjectImport" + projectKey);
        this.writers = new HashMap<String, PrintWriter>();
        this.entityToXmlFileMap = new HashMap<String, File>();
        this.encoding = encoding;
        for (String entity : entities) {
            this.openWriter(entity);
        }
    }

    @Override
    public File getEntityXmlFile(String entity) {
        return this.entityToXmlFileMap.get(entity);
    }

    @Override
    public void deleteTempFiles() {
        try {
            FileUtils.deleteDirectory((File)this.parentDirectory);
        }
        catch (IOException e) {
            log.warn("Unable to delete temporary files", (Throwable)e);
        }
    }

    @Override
    public PrintWriter getWriter(String entity) throws IOException {
        PrintWriter printWriter = this.writers.get(entity);
        if (printWriter == null) {
            printWriter = this.openWriter(entity);
        }
        return printWriter;
    }

    private PrintWriter openWriter(String entity) throws IOException {
        File xmlFile = this.getEntityXmlFile(entity);
        if (xmlFile == null) {
            xmlFile = new File(this.parentDirectory, entity + ".xml");
            xmlFile.createNewFile();
            xmlFile.deleteOnExit();
            this.entityToXmlFileMap.put(entity, xmlFile);
        }
        FileOutputStream fos = new FileOutputStream(xmlFile);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, this.encoding);
        BufferedWriter bufferedWriter = new BufferedWriter(out, 32768);
        PrintWriter printWriter = new PrintWriter(bufferedWriter);
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + this.getEncoding() + "\"?>");
        printWriter.println("<entity-engine-xml>");
        this.writers.put(entity, printWriter);
        return printWriter;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void closeWriters() {
        for (PrintWriter printWriter : this.writers.values()) {
            printWriter.print("</entity-engine-xml>");
            printWriter.close();
        }
    }

    @Override
    @VisibleForTesting
    public File getParentDirectory() {
        return this.parentDirectory;
    }
}

