/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.fugue.Option;
import com.atlassian.jira.index.EntitySearchExtractor;
import com.atlassian.jira.index.GenericSearchExtractorContext;
import com.atlassian.jira.issue.index.indexers.impl.FieldIndexerUtil;
import com.google.common.base.Function;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public interface EntityDocumentFactory<T>
extends Function<T, Option<Document>> {

    public static abstract class EntityDocumentBuilder<T, C extends EntityDocumentBuilder<T, C>> {
        protected final Document doc = new Document();
        private final GenericSearchExtractorContext<T> context;

        protected EntityDocumentBuilder(T entity, String indexName) {
            this.context = new GenericSearchExtractorContext<T>(entity, indexName);
        }

        public C addAllExtractors(Collection<EntitySearchExtractor<T>> extractors) {
            for (EntitySearchExtractor<T> extractor : extractors) {
                try {
                    this.fieldsAddedByExtractor(extractor.indexEntity(this.context, this.doc));
                }
                catch (RuntimeException runtimeException) {
                }
                catch (LinkageError linkageError) {}
            }
            return this.cast();
        }

        public C addField(String name, String value, Field.Store store, Field.Index index) {
            this.doc.add((Fieldable)new Field(name, value, store, index));
            return this.cast();
        }

        public C addKeywordWithDefault(String name, String value, String defaultValue) {
            FieldIndexerUtil.indexKeywordWithDefault((Document)this.doc, (String)name, (String)value, (String)defaultValue);
            return this.cast();
        }

        public C addKeywordWithDefault(String name, Long value, String defaultValue) {
            FieldIndexerUtil.indexKeywordWithDefault((Document)this.doc, (String)name, (Long)value, (String)defaultValue);
            return this.cast();
        }

        protected void fieldsAddedByExtractor(Set<String> fieldIds) {
        }

        private C cast() {
            return (C)this;
        }

        public Option<Document> build() {
            return Option.some((Object)this.doc);
        }
    }
}

