/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation;

import com.atlassian.instrumentation.caches.CacheKeys;
import com.atlassian.instrumentation.caches.RequestListener;
import com.atlassian.jira.instrumentation.CacheStatistics;
import com.atlassian.vcache.internal.LongMetric;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.core.metrics.DefaultLongMetric;
import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class CacheStatisticsUtils {
    private CacheStatisticsUtils() {
    }

    public static CacheStatistics fromRequestListenerStatistics(RequestListener requestListener, String cacheType) {
        Map stats = requestListener.onRequestEnd();
        return new CacheStatistics.CacheStatisticsBuilder().withName(requestListener.getName()).withTags(requestListener.getTags()).withType(cacheType).withHits(stats.getOrDefault(CacheKeys.HITS.getName(), 0L)).withMisses(stats.getOrDefault(CacheKeys.MISSES.getName(), 0L)).withLoadTime(stats.getOrDefault(CacheKeys.LOAD_TIME.getName(), 0.0)).withOtherStats(stats).build();
    }

    public static CacheStatistics fromVCacheStatistics(String name, String cacheType, EnumMap<MetricLabel, LongMetric> metrics) {
        DefaultLongMetric emptyMetric = new DefaultLongMetric();
        HashMap<String, LongMetric> otherStats = new HashMap<String, LongMetric>(metrics.size());
        for (Map.Entry<MetricLabel, LongMetric> entry : metrics.entrySet()) {
            otherStats.put(entry.getKey().name().toLowerCase(), entry.getValue());
        }
        return new CacheStatistics.CacheStatisticsBuilder().withName(name).withTags((List<String>)ImmutableList.of((Object)"cache", (Object)"vcache", (Object)cacheType)).withType(cacheType).withHits((int)metrics.getOrDefault(MetricLabel.NUMBER_OF_HITS, (LongMetric)emptyMetric).getSampleCount()).withMisses((int)metrics.getOrDefault(MetricLabel.NUMBER_OF_MISSES, (LongMetric)emptyMetric).getSampleCount()).withLoadTime(CacheStatisticsUtils.mean(metrics.getOrDefault(MetricLabel.TIMED_SUPPLIER_CALL, (LongMetric)emptyMetric))).withGetTime(CacheStatisticsUtils.mean(metrics.getOrDefault(MetricLabel.TIMED_GET_CALL, (LongMetric)emptyMetric))).withPutTime(CacheStatisticsUtils.mean(metrics.getOrDefault(MetricLabel.TIMED_PUT_CALL, (LongMetric)emptyMetric))).withOtherStats(otherStats).build();
    }

    public static Stream<CacheStatistics> convertVCacheMetrics(String cacheType, Map<String, EnumMap<MetricLabel, ? extends LongMetric>> cachesMetrics) {
        return cachesMetrics.entrySet().stream().map(m -> CacheStatisticsUtils.fromVCacheStatistics((String)m.getKey(), cacheType, (EnumMap)m.getValue()));
    }

    private static long mean(LongMetric metric) {
        return metric.getSampleCount() == 0L ? 0L : metric.getSamplesTotal() / metric.getSampleCount();
    }
}

