/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.jdbc;

import com.atlassian.instrumentation.caches.RequestListener;
import com.atlassian.instrumentation.driver.JdbcThreadLocalCollector;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;

public class JdbcCollector
implements RequestListener {
    private static final String JDBC_LOGGING_KEY = "jdbc";

    public String getName() {
        return JDBC_LOGGING_KEY;
    }

    public void onRequestStart() {
        JdbcThreadLocalCollector.start();
    }

    public String getLoggingKey() {
        return JDBC_LOGGING_KEY;
    }

    public Map<String, Object> onRequestEnd() {
        Map counts = JdbcThreadLocalCollector.getStatistics();
        Map medians = JdbcThreadLocalCollector.getMedianTime();
        JdbcThreadLocalCollector.clear();
        HashMap<String, Object> result = new HashMap<String, Object>();
        counts.keySet().forEach(key -> {
            LongSummaryStatistics stats = (LongSummaryStatistics)counts.get(key);
            result.put((String)key, ImmutableMap.of((Object)"count", (Object)stats.getCount(), (Object)"average", (Object)stats.getAverage(), (Object)"median", medians.get(key), (Object)"max", (Object)stats.getMax(), (Object)"min", (Object)stats.getMin()));
        });
        return result;
    }

    public List<String> getTags() {
        return Collections.singletonList(JDBC_LOGGING_KEY);
    }

    public boolean isEnabled() {
        return true;
    }

    public void setEnabled(boolean enabled) {
    }
}

