/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.search;

import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.instrumentation.operations.SimpleOpTimer;
import com.atlassian.jira.instrumentation.DeltaResultCounter;
import com.atlassian.jira.instrumentation.ResultCounter;
import com.atlassian.jira.sharing.SharedEntitySearchEvent;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class SearchCounter {
    private final SharedEntitySearchEvent sharedEntitySearchEvent;
    private final SimpleOpTimer indexExecution;
    private final Integer indexHash;
    private final SimpleOpTimer databaseExecution;
    private final Integer databaseHash;

    public SearchCounter(SharedEntitySearchEvent sharedEntitySearchEvent, SimpleOpTimer indexExecution, Integer indexHash, SimpleOpTimer databaseExecution, Integer databaseHash) {
        this.sharedEntitySearchEvent = sharedEntitySearchEvent;
        this.indexExecution = indexExecution;
        this.indexHash = indexHash;
        this.databaseExecution = databaseExecution;
        this.databaseHash = databaseHash;
    }

    public Map<String, Object> asMap() {
        ResultCounter indexTimer = this.convertTimer(this.indexExecution);
        ResultCounter dbTimer = this.convertTimer(this.databaseExecution);
        ResultCounter delta = this.computeDelta();
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"parameters", (Object)this.sharedEntitySearchEvent);
        SearchCounter.addIfNonNull((ImmutableMap.Builder<String, Object>)builder, "index", indexTimer);
        SearchCounter.addIfNonNull((ImmutableMap.Builder<String, Object>)builder, "db", dbTimer);
        SearchCounter.addIfNonNull((ImmutableMap.Builder<String, Object>)builder, "delta", delta);
        return builder.build();
    }

    private ResultCounter convertTimer(SimpleOpTimer simpleOpTimer) {
        if (simpleOpTimer == null) {
            return null;
        }
        OpSnapshot snapshot = simpleOpTimer.snapshot();
        return new ResultCounter(snapshot.getMillisecondsTaken(), snapshot.getResultSetSize());
    }

    private ResultCounter computeDelta() {
        if (this.indexExecution == null || this.databaseExecution == null) {
            return null;
        }
        boolean equiv = false;
        if (this.indexHash == null && this.databaseHash == null) {
            equiv = true;
        } else if (this.indexHash != null && this.databaseHash != null) {
            equiv = this.indexExecution.snapshot().getResultSetSize() - this.databaseExecution.snapshot().getResultSetSize() == 0L && this.indexHash.equals(this.databaseHash);
        }
        return new DeltaResultCounter(this.indexExecution.snapshot().getMillisecondsTaken() - this.databaseExecution.snapshot().getMillisecondsTaken(), this.indexExecution.snapshot().getResultSetSize() - this.databaseExecution.snapshot().getResultSetSize(), equiv);
    }

    private static void addIfNonNull(ImmutableMap.Builder<String, Object> builder, String key, Object value) {
        if (value != null) {
            builder.put((Object)key, value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchCounter)) {
            return false;
        }
        SearchCounter that = (SearchCounter)o;
        if (!this.sharedEntitySearchEvent.equals(that.sharedEntitySearchEvent)) {
            return false;
        }
        if (this.indexExecution != null ? !this.indexExecution.equals(that.indexExecution) : that.indexExecution != null) {
            return false;
        }
        return !(this.databaseExecution == null ? that.databaseExecution != null : !this.databaseExecution.equals(that.databaseExecution));
    }

    public int hashCode() {
        int result = this.sharedEntitySearchEvent.hashCode();
        result = 31 * result + (this.indexExecution != null ? this.indexExecution.hashCode() : 0);
        result = 31 * result + (this.databaseExecution != null ? this.databaseExecution.hashCode() : 0);
        return result;
    }
}

