/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.search;

import com.atlassian.instrumentation.operations.SimpleOpTimer;
import com.atlassian.jira.instrumentation.Statistics;
import com.atlassian.jira.instrumentation.search.SearchCounter;
import com.atlassian.jira.sharing.SharedEntitySearchEvent;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;

@ParametersAreNonnullByDefault
public final class SearchStatistics
implements Statistics {
    public static final String SEARCH_LAAS_ID = "search";
    @JsonProperty
    private final String name;
    @JsonProperty
    private final List<String> tags;
    @JsonIgnore
    private List<SearchCounter> executions;
    @JsonIgnore
    private Map<String, Object> otherStats;

    public SearchStatistics(String name, List<String> tags, Map<String, ?> otherStats, List<SearchCounter> executions) {
        this.name = Objects.requireNonNull(name);
        this.tags = ImmutableList.copyOf((Collection)Objects.requireNonNull(tags));
        this.executions = ImmutableList.copyOf((Collection)Objects.requireNonNull(executions));
        this.otherStats = ImmutableMap.copyOf(Objects.requireNonNull(otherStats));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLoggingKey() {
        return SEARCH_LAAS_ID;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    @JsonProperty
    public Map<String, Object> getStats() {
        if (this.otherStats.size() == 0 && this.executions.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"executions", this.executions.stream().map(SearchCounter::asMap).collect(Collectors.toList()));
        builder.putAll(this.otherStats);
        return builder.build();
    }

    public static List<SearchStatistics> create(@Nonnull String name, @Nonnull SharedEntitySearchEvent sharedEntitySearchEvent, @Nonnull SimpleOpTimer indexExecution, @Nonnull Integer indexHash, @Nullable SimpleOpTimer databaseExecution, @Nullable Integer databaseHash) {
        Assertions.notNull((String)"sharedEntitySearchEvent", (Object)sharedEntitySearchEvent);
        Assertions.notNull((String)"indexExecution", (Object)indexExecution);
        Assertions.notNull((String)"indexHash", (Object)indexHash);
        return SearchStatistics.create(name, new SearchCounter(sharedEntitySearchEvent, indexExecution, indexHash, databaseExecution, databaseHash));
    }

    public static List<SearchStatistics> create(@Nonnull String name, SearchCounter ... executions) {
        Assertions.notNull((String)"name", (Object)name);
        Assertions.notNull((String)"executions", (Object)executions);
        return Lists.newArrayList((Object[])new SearchStatistics[]{new SearchStatisticsBuilder().withName(name).withExecutions(executions).build()});
    }

    public static class SearchStatisticsBuilder {
        private String name;
        private List<String> tags = Collections.emptyList();
        private List<SearchCounter> executions = Lists.newArrayList();
        private Map<String, ?> otherStats = Collections.emptyMap();

        public SearchStatisticsBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public SearchStatisticsBuilder withTags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public SearchStatisticsBuilder withExecutions(SearchCounter ... executions) {
            this.executions.addAll(Arrays.asList(executions));
            return this;
        }

        public SearchStatisticsBuilder withOtherStats(Map<String, ?> otherStats) {
            this.otherStats = otherStats;
            return this;
        }

        public SearchStatistics build() {
            return new SearchStatistics(this.name, this.tags, this.otherStats, this.executions);
        }
    }
}

