/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory.metadata;

import com.atlassian.fugue.Option;
import com.atlassian.jira.bc.issue.changehistory.properties.ChangeHistoryPropertyService;
import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyOptions;
import com.atlassian.jira.entity.property.EntityPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadata;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataManager;
import com.atlassian.jira.issue.changehistory.metadata.HistoryMetadataMarshaller;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultHistoryMetadataManager
implements HistoryMetadataManager {
    private final HistoryMetadataMarshaller historyMetadataMarshaller;
    private final ChangeHistoryPropertyService changeHistoryPropertyService;

    public DefaultHistoryMetadataManager(HistoryMetadataMarshaller historyMetadataMarshaller, ChangeHistoryPropertyService changeHistoryPropertyService) {
        this.historyMetadataMarshaller = historyMetadataMarshaller;
        this.changeHistoryPropertyService = changeHistoryPropertyService;
    }

    public void saveHistoryMetadata(@Nonnull Long changeGroupId, @Nullable ApplicationUser user, @Nonnull HistoryMetadata historyMetadata) {
        Assertions.notNull((String)"changeGroupId", (Object)changeGroupId);
        Assertions.notNull((String)"historyMetadata", (Object)historyMetadata);
        this.changeHistoryPropertyService.setProperty(user, new EntityPropertyService.SetPropertyValidationResult((ErrorCollection)new SimpleErrorCollection(), Option.some((Object)new EntityPropertyService.EntityPropertyInput(this.historyMetadataMarshaller.marshall(historyMetadata), "history_metadata", changeGroupId, EntityPropertyType.CHANGE_HISTORY_PROPERTY.getDbEntityName()))));
    }

    public HistoryMetadataManager.HistoryMetadataResult getHistoryMetadata(@Nonnull ChangeHistory changeHistory, @Nullable ApplicationUser user) {
        Assertions.notNull((String)"changeHistory", (Object)changeHistory);
        EntityPropertyService.PropertyResult property = this.changeHistoryPropertyService.getProperty(user, changeHistory.getId(), "history_metadata");
        return this.convertResult(property);
    }

    public HistoryMetadataManager.HistoryMetadataResult getHistoryMetadata(long changeHistoryId) {
        EntityPropertyService.PropertyResult property = this.changeHistoryPropertyService.getProperty(null, Long.valueOf(changeHistoryId), "history_metadata", new EntityPropertyOptions.Builder().skipPermissionChecks().build());
        return this.convertResult(property);
    }

    private HistoryMetadataManager.HistoryMetadataResult convertResult(EntityPropertyService.PropertyResult property) {
        if (!property.isValid()) {
            return new HistoryMetadataManager.HistoryMetadataResult(property.getErrorCollection());
        }
        Option metadataProperty = property.getEntityProperty();
        if (metadataProperty.isDefined() && ((EntityProperty)metadataProperty.get()).getValue() != null) {
            HistoryMetadata historyMetadata = this.historyMetadataMarshaller.unmarshall(((EntityProperty)metadataProperty.get()).getValue());
            return new HistoryMetadataManager.HistoryMetadataResult(historyMetadata);
        }
        return new HistoryMetadataManager.HistoryMetadataResult((HistoryMetadata)null);
    }
}

