/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.model.querydsl.QAction;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.QueryDSLProjectRoleFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.mysema.query.Tuple;
import com.mysema.query.types.Expression;
import java.sql.Timestamp;
import java.util.Date;

public class QueryDSLCommentFactory {
    private final QueryDSLProjectRoleFactory queryDSLProjectRoleFactory;

    public QueryDSLCommentFactory(QueryDSLProjectRoleFactory queryDSLProjectRoleFactory) {
        this.queryDSLProjectRoleFactory = queryDSLProjectRoleFactory;
    }

    public Comment createComment(Issue issue, Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        Timestamp createdTimestamp = (Timestamp)tuple.get(QAction.ACTION.created);
        Timestamp updatedTimestamp = (Timestamp)tuple.get(QAction.ACTION.updated);
        Long roleLevel = (Long)tuple.get(QAction.ACTION.rolelevel);
        ProjectRole projectRole = roleLevel != null ? this.queryDSLProjectRoleFactory.createProjectRole(tuple) : null;
        return new Comment2((Long)tuple.get(QAction.ACTION.id), (String)tuple.get((Expression)QAction.ACTION.author), (String)tuple.get((Expression)QAction.ACTION.body), createdTimestamp != null ? new Date(createdTimestamp.getTime()) : null, updatedTimestamp != null ? new Date(updatedTimestamp.getTime()) : null, projectRole, roleLevel, (String)tuple.get((Expression)QAction.ACTION.level), issue, (String)tuple.get((Expression)QAction.ACTION.updateauthor));
    }

    private static class Comment2
    implements Comment {
        private final Long id;
        private final String authorKey;
        private final String body;
        private final Date created;
        private final Date updated;
        private final ProjectRole roleLevel;
        private final Long roleLevelId;
        private final String groupLevel;
        private final Issue issue;
        private final String updatedAuthorKey;

        private Comment2(Long id, String authorKey, String body, Date created, Date updated, ProjectRole roleLevel, Long roleLevelId, String groupLevel, Issue issue, String updatedAuthorKey) {
            this.id = id;
            this.authorKey = authorKey;
            this.body = body;
            this.created = created;
            this.updated = updated;
            this.roleLevel = roleLevel;
            this.roleLevelId = roleLevelId;
            this.groupLevel = groupLevel;
            this.issue = issue;
            this.updatedAuthorKey = updatedAuthorKey;
        }

        public String getAuthor() {
            return this.authorKey;
        }

        public String getAuthorKey() {
            return this.authorKey;
        }

        public ApplicationUser getAuthorUser() {
            return ApplicationUsers.byKey(this.authorKey);
        }

        public ApplicationUser getAuthorApplicationUser() {
            return this.getAuthorUser();
        }

        public String getAuthorFullName() {
            ApplicationUser authorUser = this.getAuthorUser();
            if (authorUser != null) {
                return authorUser.getDisplayName();
            }
            return this.authorKey;
        }

        public String getBody() {
            return this.body;
        }

        public Date getCreated() {
            return this.created;
        }

        public String getGroupLevel() {
            return this.groupLevel;
        }

        public Long getId() {
            return this.id;
        }

        public Long getRoleLevelId() {
            return this.roleLevelId;
        }

        public ProjectRole getRoleLevel() {
            return this.roleLevel;
        }

        public Issue getIssue() {
            return this.issue;
        }

        public String getUpdateAuthor() {
            return this.updatedAuthorKey;
        }

        public ApplicationUser getUpdateAuthorUser() {
            return ApplicationUsers.byKey(this.updatedAuthorKey);
        }

        public ApplicationUser getUpdateAuthorApplicationUser() {
            return this.getUpdateAuthorUser();
        }

        public String getUpdateAuthorFullName() {
            ApplicationUser updateAuthorUser = this.getUpdateAuthorUser();
            if (updateAuthorUser != null) {
                return updateAuthorUser.getDisplayName();
            }
            return this.updatedAuthorKey;
        }

        public Date getUpdated() {
            return this.updated;
        }
    }
}

