/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.fugue.Iterables;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigSchemePersister;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.NameComparator;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.Null;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldConfigSchemeManagerImpl
implements FieldConfigSchemeManager {
    private static final Logger log = LoggerFactory.getLogger(FieldConfigSchemeManagerImpl.class);
    private final FieldConfigManager configManager;
    private final FieldConfigSchemePersister schemePersister;
    private final FieldConfigContextPersister contextPersister;

    public FieldConfigSchemeManagerImpl(FieldConfigSchemePersister configSchemePersister, FieldConfigContextPersister contextPersister, FieldConfigManager configManager) {
        this.schemePersister = configSchemePersister;
        this.contextPersister = contextPersister;
        this.configManager = configManager;
    }

    public void init() {
        this.schemePersister.init();
    }

    public List<FieldConfigScheme> getConfigSchemesForField(ConfigurableField field) {
        return this.schemePersister.getConfigSchemesForCustomField(field);
    }

    public FieldConfigScheme getConfigSchemeForFieldConfig(FieldConfig fieldConfig) {
        Assertions.notNull((String)"fieldConfig", (Object)fieldConfig);
        try {
            return this.schemePersister.getConfigSchemeForFieldConfig(fieldConfig);
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public FieldConfigScheme getFieldConfigScheme(Long configSchemeId) {
        if (configSchemeId != null) {
            return this.schemePersister.getFieldConfigScheme(configSchemeId);
        }
        return null;
    }

    private FieldConfigScheme createFieldConfigScheme(FieldConfigScheme newConfigScheme, List<JiraContextNode> contexts, ConfigurableField field) {
        FieldConfigScheme configScheme = this.schemePersister.create(newConfigScheme, field);
        if (contexts != null && !contexts.isEmpty()) {
            this.storeAssociatedContexts(configScheme, contexts, field);
        } else {
            log.info("ConfigScheme " + configScheme.getName() + " (" + configScheme.getId() + "). Created with no associated contexts");
        }
        return configScheme;
    }

    public FieldConfigScheme createFieldConfigScheme(FieldConfigScheme newConfigScheme, List<JiraContextNode> contexts, List<IssueType> issueTypes, ConfigurableField field) {
        FieldConfigScheme.Builder builder = new FieldConfigScheme.Builder(newConfigScheme);
        if (field != null && issueTypes != null && !issueTypes.isEmpty()) {
            FieldConfig config = this.configManager.createWithDefaultValues(field);
            HashMap<String, FieldConfig> issueTypesMappings = new HashMap<String, FieldConfig>(issueTypes.size());
            for (IssueType issueType : issueTypes) {
                String issueTypeId = issueType == null ? null : issueType.getId();
                issueTypesMappings.put(issueTypeId, config);
            }
            builder.setConfigs(issueTypesMappings);
        }
        return this.createFieldConfigScheme(builder.toFieldConfigScheme(), contexts, field);
    }

    public FieldConfigScheme createDefaultScheme(ConfigurableField field, List<JiraContextNode> contexts, List<IssueType> issueTypes) {
        if (field != null && issueTypes != null && !issueTypes.isEmpty()) {
            FieldConfig config = this.configManager.createWithDefaultValues(field);
            HashMap<String, FieldConfig> issueTypesMappings = new HashMap<String, FieldConfig>(issueTypes.size());
            for (IssueType issueType : issueTypes) {
                String issueTypeId = issueType == null ? null : issueType.getId();
                issueTypesMappings.put(issueTypeId, config);
            }
            FieldConfigScheme defaultScheme = this.schemePersister.createWithDefaultValues(field, issueTypesMappings);
            if (contexts != null && !contexts.isEmpty()) {
                this.storeAssociatedContexts(defaultScheme, contexts, field);
            } else {
                log.info("ConfigScheme " + defaultScheme.getName() + " (" + defaultScheme.getId() + "). Created with no associated contexts");
            }
            return defaultScheme;
        }
        log.info("Incomplete information supplied. Default scheme not created.");
        return null;
    }

    public FieldConfigScheme createDefaultScheme(ConfigurableField field, List<JiraContextNode> contexts) {
        return this.createDefaultScheme(field, contexts, ALL_ISSUE_TYPES);
    }

    public void removeSchemeAssociation(List<JiraContextNode> contexts, ConfigurableField configurableField) {
        this.contextPersister.store(configurableField.getId(), contexts, null);
    }

    public List<Project> getAssociatedProjectObjects(ConfigurableField field) {
        List<FieldConfigScheme> configurations = this.getConfigSchemesForField(field);
        LinkedList projects = new LinkedList();
        if (configurations != null) {
            for (FieldConfigScheme config : configurations) {
                List configProject = config.getAssociatedProjectObjects();
                if (configProject == null) continue;
                projects.addAll(configProject);
            }
            Collections.sort(projects, NameComparator.COMPARATOR);
        }
        return Collections.unmodifiableList(projects);
    }

    public FieldConfigScheme updateFieldConfigScheme(FieldConfigScheme newScheme, List<JiraContextNode> contexts, ConfigurableField field) {
        FieldConfigScheme configScheme = this.updateFieldConfigScheme(newScheme);
        this.contextPersister.removeContextsForConfigScheme(newScheme);
        this.storeAssociatedContexts(configScheme, contexts, field);
        return configScheme;
    }

    public FieldConfigScheme updateFieldConfigScheme(FieldConfigScheme scheme) {
        return this.schemePersister.update(scheme);
    }

    public void removeFieldConfigScheme(Long fieldConfigSchemeId) {
        FieldConfigScheme fieldConfigScheme = this.getFieldConfigScheme(fieldConfigSchemeId);
        this.contextPersister.removeContextsForConfigScheme(fieldConfigScheme);
        this.configManager.removeConfigsForConfigScheme(fieldConfigSchemeId);
        this.schemePersister.remove(fieldConfigSchemeId);
    }

    public void removeInvalidFieldConfigSchemesForIssueType(IssueType issueType) {
        Collection fieldConfigSchemes = this.getInvalidFieldConfigSchemesForIssueTypeRemoval(issueType);
        for (FieldConfigScheme fieldConfigScheme : fieldConfigSchemes) {
            this.removeFieldConfigScheme(fieldConfigScheme.getId());
        }
        this.schemePersister.removeByIssueType(issueType);
    }

    public void removeInvalidFieldConfigSchemesForCustomField(String customFieldId) {
        List<Long> schemeIds = this.schemePersister.getConfigSchemeIdsForCustomFieldId(customFieldId);
        for (Long schemeId : schemeIds) {
            this.removeFieldConfigScheme(schemeId);
        }
    }

    public Collection getInvalidFieldConfigSchemesForIssueTypeRemoval(IssueType issueType) {
        Null.not("issueType", issueType);
        return this.schemePersister.getInvalidFieldConfigSchemeAfterIssueTypeRemoval(issueType);
    }

    public boolean isRelevantForIssueContext(IssueContext issueContext, ConfigurableField field) {
        return this.contextPersister.getRelevantConfigSchemeId(issueContext, field.getId()) != null;
    }

    public FieldConfig getRelevantConfig(IssueContext issueContext, ConfigurableField field) {
        FieldConfigScheme scheme = this.getRelevantConfigScheme(issueContext.getProjectId(), field.getId());
        if (scheme != null) {
            Map configs = scheme.getConfigs();
            if (configs != null) {
                String issueTypeId;
                FieldConfig configForAnyIssueType = (FieldConfig)configs.get(null);
                if (configForAnyIssueType != null) {
                    return configForAnyIssueType;
                }
                IssueType issueType = issueContext.getIssueTypeObject();
                String string = issueTypeId = issueType == null ? null : issueType.getId();
                if (issueTypeId == null && !configs.isEmpty()) {
                    return (FieldConfig)Iterables.first(configs.values()).get();
                }
                FieldConfig config = (FieldConfig)configs.get(issueTypeId);
                if (config != null) {
                    return config;
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    public FieldConfigScheme getRelevantConfigScheme(IssueContext issueContext, ConfigurableField field) {
        return this.getRelevantConfigScheme(issueContext.getProjectId(), field.getId());
    }

    @Nullable
    public FieldConfigScheme getRelevantConfigScheme(Project project, ConfigurableField field) {
        Long projectId = project == null ? null : project.getId();
        return this.getRelevantConfigScheme(projectId, field.getId());
    }

    private FieldConfigScheme getRelevantConfigScheme(Long projectId, String fieldId) {
        Long schemeId = this.contextPersister.getRelevantConfigSchemeId(projectId, fieldId);
        return this.schemePersister.getFieldConfigScheme(schemeId);
    }

    private void storeAssociatedContexts(FieldConfigScheme config, List<JiraContextNode> contexts, ConfigurableField field) {
        this.contextPersister.store(field.getId(), contexts, config);
    }
}

