/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.renderer.wiki.links;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.URLCodec;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.links.BaseLink;
import com.atlassian.renderer.links.GenericLinkParser;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Collection;
import org.ofbiz.core.entity.GenericEntityException;

public class JiraAttachmentLink
extends BaseLink {
    private Attachment attachment;
    public static final String ATTACHMENT_ICON = "attachment";

    public JiraAttachmentLink(GenericLinkParser parser, RenderContext context) throws ParseException {
        super(parser);
        Issue issue = (Issue)context.getParam((Object)"jira.issue");
        if (issue == null || issue.getGenericValue() == null) {
            throw new ParseException("Can not resolve attachment with name " + parser.getAttachmentName() + " no issue in context.", 0);
        }
        try {
            this.attachment = this.getAttachment(issue, parser.getAttachmentName());
            if (this.attachment != null) {
                this.url = this.buildAttachmentUrl(context, this.attachment);
                this.setTitle(this.attachment.getFilename() + " attached to " + issue.getKey());
                this.iconName = ATTACHMENT_ICON;
            }
            if (this.linkBody.startsWith("^") && this.linkBody.length() > 1) {
                this.linkBody = this.linkBody.substring(1);
            }
        }
        catch (Exception e) {
            this.attachment = null;
        }
    }

    public Attachment getAttachment() {
        return this.attachment;
    }

    private Attachment getAttachment(Issue issue, String attachementName) throws GenericEntityException {
        Attachment attachment = null;
        Collection attachments = issue.getAttachments();
        for (Attachment tempAttachement : attachments) {
            if (!tempAttachement.getFilename().equals(attachementName)) continue;
            attachment = tempAttachement;
            break;
        }
        return attachment;
    }

    private String buildAttachmentUrl(RenderContext context, Attachment attachment) throws UnsupportedEncodingException {
        String encodedAttachmentId = URLCodec.encode((String)attachment.getId().toString(), (String)context.getCharacterEncoding());
        return context.getSiteRoot() + "/secure/attachment/" + encodedAttachmentId + "/" + encodedAttachmentId + "_" + URLCodec.encode((String)attachment.getFilename(), (String)context.getCharacterEncoding());
    }
}

