/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.fields.rest.FieldOperationHolder;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.issue.fields.rest.IssueLinkTypeFinder;
import com.atlassian.jira.issue.fields.rest.RestFieldOperationsHandler;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.beans.LinkIssueRequestJsonBean;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IssueLinksRestFieldOperationsHandler
implements RestFieldOperationsHandler {
    private final I18nHelper i18nHelper;
    private final IssueLinkTypeFinder issueLinkTypeFinder;
    private final IssueFinder issueFinder;

    public IssueLinksRestFieldOperationsHandler(I18nHelper i18nHelper, IssueLinkTypeFinder issueLinkTypeFinder, IssueFinder issueFinder) {
        this.i18nHelper = i18nHelper;
        this.issueLinkTypeFinder = issueLinkTypeFinder;
        this.issueFinder = issueFinder;
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName());
    }

    public ErrorCollection updateIssueInputParameters(IssueContext issueCtx, Issue issue, String fieldId, IssueInputParameters inputParameters, List<FieldOperationHolder> operations) {
        Issue outwardIssue;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (operations.isEmpty()) {
            return errors;
        }
        if (operations.size() > 1) {
            errors.addError("issuelinks", this.i18nHelper.getText("rest.operations.morethanone", String.valueOf(operations.size()), fieldId));
            return errors;
        }
        LinkIssueRequestJsonBean linkRequest = (LinkIssueRequestJsonBean)operations.get(0).getData().convertValue("issuelinks", LinkIssueRequestJsonBean.class, (ErrorCollection)errors);
        if (errors.hasAnyErrors()) {
            return errors;
        }
        if (linkRequest == null) {
            errors.addErrorMessage(this.i18nHelper.getText("rest.issue.link.null"));
            return errors;
        }
        IssueLinkType linkType = this.issueLinkTypeFinder.findIssueLinkType(linkRequest.getType(), (ErrorCollection)errors);
        Issue inwardIssue = linkRequest.inwardIssue() != null ? this.issueFinder.findIssue(linkRequest.inwardIssue(), (ErrorCollection)errors) : null;
        Issue issue2 = outwardIssue = linkRequest.outwardIssue() != null ? this.issueFinder.findIssue(linkRequest.outwardIssue(), (ErrorCollection)errors) : null;
        if (inwardIssue != null && outwardIssue != null) {
            errors.addErrorMessage(this.i18nHelper.getText("rest.issue.link.error.too.many.keys"));
        }
        if (linkRequest.getComment() != null) {
            errors.addErrorMessage(this.i18nHelper.getText("rest.issue.link.comment.not.allowed"));
        }
        if (errors.hasAnyErrors()) {
            return errors;
        }
        Map paramsMap = inputParameters.getActionParameters();
        paramsMap.put("issuelinks", new String[]{Boolean.TRUE.toString()});
        paramsMap.put("isCreateIssue", new String[]{Boolean.FALSE.toString()});
        paramsMap.put("issuelinks-linktype", new String[]{outwardIssue != null ? linkType.getOutward() : linkType.getInward()});
        paramsMap.put("issuelinks-issues", new String[]{outwardIssue != null ? outwardIssue.getKey() : inwardIssue.getKey()});
        return errors;
    }
}

