/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.field.screen.AbstractFieldScreenLayoutItemEvent;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenStore;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class CachingFieldScreenStore
implements FieldScreenStore {
    private static final Logger log = LoggerFactory.getLogger(CachingFieldScreenStore.class);
    private final FieldScreenStore decoratedStore;
    private final Cache<Long, CacheObject<FieldScreen>> fieldScreenCache;
    private final CachedReference<List<Long>> allScreensCache;

    public CachingFieldScreenStore(FieldScreenStore decoratedStore, CacheManager cacheManager) {
        this.decoratedStore = decoratedStore;
        this.allScreensCache = cacheManager.getCachedReference("com.atlassian.jira.issue.fields.screen.CachingFieldScreenStore.allScreensCache", (Supplier)new AllScreenSupplier());
        this.fieldScreenCache = cacheManager.getCache("com.atlassian.jira.issue.fields.screen.CachingFieldScreenStore.fieldScreenCache", (CacheLoader)new FieldScreenCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    public void setFieldScreenManager(FieldScreenManager fieldScreenManager) {
        this.decoratedStore.setFieldScreenManager(fieldScreenManager);
    }

    @Override
    public FieldScreen getFieldScreen(Long id) {
        return (FieldScreen)((CacheObject)this.fieldScreenCache.get((Object)id)).getValue();
    }

    @Override
    public List<Long> getFieldScreenIds() {
        return (List)this.allScreensCache.get();
    }

    @Override
    public List<FieldScreen> getFieldScreens() {
        List<Long> allIds = this.getFieldScreenIds();
        ArrayList allScreens = Lists.newArrayListWithCapacity((int)allIds.size());
        for (Long id : allIds) {
            CacheObject fieldScreenRef = (CacheObject)this.fieldScreenCache.get((Object)id);
            if (!fieldScreenRef.hasValue()) continue;
            allScreens.add(fieldScreenRef.getValue());
        }
        return Ordering.from((Comparator)new ScreenNameComparator()).immutableSortedCopy((Iterable)allScreens);
    }

    @Override
    public void createFieldScreen(FieldScreen fieldScreen) {
        try {
            this.decoratedStore.createFieldScreen(fieldScreen);
        }
        finally {
            this.refresh();
        }
    }

    @Override
    public void removeFieldScreen(Long id) {
        try {
            this.decoratedStore.removeFieldScreen(id);
        }
        finally {
            this.refresh();
        }
    }

    @Override
    public void updateFieldScreen(FieldScreen fieldScreen) {
        try {
            this.decoratedStore.updateFieldScreen(fieldScreen);
        }
        finally {
            this.fieldScreenCache.remove((Object)fieldScreen.getId());
        }
    }

    @Override
    public void createFieldScreenTab(FieldScreenTab fieldScreenTab) {
        try {
            this.decoratedStore.createFieldScreenTab(fieldScreenTab);
        }
        finally {
            if (fieldScreenTab != null && fieldScreenTab.getFieldScreen() != null) {
                this.fieldScreenCache.remove((Object)fieldScreenTab.getFieldScreen().getId());
            }
        }
    }

    @Override
    public void updateFieldScreenTab(FieldScreenTab fieldScreenTab) {
        try {
            this.decoratedStore.updateFieldScreenTab(fieldScreenTab);
        }
        finally {
            if (fieldScreenTab != null && fieldScreenTab.getFieldScreen() != null) {
                this.fieldScreenCache.remove((Object)fieldScreenTab.getFieldScreen().getId());
            }
        }
    }

    @Override
    public List<FieldScreenTab> getFieldScreenTabs(FieldScreen fieldScreen) {
        return this.decoratedStore.getFieldScreenTabs(fieldScreen);
    }

    @Override
    public void updateFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.updateFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.removeFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public void removeFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        this.decoratedStore.removeFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public List<FieldScreenLayoutItem> getFieldScreenLayoutItems(FieldScreenTab fieldScreenTab) {
        return this.decoratedStore.getFieldScreenLayoutItems(fieldScreenTab);
    }

    @Override
    public void refresh() {
        this.allScreensCache.reset();
        this.fieldScreenCache.removeAll();
        if (log.isTraceEnabled()) {
            log.trace("Called refresh()", new Throwable());
        }
    }

    @EventListener
    public void onFieldScreenLayoutChange(AbstractFieldScreenLayoutItemEvent event) {
        this.fieldScreenCache.remove((Object)event.getFieldScreenId());
    }

    @Override
    public void createFieldScreenLayoutItem(FieldScreenLayoutItem fieldScreenLayoutItem) {
        this.decoratedStore.createFieldScreenLayoutItem(fieldScreenLayoutItem);
    }

    @Override
    public FieldScreenLayoutItem buildNewFieldScreenLayoutItem(GenericValue genericValue) {
        return this.decoratedStore.buildNewFieldScreenLayoutItem(genericValue);
    }

    @Override
    public void removeFieldScreenTabs(FieldScreen fieldScreen) {
        this.decoratedStore.removeFieldScreenTabs(fieldScreen);
        this.fieldScreenCache.remove((Object)fieldScreen.getId());
    }

    @Override
    public void removeFieldScreenTab(Long id) {
        FieldScreenTab tab = this.getFieldScreenTab(id);
        try {
            this.decoratedStore.removeFieldScreenTab(id);
        }
        finally {
            if (tab != null && tab.getFieldScreen() != null) {
                this.fieldScreenCache.remove((Object)tab.getFieldScreen().getId());
            }
        }
    }

    @Override
    public FieldScreenTab getFieldScreenTab(Long tabId) {
        return this.decoratedStore.getFieldScreenTab(tabId);
    }

    private static class ScreenNameComparator
    implements Comparator<FieldScreen> {
        private ScreenNameComparator() {
        }

        @Override
        public int compare(FieldScreen fs1, FieldScreen fs2) {
            return fs1.getName().compareTo(fs2.getName());
        }
    }

    private class FieldScreenCacheLoader
    implements CacheLoader<Long, CacheObject<FieldScreen>> {
        private FieldScreenCacheLoader() {
        }

        public CacheObject<FieldScreen> load(@Nonnull Long fieldScreenId) {
            return CacheObject.wrap(CachingFieldScreenStore.this.decoratedStore.getFieldScreen(fieldScreenId));
        }
    }

    private class AllScreenSupplier
    implements Supplier<List<Long>> {
        private AllScreenSupplier() {
        }

        public List<Long> get() {
            return CachingFieldScreenStore.this.decoratedStore.getFieldScreenIds();
        }
    }
}

