/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.history;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.history.DateRangeBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDateRangeBuilder
implements DateRangeBuilder {
    protected static final Long MINUS_1 = -1L;
    private static final Logger log = LoggerFactory.getLogger(AbstractDateRangeBuilder.class);
    private final String field;
    private final String emptyValue;

    public AbstractDateRangeBuilder(String field, String emptyValue) {
        this.field = field;
        this.emptyValue = emptyValue;
    }

    public List<ChangeHistoryItem> buildDateRanges(Issue issue, List<ChangeHistoryItem> items) {
        ArrayList changeItems = Lists.newArrayList();
        try {
            ChangeHistoryItem initialChangeItem = this.createInitialChangeItem(issue);
            if (items.isEmpty()) {
                changeItems.add(initialChangeItem);
            } else {
                changeItems.add(this.fixInitialChangeItem(initialChangeItem, items.get(0).getFroms(), items.get(0).getCreated()));
                PeekingIterator iterator = Iterators.peekingIterator(items.iterator());
                while (iterator.hasNext()) {
                    ChangeHistoryItem nextItem = (ChangeHistoryItem)iterator.next();
                    if (iterator.hasNext()) {
                        changeItems.add(this.createChangeItem(nextItem, ((ChangeHistoryItem)iterator.peek()).getCreated()));
                        continue;
                    }
                    changeItems.add(this.createChangeItem(nextItem, nextItem.getNextChangeCreated()));
                }
            }
        }
        catch (NullPointerException npe) {
            log.warn(String.format("The issue %s has serious data integrity issues", issue.getKey()), (Throwable)npe);
            return ImmutableList.of();
        }
        return changeItems;
    }

    private ChangeHistoryItem fixInitialChangeItem(ChangeHistoryItem initialChangeItem, Map<String, String> values, Timestamp created) {
        if (values.isEmpty()) {
            values = Maps.newHashMap();
            values.put(this.emptyValue, "");
        }
        return new ChangeHistoryItem.Builder().fromChangeItemWithoutPreservingChanges(initialChangeItem).withTos((Map)values).nextChangeOn(created).build();
    }

    protected ChangeHistoryItem createChangeItem(ChangeHistoryItem changeItem, Timestamp nextChange) {
        ChangeHistoryItem.Builder builder = new ChangeHistoryItem.Builder().fromChangeItem(changeItem).nextChangeOn(nextChange);
        if (changeItem.getTos().isEmpty()) {
            builder.to("", this.emptyValue);
        }
        if (changeItem.getFroms().isEmpty()) {
            builder.changedFrom("", this.emptyValue);
        }
        return builder.build();
    }

    protected ChangeHistoryItem.Builder changeItemBuilder(Issue issue) {
        return new ChangeHistoryItem.Builder().withId(MINUS_1).inChangeGroup(MINUS_1).forIssue(issue.getId(), issue.getKey()).inProject(issue.getProjectId()).field(this.getField()).on(issue.getCreated()).byUser(issue.getReporterId() == null ? "issue_no_reporter" : issue.getReporterId());
    }

    protected abstract ChangeHistoryItem createInitialChangeItem(Issue var1);

    protected String getField() {
        return this.field;
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }
}

