/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.LuceneUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateCustomFieldIndexer
extends AbstractCustomFieldIndexer {
    private static final Logger log = LoggerFactory.getLogger(DateCustomFieldIndexer.class);
    private final CustomField customField;

    public DateCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"customField", (Object)customField));
        this.customField = customField;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED_NO_NORMS);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index indexType) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Date || value == null) {
            Date date = (Date)value;
            if (date != null) {
                if (date.getTime() > 0L) {
                    doc.add((Fieldable)new Field(this.getDocumentFieldId(), LuceneUtils.dateToString((Date)date), Field.Store.YES, indexType));
                } else {
                    log.warn("Unable to index custom date field '" + this.customField.getName() + "(" + this.customField.getId() + ") with value: " + date.getTime());
                }
            }
            if (indexType == Field.Index.NOT_ANALYZED_NO_NORMS) {
                doc.add((Fieldable)new Field("sort_" + this.getDocumentFieldId(), LuceneUtils.dateToString((Date)date), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
            }
        }
    }
}

