/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.link.Direction;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class IssueLinkIndexer
implements FieldIndexer {
    private static final String PREFIX_LINK_TYPE = "l:";
    private static final String PREFIX_ISSUE = "i:";
    private static final String TERM_OUT = "d:o";
    private static final String TERM_IN = "d:i";
    private static final String SEPARATOR = ",";
    private final IssueLinkManager issueLinkManager;

    public static String createValue(Long issueLinkTypeId) {
        return PREFIX_LINK_TYPE + issueLinkTypeId;
    }

    public static String createValue(Long issueLinkTypeId, Direction direction) {
        return IssueLinkIndexer.createValue(issueLinkTypeId) + SEPARATOR + (direction == Direction.IN ? TERM_IN : TERM_OUT);
    }

    public static String createValue(Long issueLinkTypeId, Direction direction, Long otherIssueId) {
        return IssueLinkIndexer.createValue(issueLinkTypeId, direction) + SEPARATOR + PREFIX_ISSUE + otherIssueId;
    }

    public IssueLinkIndexer(IssueLinkManager issueLinkManager) {
        this.issueLinkManager = issueLinkManager;
    }

    public String getId() {
        return "issuelinks";
    }

    public String getDocumentFieldId() {
        return "issue_links";
    }

    public boolean isFieldVisibleAndInScope(Issue issue) {
        return true;
    }

    public void addIndex(Document doc, Issue issue) {
        Long issueId = issue.getId();
        this.addFieldsToDoc(doc, this.issueLinkManager.getInwardLinks(issueId), Direction.IN);
        this.addFieldsToDoc(doc, this.issueLinkManager.getOutwardLinks(issueId), Direction.OUT);
    }

    private void addFieldsToDoc(Document doc, Collection<IssueLink> issueLinks, Direction direction) {
        for (IssueLink issueLink : issueLinks) {
            Long linkTypeId = issueLink.getLinkTypeId();
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), IssueLinkIndexer.createValue(linkTypeId), Field.Store.NO, Field.Index.NOT_ANALYZED));
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), IssueLinkIndexer.createValue(linkTypeId, direction), Field.Store.NO, Field.Index.NOT_ANALYZED));
            Long otherIssue = direction == Direction.OUT ? issueLink.getDestinationId() : issueLink.getSourceId();
            doc.add((Fieldable)new Field(this.getDocumentFieldId(), IssueLinkIndexer.createValue(linkTypeId, direction, otherIssue), Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
    }
}

