/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.field.CustomFieldCreatedEvent;
import com.atlassian.jira.event.issue.field.CustomFieldUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.CustomFieldComparators;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldFactory;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.managers.CustomFieldSearcherManager;
import com.atlassian.jira.issue.managers.DefaultCustomFieldManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.model.querydsl.CustomFieldDTO;
import com.atlassian.jira.model.querydsl.CustomFieldDTOBuilder;
import com.atlassian.jira.model.querydsl.QColumnLayoutItem;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QCustomFieldValue;
import com.atlassian.jira.model.querydsl.QFieldLayoutItem;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptors;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptors;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.map.CacheObject;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.mysema.query.sql.RelationalPath;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingCustomFieldManager
implements CustomFieldManager {
    private static final Logger log = LoggerFactory.getLogger(CachingCustomFieldManager.class);
    private final PluginAccessor pluginAccessor;
    protected final OfBizDelegator delegator;
    protected final DbConnectionManager dbConnectionManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final ConstantsManager constantsManager;
    private final ProjectManager projectManager;
    private final FieldConfigContextPersister contextPersister;
    private final FieldScreenManager fieldScreenManager;
    private final CustomFieldValuePersister customFieldValuePersister;
    private final NotificationSchemeManager notificationSchemeManager;
    private final FieldManager fieldManager;
    private final EventPublisher eventPublisher;
    protected final CustomFieldFactory customFieldFactory;
    private final CustomFieldTypeModuleDescriptors customFieldTypeModuleDescriptors;
    private final CustomFieldSearcherModuleDescriptors customFieldSearcherModuleDescriptors;
    private final CustomFieldSearcherManager customFieldSearcherManager;
    private final Cache<Long, CacheObject<CustomField>> customFieldsById;
    private final Cache<String, List<Long>> customFieldsByName;
    private final CachedReference<List<Long>> allCustomFieldIds;

    public CachingCustomFieldManager(PluginAccessor pluginAccessor, OfBizDelegator delegator, DbConnectionManager dbConnectionManager, FieldConfigSchemeManager fieldConfigSchemeManager, ConstantsManager constantsManager, ProjectManager projectManager, FieldConfigContextPersister contextPersister, FieldScreenManager fieldScreenManager, CustomFieldValuePersister customFieldValuePersister, NotificationSchemeManager notificationSchemeManager, FieldManager fieldManager, EventPublisher eventPublisher, CacheManager cacheManager, CustomFieldFactory customFieldFactory, CustomFieldTypeModuleDescriptors customFieldTypeModuleDescriptors, CustomFieldSearcherModuleDescriptors customFieldSearcherModuleDescriptors, CustomFieldSearcherManager customFieldSearcherManager, JiraProperties jiraProperties) {
        this.pluginAccessor = pluginAccessor;
        this.delegator = delegator;
        this.dbConnectionManager = dbConnectionManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.constantsManager = constantsManager;
        this.projectManager = projectManager;
        this.contextPersister = contextPersister;
        this.fieldScreenManager = fieldScreenManager;
        this.customFieldValuePersister = customFieldValuePersister;
        this.notificationSchemeManager = notificationSchemeManager;
        this.fieldManager = fieldManager;
        this.eventPublisher = eventPublisher;
        this.customFieldFactory = customFieldFactory;
        this.customFieldTypeModuleDescriptors = customFieldTypeModuleDescriptors;
        this.customFieldSearcherModuleDescriptors = customFieldSearcherModuleDescriptors;
        this.customFieldSearcherManager = customFieldSearcherManager;
        int cacheExpiryMinutes = "preloaded".equals(jiraProperties.getProperty("atlassian.darkfeature.jira.customfield.manager")) ? 10080 : 30;
        this.customFieldsById = cacheManager.getCache(DefaultCustomFieldManager.class.getName() + ".customFieldsById", this::loadCustomFieldById, new CacheSettingsBuilder().expireAfterAccess((long)cacheExpiryMinutes, TimeUnit.MINUTES).build());
        this.customFieldsByName = cacheManager.getCache(DefaultCustomFieldManager.class.getName() + ".customFieldsByName", this::getCustomFieldIdsByName, new CacheSettingsBuilder().expireAfterAccess((long)cacheExpiryMinutes, TimeUnit.MINUTES).build());
        this.allCustomFieldIds = cacheManager.getCachedReference(DefaultCustomFieldManager.class, "allCustomFieldIds", this::getAllCustomFieldIds);
        eventPublisher.register((Object)this);
    }

    private CacheObject<CustomField> loadCustomFieldById(@Nonnull Long id) {
        Optional<CustomFieldDTO> customFieldById = this.getCustomFieldById(id);
        return customFieldById.map(dto -> this.customFieldFactory.create(dto.toGenericValue(this.delegator))).filter(customField -> customField.getCustomFieldType() != null).map(CacheObject::wrap).orElse(CacheObject.NULL());
    }

    private Optional<CustomFieldDTO> getCustomFieldById(@Nonnull Long id) {
        return Optional.ofNullable(this.dbConnectionManager.executeQuery(callback -> (CustomFieldDTO)((SQLQuery)((SQLQuery)callback.newSqlQuery().from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)QCustomField.CUSTOM_FIELD.id.eq((Object)id))).uniqueResult((Expression)QCustomField.CUSTOM_FIELD)));
    }

    private List<Long> getCustomFieldIdsByName(@Nonnull String name) {
        return this.dbConnectionManager.executeQuery(callback -> ((SQLQuery)((SQLQuery)callback.newSqlQuery().from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)QCustomField.CUSTOM_FIELD.name.eq((Object)name))).list(QCustomField.CUSTOM_FIELD.id));
    }

    private List<Long> getAllCustomFieldIds() {
        return this.dbConnectionManager.executeQuery(callback -> ((SQLQuery)callback.newSqlQuery().from((Expression)QCustomField.CUSTOM_FIELD)).list(QCustomField.CUSTOM_FIELD.id));
    }

    public CustomField createCustomField(String fieldName, String description, CustomFieldType fieldType, CustomFieldSearcher customFieldSearcher, List<JiraContextNode> contexts, List<IssueType> issueTypes) throws GenericEntityException {
        String customFieldName = StringUtils.abbreviate((String)fieldName, (int)254);
        Optional<String> customFieldDescription = Optional.ofNullable(description).filter(s -> !s.isEmpty());
        Optional<String> customFieldSearcherKey = Optional.ofNullable(customFieldSearcher).map(searcher -> customFieldSearcher.getDescriptor().getCompleteKey());
        CustomFieldDTO customFieldToInsert = new CustomFieldDTOBuilder().name(customFieldName).customFieldTypeKey(fieldType.getKey()).description(customFieldDescription.orElse(null)).customFieldSearcherKey(customFieldSearcherKey.orElse(null)).build();
        Long createdCustomFieldId = this.dbConnectionManager.executeQuery(connection -> connection.insert(QCustomField.CUSTOM_FIELD).populate(customFieldToInsert).executeWithId());
        GenericValue customFieldGV = customFieldToInsert.toGenericValue(this.delegator);
        customFieldGV.set("id", (Object)createdCustomFieldId);
        CustomField customField = this.customFieldFactory.create(customFieldGV);
        this.eventPublisher.publish((Object)new CustomFieldCreatedEvent(customField));
        this.associateCustomFieldContext(customField, contexts, issueTypes);
        this.customFieldsById.remove((Object)createdCustomFieldId);
        this.customFieldsByName.remove((Object)fieldName);
        this.resetAllCustomFieldIds();
        this.refreshConfigurationSchemes(createdCustomFieldId);
        this.fieldManager.refresh();
        return this.getCustomFieldObject(createdCustomFieldId);
    }

    protected void resetAllCustomFieldIds() {
        this.allCustomFieldIds.reset();
    }

    private void associateCustomFieldContext(CustomField customField, List<JiraContextNode> contexts, List<IssueType> issueTypes) {
        if (CollectionUtils.isNotEmpty(contexts)) {
            this.fieldConfigSchemeManager.createDefaultScheme((ConfigurableField)customField, contexts, issueTypes);
        }
    }

    @Nonnull
    public List<CustomFieldType<?, ?>> getCustomFieldTypes() {
        return this.customFieldTypeModuleDescriptors.getCustomFieldTypes();
    }

    public CustomFieldType getCustomFieldType(String key) {
        return (CustomFieldType)this.customFieldTypeModuleDescriptors.getCustomFieldType(key).getOrNull();
    }

    @Nonnull
    public List<CustomFieldSearcher> getCustomFieldSearchers(CustomFieldType customFieldType) {
        return this.customFieldSearcherManager.getSearchersValidFor(customFieldType);
    }

    public CustomFieldSearcher getCustomFieldSearcher(String key) {
        return (CustomFieldSearcher)this.customFieldSearcherModuleDescriptors.getCustomFieldSearcher(key).getOrNull();
    }

    @Nullable
    public CustomFieldSearcher getDefaultSearcher(@Nonnull CustomFieldType<?, ?> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"type == null");
        return this.getCustomFieldSearchers(type).stream().findFirst().orElse(null);
    }

    public Class<? extends CustomFieldSearcher> getCustomFieldSearcherClass(String key) {
        if (!ObjectUtils.isValueSelected((Object)key)) {
            return null;
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module instanceof CustomFieldSearcherModuleDescriptor) {
            return ((CustomFieldSearcherModuleDescriptor)module).getModuleClass();
        }
        log.warn("Custom field searcher module: " + key + " is invalid. Null being returned.");
        return null;
    }

    public void refreshConfigurationSchemes(Long customFieldId) {
        this.fieldConfigSchemeManager.init();
        this.customFieldsById.remove((Object)customFieldId);
        this.resetAllCustomFieldIds();
    }

    public List<CustomField> getCustomFieldObjects(Issue issue) {
        return this.getCustomFieldObjects(issue.getProjectId(), issue.getIssueTypeId());
    }

    public List<CustomField> getCustomFieldObjects(GenericValue issue) {
        return this.getCustomFieldObjects(issue.getLong("project"), issue.getString("type"));
    }

    public List<CustomField> getCustomFieldObjects(Long projectId, String issueTypeId) {
        ArrayList issueTypes = issueTypeId == null ? null : Lists.newArrayList((Object[])new String[]{issueTypeId});
        return this.getCustomFieldObjects(projectId, issueTypes);
    }

    public List<CustomField> getCustomFieldObjects(Long projectId, List<String> issueTypeIds) {
        Project project = this.projectManager.getProjectObj(projectId);
        List expandedIssueTypeIds = this.constantsManager.expandIssueTypeIds(issueTypeIds);
        return this.getCustomFieldObjects().stream().filter(customField -> customField.isInScopeForSearch(project, expandedIssueTypeIds)).collect(Collectors.toList());
    }

    public List<CustomField> getCustomFieldObjects(SearchContext searchContext) {
        return this.getCustomFieldObjects().stream().filter(customField -> customField.isInScope(searchContext)).collect(Collectors.toList());
    }

    @Nullable
    public CustomField getCustomFieldObject(Long id) {
        CustomField customField = (CustomField)((CacheObject)this.customFieldsById.get((Object)id)).getValue();
        return customField == null ? null : this.customFieldFactory.copyOf(customField);
    }

    private Optional<CustomField> getCustomFieldOptional(Long id) {
        return Optional.ofNullable(this.getCustomFieldObject(id));
    }

    @Nullable
    public CustomField getCustomFieldObject(String key) {
        Optional<Long> id = Optional.ofNullable(CustomFieldUtils.getCustomFieldId((String)key));
        return id.map(this::getCustomFieldObject).orElse(null);
    }

    public boolean isCustomField(String id) {
        return id != null && id.startsWith("customfield_");
    }

    public boolean exists(String key) {
        Long id = CustomFieldUtils.getCustomFieldId((String)key);
        return id != null && ((CacheObject)this.customFieldsById.get((Object)id)).hasValue();
    }

    @Nullable
    public CustomField getCustomFieldObjectByName(String customFieldName) {
        Collection<CustomField> values = this.getCustomFieldObjectsByName(customFieldName);
        if (values.size() > 1) {
            this.logReturningFirstCustomFieldWarning(values.size(), customFieldName);
        }
        return values.stream().findFirst().orElse(null);
    }

    private void logReturningFirstCustomFieldWarning(int size, String customFieldName) {
        String msg = "Warning: returning 1 of " + size + " custom fields named '" + customFieldName + '\'';
        if (log.isDebugEnabled()) {
            log.warn(msg, new Throwable());
        } else {
            log.warn(msg);
        }
    }

    public Collection<CustomField> getCustomFieldObjectsByName(String customFieldName) {
        List ids = (List)this.customFieldsByName.get((Object)customFieldName);
        List<CustomField> customFields = this.getCustomFieldsFromIds(ids);
        return Collections.unmodifiableList(customFields);
    }

    public List<CustomField> getCustomFieldObjects() {
        List ids = (List)this.allCustomFieldIds.get();
        List<CustomField> customFields = this.getCustomFieldsFromIds(ids);
        Collections.sort(customFields, CustomFieldComparators.byName());
        return Collections.unmodifiableList(customFields);
    }

    protected List<CustomField> getCustomFieldsFromIds(List<Long> ids) {
        return (List)ids.stream().map(id -> (CustomField)((CacheObject)this.customFieldsById.get(id)).getValue()).filter(Objects::nonNull).map(this.customFieldFactory::copyOf).collect(CollectorsUtil.toNewArrayListWithCapacity((int)ids.size()));
    }

    public List<CustomField> getGlobalCustomFieldObjects() {
        return this.getCustomFieldObjects().stream().filter(CustomField::isGlobal).collect(Collectors.toList());
    }

    public void refresh() {
        this.fieldConfigSchemeManager.init();
        this.customFieldsById.removeAll();
        this.customFieldsByName.removeAll();
        this.resetAllCustomFieldIds();
        this.refreshSearchersAndIndexers();
    }

    private void refreshSearchersAndIndexers() {
        IssueSearcherManager issueSearcherManager = (IssueSearcherManager)ComponentAccessor.getComponent(IssueSearcherManager.class);
        issueSearcherManager.refresh();
        FieldIndexerManager fieldIndexerManager = (FieldIndexerManager)ComponentAccessor.getComponent(FieldIndexerManager.class);
        fieldIndexerManager.refresh();
    }

    public void clear() {
        this.customFieldsById.removeAll();
        this.customFieldsByName.removeAll();
        this.resetAllCustomFieldIds();
        ComponentAccessor.getFieldLayoutManager().refresh();
    }

    public void removeCustomFieldPossiblyLeavingOrphanedData(Long customFieldId) throws RemoveException {
        Assertions.notNull((String)"id", (Object)customFieldId);
        CustomField originalCustomField = this.getCustomFieldObject(customFieldId);
        if (originalCustomField != null) {
            this.removeCustomField(originalCustomField);
        } else {
            this.removeCustomFieldDirectlyFromDb(customFieldId);
        }
    }

    private void removeCustomFieldDirectlyFromDb(Long customFieldId) throws RemoveException {
        log.debug("Couldn't load customfield object for id '" + customFieldId + "'.  Trying to lookup field directly via the db." + "  Please note that deleting a custom field this way may leave some custom field data behind.");
        this.getCustomFieldById(customFieldId).orElseThrow(() -> new IllegalArgumentException("Tried to remove custom field with id '" + customFieldId + "' that doesn't exist!"));
        log.debug("Customfield with id '" + customFieldId + "' retrieved successfully via the db.");
        String customFieldStringId = "customfield_" + customFieldId;
        this.removeCustomFieldAssociations(customFieldStringId);
        this.customFieldValuePersister.removeAllValues(customFieldStringId);
        this.dbConnectionManager.execute(connection -> connection.delete((RelationalPath<?>)QCustomField.CUSTOM_FIELD).where((Predicate)QCustomField.CUSTOM_FIELD.id.eq((Object)customFieldId)).execute());
        this.fieldManager.refresh();
    }

    public void removeCustomField(CustomField customField) throws RemoveException {
        this.removeCustomFieldAssociations(customField.getId());
        customField.remove();
        this.customFieldsById.remove((Object)customField.getIdAsLong());
        this.customFieldsByName.remove((Object)customField.getName());
        this.resetAllCustomFieldIds();
        this.refreshSearchersAndIndexers();
        this.fieldManager.refresh();
    }

    private void removeCustomFieldAssociations(String customFieldId) throws RemoveException {
        this.fieldScreenManager.removeFieldScreenItems(customFieldId);
        this.dbConnectionManager.execute(connection -> {
            connection.delete((RelationalPath<?>)QColumnLayoutItem.COLUMN_LAYOUT_ITEM).where((Predicate)QColumnLayoutItem.COLUMN_LAYOUT_ITEM.fieldidentifier.eq((Object)customFieldId)).execute();
            connection.delete((RelationalPath<?>)QFieldLayoutItem.FIELD_LAYOUT_ITEM).where((Predicate)QFieldLayoutItem.FIELD_LAYOUT_ITEM.fieldidentifier.eq((Object)customFieldId)).execute();
        });
        this.fieldConfigSchemeManager.removeInvalidFieldConfigSchemesForCustomField(customFieldId);
        this.notificationSchemeManager.removeSchemeEntitiesForField(customFieldId);
    }

    public void removeCustomFieldValues(GenericValue issue) throws GenericEntityException {
        Long issueId = issue.getLong("id");
        this.dbConnectionManager.execute(connection -> connection.delete((RelationalPath<?>)QCustomFieldValue.CUSTOM_FIELD_VALUE).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.eq((Object)issueId)).execute());
    }

    public void updateCustomField(Long id, String name, String description, CustomFieldSearcher searcher) {
        CustomField oldCustomField = this.getCustomFieldOptional(id).orElseThrow(() -> new DataAccessException("Cannot update custom field that does not exist"));
        String searcherKey = Optional.ofNullable(searcher).map(s -> s.getDescriptor().getCompleteKey()).orElse(null);
        this.dbConnectionManager.execute(connection -> connection.update((RelationalPath<?>)QCustomField.CUSTOM_FIELD).set((Path)QCustomField.CUSTOM_FIELD.name, (Object)name).set((Path)QCustomField.CUSTOM_FIELD.description, (Object)description).set((Path)QCustomField.CUSTOM_FIELD.customfieldsearcherkey, (Object)searcherKey).where((Predicate)QCustomField.CUSTOM_FIELD.id.eq((Object)id)).execute());
        this.customFieldsById.remove((Object)id);
        this.resetAllCustomFieldIds();
        String oldName = oldCustomField.getName();
        if (!name.equals(oldName)) {
            this.customFieldsByName.remove((Object)name);
            this.customFieldsByName.remove((Object)oldName);
        }
        if (searcher != oldCustomField.getCustomFieldSearcher()) {
            this.refreshSearchersAndIndexers();
        }
        CustomField newCustomField = this.getCustomFieldObject(id);
        this.eventPublisher.publish((Object)new CustomFieldUpdatedEvent(newCustomField, oldCustomField));
        if (!this.areConfigSchemesEqual(newCustomField.getConfigurationSchemes(), oldCustomField.getConfigurationSchemes())) {
            this.fieldManager.refresh();
        }
    }

    protected boolean areConfigSchemesEqual(List<FieldConfigScheme> schemes, List<FieldConfigScheme> otherSchemes) {
        if (schemes != null && otherSchemes != null) {
            return HashMultiset.create(schemes).equals((Object)HashMultiset.create(otherSchemes));
        }
        return schemes == null && otherSchemes == null;
    }

    public CustomField getCustomFieldInstance(GenericValue customFieldGv) {
        return this.customFieldFactory.create(customFieldGv);
    }

    public void removeProjectAssociations(Project project) {
        this.contextPersister.removeContextsForProject(project);
        this.refresh();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }
}

