/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentCleanupException;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.attachment.ThumbnailAccessor;
import com.atlassian.jira.issue.managers.IssueAttachmentDeleteHelper;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import java.util.List;
import javax.annotation.Nullable;

public final class DefaultIssueAttachmentDeleteHelper
implements IssueAttachmentDeleteHelper {
    private final AttachmentManager attachmentManager;
    private final AttachmentStore attachmentStore;
    private final ThumbnailAccessor thumbnailAccessor;

    public DefaultIssueAttachmentDeleteHelper(AttachmentManager attachmentManager, AttachmentStore attachmentStore, ThumbnailAccessor thumbnailAccessor) {
        this.attachmentManager = attachmentManager;
        this.attachmentStore = attachmentStore;
        this.thumbnailAccessor = thumbnailAccessor;
    }

    @Override
    public Promise<Void> deleteAttachmentsForIssue(final Issue issue) {
        if (this.attachmentManager.attachmentsEnabled()) {
            return this.thumbnailAccessor.deleteThumbnailDirectory(issue).flatMap((Function)new Function<Void, Promise<Void>>(){

                public Promise<Void> apply(@Nullable Void input) {
                    List attachments = DefaultIssueAttachmentDeleteHelper.this.attachmentManager.getAttachments(issue);
                    try {
                        for (Attachment a : attachments) {
                            DefaultIssueAttachmentDeleteHelper.this.attachmentManager.deleteAttachment(a);
                        }
                    }
                    catch (RemoveException e) {
                        return Promises.rejected((Throwable)new AttachmentCleanupException((Throwable)e));
                    }
                    return DefaultIssueAttachmentDeleteHelper.this.attachmentStore.deleteAttachmentContainerForIssue(issue);
                }
            });
        }
        return Promises.promise(null);
    }
}

