/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.providers;

import com.atlassian.instrumentation.operations.SimpleOpTimer;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.instrumentation.InstrumentationListenerManager;
import com.atlassian.jira.instrumentation.InstrumentationLogger;
import com.atlassian.jira.instrumentation.jql.QueryStatistics;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.TimedSearchResults;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.issue.search.providers.DbSearchProvider;
import com.atlassian.jira.issue.search.providers.LuceneSearchProvider;
import com.atlassian.jira.jql.query.AnonymizingClauseVisitor;
import com.atlassian.jira.jql.query.DbQueryCapabilityVisitor;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.clause.ClauseVisitor;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.apache.lucene.search.Collector;

public class DualSearchProvider
implements SearchProvider {
    private final LuceneSearchProvider luceneSearchProvider;
    private final DbSearchProvider dbSearchProvider;
    private final SearchHandlerManager searchHandlerManager;
    private final FeatureManager featureManager;
    private final FeatureFlag timimgFeature = FeatureFlag.featureFlag((String)"jira.issue.search.jql.timing");
    private final InstrumentationListenerManager instrumentationListenerManager;
    private final InstrumentationLogger instrumentationLogger;
    private final CustomFieldManager customFieldManager;
    private final ExecutorService searchPool;
    private final Pattern projectPattern = Pattern.compile("project\\s*=\\s*['\"]*[A-Za-z0-9\\s]+['\"]*", 2);

    public DualSearchProvider(LuceneSearchProvider luceneSearchProvider, DbSearchProvider dbSearchProvider, SearchHandlerManager searchHandlerManager, FeatureManager featureManager, InstrumentationListenerManager instrumentationListenerManager, InstrumentationLogger instrumentationLogger, CustomFieldManager customFieldManager) {
        this(luceneSearchProvider, dbSearchProvider, searchHandlerManager, featureManager, instrumentationListenerManager, instrumentationLogger, customFieldManager, Executors.newFixedThreadPool(1));
    }

    @VisibleForTesting
    DualSearchProvider(LuceneSearchProvider luceneSearchProvider, DbSearchProvider dbSearchProvider, SearchHandlerManager searchHandlerManager, FeatureManager featureManager, InstrumentationListenerManager instrumentationListenerManager, InstrumentationLogger instrumentationLogger, CustomFieldManager customFieldManager, ExecutorService searchPool) {
        this.luceneSearchProvider = luceneSearchProvider;
        this.dbSearchProvider = dbSearchProvider;
        this.searchHandlerManager = searchHandlerManager;
        this.featureManager = featureManager;
        this.instrumentationListenerManager = instrumentationListenerManager;
        this.instrumentationLogger = instrumentationLogger;
        this.customFieldManager = customFieldManager;
        this.searchPool = searchPool;
    }

    public SearchResults search(Query query, ApplicationUser searcher, PagerFilter pager) throws SearchException {
        return this.performSearch(() -> this.luceneSearchProvider.search(query, searcher, pager), query, searcher, false);
    }

    public SearchResults search(Query query, ApplicationUser searcher, PagerFilter pager, org.apache.lucene.search.Query andQuery) throws SearchException {
        return this.performSearch(() -> this.luceneSearchProvider.search(query, searcher, pager, andQuery), query, searcher, false);
    }

    public SearchResults searchOverrideSecurity(Query query, ApplicationUser searcher, PagerFilter pager, org.apache.lucene.search.Query andQuery) throws SearchException {
        return this.performSearch(() -> this.luceneSearchProvider.searchOverrideSecurity(query, searcher, pager, andQuery), query, searcher, true);
    }

    public long searchCount(Query query, ApplicationUser searcher) throws SearchException {
        return this.luceneSearchProvider.searchCount(query, searcher);
    }

    public long searchCountOverrideSecurity(Query query, ApplicationUser searcher) throws SearchException {
        return this.luceneSearchProvider.searchCountOverrideSecurity(query, searcher);
    }

    public void search(Query query, ApplicationUser searcher, Collector collector, org.apache.lucene.search.Query andQuery) throws SearchException {
        this.performCollectorSearch(() -> this.luceneSearchProvider.search(query, searcher, collector, andQuery), query, searcher, collector, false);
    }

    public void search(Query query, ApplicationUser searcher, Collector collector) throws SearchException {
        this.performCollectorSearch(() -> this.luceneSearchProvider.search(query, searcher, collector), query, searcher, collector, false);
    }

    public void searchOverrideSecurity(Query query, ApplicationUser searcher, Collector collector) throws SearchException {
        this.performCollectorSearch(() -> this.luceneSearchProvider.search(query, searcher, collector), query, searcher, collector, true);
    }

    public void searchAndSort(Query query, ApplicationUser searcher, Collector collector, PagerFilter pager) throws SearchException {
        this.performCollectorSearch(() -> this.luceneSearchProvider.searchAndSort(query, searcher, collector, pager), query, searcher, collector, false);
    }

    public void searchAndSortOverrideSecurity(Query query, ApplicationUser searcher, Collector collector, PagerFilter pager) throws SearchException {
        this.luceneSearchProvider.searchAndSortOverrideSecurity(query, searcher, collector, pager);
    }

    private boolean isSearchTimingEnabled() {
        return this.featureManager.isEnabled(this.timimgFeature);
    }

    private SearchResults performSearch(SearchSupplier<SearchResults, SearchException> search, Query query, ApplicationUser searcher, boolean overrideSecurity) throws SearchException {
        if (this.isSearchTimingEnabled() && this.canQueryRunInDatabase(query, searcher, overrideSecurity)) {
            TimedSearchResults results = this.timedSearch(search);
            this.recordMetrics(results, query, searcher, overrideSecurity);
            return results.getSearchResults();
        }
        return search.get();
    }

    private void performCollectorSearch(SearchConsumer<SearchException> search, Query query, ApplicationUser searcher, Collector collector, boolean overrideSecurity) throws SearchException {
        if (this.isSearchTimingEnabled() && this.canQueryRunInDatabase(query, searcher, overrideSecurity)) {
            TimedSearchResults results = this.timedCollectorSearch(search, collector);
            this.recordMetrics(results, query, searcher, overrideSecurity);
        } else {
            search.apply();
        }
    }

    private TimedSearchResults timedSearch(SearchSupplier<SearchResults, SearchException> search) throws SearchException {
        SimpleOpTimer timer = new SimpleOpTimer("jqlSearch");
        SearchResults result = search.get();
        return new TimedSearchResults(result, null, timer.end((long)result.getTotal()));
    }

    private TimedSearchResults timedCollectorSearch(SearchConsumer<SearchException> search, Collector collector) throws SearchException {
        SimpleOpTimer timer = new SimpleOpTimer("jqlSearch");
        search.apply();
        return new TimedSearchResults(null, collector, timer.end(0L));
    }

    private void recordMetrics(TimedSearchResults results, Query query, ApplicationUser searcher, boolean overrideSecurity) {
        String currentTraceId = this.instrumentationListenerManager.getCurrentTraceId();
        String currentPath = this.instrumentationListenerManager.getCurrentPath();
        this.searchPool.submit(() -> {
            List<QueryStatistics> queryStats = QueryStatistics.create(DualSearchProvider.class.getSimpleName(), results.getSnapshot(), (String)query.getWhereClause().accept((ClauseVisitor)new AnonymizingClauseVisitor(this.customFieldManager)), results.getCollector(), null, null);
            this.instrumentationLogger.save(currentTraceId, Optional.empty(), Optional.empty(), currentPath, queryStats, Optional.empty());
        });
    }

    private boolean canQueryRunInDatabase(Query searchQuery, ApplicationUser searchUser, boolean overrideSecurity) {
        String queryString = searchQuery.getQueryString();
        if (queryString != null && this.projectPattern.matcher(queryString).matches()) {
            return true;
        }
        QueryCreationContextImpl context = new QueryCreationContextImpl(searchUser, overrideSecurity);
        DbQueryCapabilityVisitor visitor = new DbQueryCapabilityVisitor((QueryCreationContext)context, this.searchHandlerManager);
        return searchQuery.getWhereClause() != null && (Boolean)searchQuery.getWhereClause().accept((ClauseVisitor)visitor) != false;
    }

    @FunctionalInterface
    public static interface SearchConsumer<E extends Exception> {
        public void apply() throws E;
    }

    @FunctionalInterface
    public static interface SearchSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

