/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.Delete;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeDeletedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelImpl;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeType;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@EventComponent
public class IssueSecurityLevelManagerImpl
implements IssueSecurityLevelManager {
    protected final Logger log = Logger.getLogger(IssueSecurityLevelManagerImpl.class);
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final SecurityTypeManager securityTypeManager;
    private final ProjectManager projectManager;
    private final UserManager userManager;
    private final UserKeyService userKeyService;
    private final PermissionManager permissionManager;
    private final EntityEngine entityEngine;
    private final Cache<CacheKey, List<GenericValue>> projectAndUserToSecurityLevelCache;
    private final CachedReference<Map<Long, IssueSecurityLevel>> idToSecurityLevelCache;

    public IssueSecurityLevelManagerImpl(IssueSecuritySchemeManager issueSecuritySchemeManager, SecurityTypeManager securityTypeManager, ProjectManager projectManager, UserManager userManager, UserKeyService userKeyService, PermissionManager permissionManager, EntityEngine entityEngine, CacheManager cacheManager) {
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.securityTypeManager = securityTypeManager;
        this.projectManager = projectManager;
        this.userManager = userManager;
        this.userKeyService = userKeyService;
        this.permissionManager = permissionManager;
        this.entityEngine = entityEngine;
        this.projectAndUserToSecurityLevelCache = cacheManager.getCache(IssueSecurityLevelManagerImpl.class.getName() + ".projectAndUserToSecurityLevelCache", (CacheLoader)new ProjectAndUserToSecurityLevelCacheLoader(), new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build());
        this.idToSecurityLevelCache = cacheManager.getCachedReference(IssueSecurityLevelManagerImpl.class, "idToSecurityLevelCache", (Supplier)new SecurityLevelByIdCacheSupplier());
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.clearUsersLevels();
        this.idToSecurityLevelCache.reset();
    }

    @EventListener
    public void onEvent(IssueSecuritySchemeDeletedEvent event) {
        this.clearUsersLevels();
        this.idToSecurityLevelCache.reset();
    }

    public List<GenericValue> getSchemeIssueSecurityLevels(Long schemeId) {
        return this.internSecurityLevelFields(ComponentAccessor.getOfBizDelegator().findByAnd("SchemeIssueSecurityLevels", (Map)FieldMap.build((String)"scheme", (Object)schemeId), (List)ImmutableList.of((Object)"name")));
    }

    public List<IssueSecurityLevel> getIssueSecurityLevels(long schemeId) {
        return this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL).whereEqual("scheme", schemeId).orderBy("name");
    }

    public GenericValue getIssueSecurity(Long id) {
        return Entity.ISSUE_SECURITY_LEVEL.genericValueFrom(this.getSecurityLevel(id));
    }

    public IssueSecurityLevel getSecurityLevel(long id) {
        return (IssueSecurityLevel)((Map)this.idToSecurityLevelCache.get()).get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IssueSecurityLevel createIssueSecurityLevel(long schemeId, String name, String description) {
        try {
            IssueSecurityLevelImpl issueSecurityLevel = new IssueSecurityLevelImpl(null, name, description, schemeId);
            IssueSecurityLevelImpl issueSecurityLevelImpl = issueSecurityLevel = (IssueSecurityLevel)this.entityEngine.createValue(Entity.ISSUE_SECURITY_LEVEL, issueSecurityLevel);
            return issueSecurityLevelImpl;
        }
        finally {
            this.idToSecurityLevelCache.reset();
        }
    }

    public boolean schemeIssueSecurityExists(Long id) {
        return this.getSecurityLevel(id) != null;
    }

    public String getIssueSecurityName(Long id) {
        IssueSecurityLevel issueSecurity = this.getSecurityLevel(id);
        return issueSecurity == null ? null : issueSecurity.getName();
    }

    public String getIssueSecurityDescription(Long id) {
        GenericValue issueSecurity = this.getIssueSecurity(id);
        return issueSecurity == null ? null : issueSecurity.getString("description");
    }

    public List<GenericValue> getUsersSecurityLevels(GenericValue entity, ApplicationUser user) throws GenericEntityException {
        if (entity != null) {
            if (entity.getEntityName().equals("Project")) {
                String userKey = this.userKeyService.getKeyForUser(user);
                return (List)this.projectAndUserToSecurityLevelCache.get((Object)new CacheKey(entity.getLong("id"), userKey));
            }
            if (entity.getEntityName().equals("Issue")) {
                Project project = this.projectManager.getProjectObj(entity.getLong("project"));
                if (project == null) {
                    return ImmutableList.of();
                }
                String userKey = this.userKeyService.getKeyForUser(user);
                return (List)this.projectAndUserToSecurityLevelCache.get((Object)new CacheKey(project.getId(), userKey));
            }
        }
        return null;
    }

    private boolean hasPermission(Project project, ApplicationUser user, SchemeEntity security, SchemeType type) {
        return user != null ? type.hasPermission(project, security.getParameter(), user, false) : type.hasPermission(project, security.getParameter());
    }

    public List<IssueSecurityLevel> getUsersSecurityLevels(Issue issue, ApplicationUser user) {
        try {
            List<GenericValue> genericValues = this.getUsersSecurityLevels(issue.getGenericValue(), user);
            return Entity.ISSUE_SECURITY_LEVEL.buildList(genericValues);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public List<IssueSecurityLevel> getUsersSecurityLevels(Project project, ApplicationUser user) {
        try {
            List<GenericValue> genericValues = this.getUsersSecurityLevels(project.getGenericValue(), user);
            return Entity.ISSUE_SECURITY_LEVEL.buildList(genericValues);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public Collection<GenericValue> getAllUsersSecurityLevels(ApplicationUser user) throws GenericEntityException {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user);
        HashSet<GenericValue> securityLevels = new HashSet<GenericValue>();
        for (Project project : projects) {
            securityLevels.addAll(this.getUsersSecurityLevels(project.getGenericValue(), user));
        }
        return securityLevels;
    }

    @Nonnull
    public Collection<IssueSecurityLevel> getAllSecurityLevelsForUser(ApplicationUser user) {
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, user);
        HashSet<IssueSecurityLevel> securityLevels = new HashSet<IssueSecurityLevel>();
        for (Project project : projects) {
            securityLevels.addAll(this.getUsersSecurityLevels(project, user));
        }
        return securityLevels;
    }

    public Collection<GenericValue> getAllSecurityLevels() throws GenericEntityException {
        List schemes = this.issueSecuritySchemeManager.getSchemes();
        LinkedHashSet<GenericValue> allLevels = new LinkedHashSet<GenericValue>();
        for (GenericValue scheme : schemes) {
            allLevels.addAll(this.getSchemeIssueSecurityLevels(scheme.getLong("id")));
        }
        return allLevels;
    }

    public Collection<IssueSecurityLevel> getAllIssueSecurityLevels() {
        List schemes;
        try {
            schemes = this.issueSecuritySchemeManager.getSchemes();
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        LinkedHashSet<IssueSecurityLevel> allLevels = new LinkedHashSet<IssueSecurityLevel>();
        for (GenericValue scheme : schemes) {
            allLevels.addAll(this.getIssueSecurityLevels(scheme.getLong("id")));
        }
        return allLevels;
    }

    public Collection<GenericValue> getUsersSecurityLevelsByName(ApplicationUser user, String securityLevelName) throws GenericEntityException {
        return this._getSecurityLevelsByName(securityLevelName, this.getAllUsersSecurityLevels(user));
    }

    public Collection<IssueSecurityLevel> getSecurityLevelsForUserByName(ApplicationUser user, String securityLevelName) {
        return this.filterSecurityLevelsByName(securityLevelName, this.getAllSecurityLevelsForUser(user));
    }

    public Collection<GenericValue> getSecurityLevelsByName(String securityLevelName) throws GenericEntityException {
        return this._getSecurityLevelsByName(securityLevelName, this.getAllSecurityLevels());
    }

    public Collection<IssueSecurityLevel> getIssueSecurityLevelsByName(String securityLevelName) {
        return this.filterSecurityLevelsByName(securityLevelName, this.getAllIssueSecurityLevels());
    }

    private Collection<GenericValue> _getSecurityLevelsByName(final String securityLevelName, Collection<GenericValue> securityLevels) throws GenericEntityException {
        Predicate<GenericValue> namePredicate = new Predicate<GenericValue>(){

            public boolean apply(GenericValue input) {
                return securityLevelName.equalsIgnoreCase(input.getString("name"));
            }
        };
        LinkedHashSet<GenericValue> filteredSecurityLevels = new LinkedHashSet<GenericValue>();
        for (GenericValue levelGV : Iterables.filter(securityLevels, (Predicate)namePredicate)) {
            filteredSecurityLevels.add(levelGV);
        }
        return filteredSecurityLevels;
    }

    private List<IssueSecurityLevel> filterSecurityLevelsByName(String securityLevelName, Collection<IssueSecurityLevel> securityLevels) {
        LinkedList<IssueSecurityLevel> filteredSecurityLevels = new LinkedList<IssueSecurityLevel>();
        for (IssueSecurityLevel issueSecurityLevel : securityLevels) {
            if (!issueSecurityLevel.getName().equals(securityLevelName)) continue;
            filteredSecurityLevels.add(issueSecurityLevel);
        }
        return filteredSecurityLevels;
    }

    private boolean levelExists(List<GenericValue> levels, Long id) {
        for (GenericValue level : levels) {
            if (!level.getLong("id").equals(id)) continue;
            return true;
        }
        return false;
    }

    public Long getSchemeDefaultSecurityLevel(GenericValue project) throws GenericEntityException {
        if (project != null) {
            GenericValue scheme = EntityUtil.getOnly((List)this.issueSecuritySchemeManager.getSchemes(project));
            return scheme == null ? null : scheme.getLong("defaultlevel");
        }
        return null;
    }

    public Long getDefaultSecurityLevel(Project project) {
        try {
            return this.getSchemeDefaultSecurityLevel(project != null ? project.getGenericValue() : null);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    public GenericValue getIssueSecurityLevel(Long id) {
        return ComponentAccessor.getOfBizDelegator().findById("SchemeIssueSecurityLevels", id);
    }

    public void deleteSecurityLevel(Long levelId) {
        try {
            this.entityEngine.delete(Delete.from("SchemeIssueSecurities").whereEqual("security", levelId));
            this.entityEngine.delete(Delete.from(Entity.ISSUE_SECURITY_LEVEL).whereIdEquals(levelId));
        }
        finally {
            this.idToSecurityLevelCache.reset();
            this.projectAndUserToSecurityLevelCache.removeAll();
        }
    }

    public void clearUsersLevels() {
        this.projectAndUserToSecurityLevelCache.removeAll();
    }

    public void clearProjectLevels(Project project) {
        this.projectAndUserToSecurityLevelCache.removeAll();
    }

    private List<GenericValue> internSecurityLevelFields(List<GenericValue> list) {
        if (list != null) {
            for (GenericValue value : list) {
                this.internSecurityLevelFields(value);
            }
        }
        return list;
    }

    private GenericValue internSecurityLevelFields(GenericValue value) {
        EntityUtils.internStringFieldValue(value, "name");
        EntityUtils.internStringFieldValue(value, "description");
        return value;
    }

    private class SecurityLevelByIdCacheSupplier
    implements Supplier<Map<Long, IssueSecurityLevel>> {
        private SecurityLevelByIdCacheSupplier() {
        }

        public Map<Long, IssueSecurityLevel> get() {
            List<IssueSecurityLevel> securityLevels = IssueSecurityLevelManagerImpl.this.entityEngine.selectFrom(Entity.ISSUE_SECURITY_LEVEL).findAll().list();
            HashMap<Long, IssueSecurityLevel> newCache = new HashMap<Long, IssueSecurityLevel>(securityLevels.size());
            for (IssueSecurityLevel securityLevel : securityLevels) {
                newCache.put(securityLevel.getId(), securityLevel);
            }
            return newCache;
        }
    }

    private class ProjectAndUserToSecurityLevelCacheLoader
    implements CacheLoader<CacheKey, List<GenericValue>> {
        private ProjectAndUserToSecurityLevelCacheLoader() {
        }

        public List<GenericValue> load(@Nonnull CacheKey cacheKey) {
            Project project = IssueSecurityLevelManagerImpl.this.projectManager.getProjectObj(cacheKey.projectId);
            ApplicationUser user = IssueSecurityLevelManagerImpl.this.userManager.getUserByKey(cacheKey.userKey);
            Scheme scheme = IssueSecurityLevelManagerImpl.this.issueSecuritySchemeManager.getSchemeFor(project);
            if (scheme == null) {
                return ImmutableList.of();
            }
            Collection securities = scheme.getEntities();
            Map types = IssueSecurityLevelManagerImpl.this.securityTypeManager.getTypes();
            ArrayList levels = Lists.newArrayListWithCapacity((int)securities.size());
            for (SchemeEntity security : securities) {
                GenericValue level;
                SchemeType type;
                if (IssueSecurityLevelManagerImpl.this.levelExists(levels, (Long)security.getEntityTypeId()) || (type = (SchemeType)types.get(security.getType())) == null || user == null || !IssueSecurityLevelManagerImpl.this.hasPermission(project, user, security, type) || (level = IssueSecurityLevelManagerImpl.this.getIssueSecurityLevel((Long)security.getEntityTypeId())) == null) continue;
                levels.add(level);
            }
            Collections.sort(levels, SortByNameComparator.INSTANCE);
            return ImmutableList.copyOf((Collection)levels);
        }
    }

    static class CacheKey
    implements Serializable {
        final Long projectId;
        final String userKey;

        CacheKey(Long projectId, String userKey) {
            this.projectId = (Long)Assertions.notNull((String)"projectId", (Object)projectId);
            this.userKey = userKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.projectId.longValue() == other.projectId.longValue() && (this.userKey == null ? other.userKey == null : this.userKey.equals(other.userKey));
        }

        public int hashCode() {
            return this.projectId.hashCode() * 31 + (this.userKey != null ? this.userKey.hashCode() : 0);
        }

        public String toString() {
            return "CacheKey[projectId=" + this.projectId + ", user=" + (this.userKey != null ? this.userKey : "(null)") + ']';
        }
    }

    static class SortByNameComparator
    implements Comparator<GenericValue> {
        static final SortByNameComparator INSTANCE = new SortByNameComparator();

        private SortByNameComparator() {
        }

        @Override
        public int compare(GenericValue level1, GenericValue level2) {
            String value1 = level1.getString("name");
            String value2 = level2.getString("name");
            return value1 == null ? (value2 == null ? 0 : 1) : (value2 == null ? -1 : value1.compareTo(value2));
        }
    }
}

