/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.entity.property.EntityProperty;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.entity.property.JsonEntityPropertyManager;
import com.atlassian.jira.event.entity.EntityPropertySetEvent;
import com.atlassian.jira.event.issue.property.IssuePropertySetEvent;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.InjectableComponent;
import java.util.Map;
import java.util.function.BiFunction;
import org.codehaus.jackson.JsonNode;

@InjectableComponent
public class InlineIssuePropertySetter {
    private final JsonEntityPropertyManager jsonEntityPropertyManager;

    public InlineIssuePropertySetter(JsonEntityPropertyManager jsonEntityPropertyManager) {
        this.jsonEntityPropertyManager = jsonEntityPropertyManager;
    }

    public void setIssueProperties(ApplicationUser user, Long issueId, Map<String, JsonNode> properties, boolean dispatchEvent) {
        BiFunction<ApplicationUser, EntityProperty, EntityPropertySetEvent> eventCreatorFunction = (applicationUser, entityProperty) -> new IssuePropertySetEvent(entityProperty, applicationUser);
        properties.forEach((key, jsonObject) -> {
            String jsonValue = jsonObject.toString();
            this.jsonEntityPropertyManager.put(user, EntityPropertyType.ISSUE_PROPERTY.getDbEntityName(), issueId, key, jsonValue, eventCreatorFunction, dispatchEvent);
        });
    }
}

