/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql;

import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.permission.ClausePermissionHandler;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.DbClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.util.dbc.Assertions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultValuesGeneratingClauseHandler
implements ClauseHandler,
ValueGeneratingClauseHandler {
    private final ClauseValuesGenerator valuesGenerator;
    private final ClauseQueryFactory factory;
    private final ClauseValidator validator;
    private final ClausePermissionHandler permissionHandler;
    private final ClauseContextFactory contextFactory;
    private final ClauseInformation clauseInformation;
    private final DbClauseQueryFactory dbFactory;

    public DefaultValuesGeneratingClauseHandler(ClauseInformation clauseInformation, ClauseQueryFactory factory, @Nullable DbClauseQueryFactory dbClauseQueryFactory, ClauseValidator validator, ClausePermissionHandler permissionHandler, ClauseContextFactory contextFactory, ClauseValuesGenerator valuesGenerator) {
        this.clauseInformation = (ClauseInformation)Assertions.notNull((String)"clauseInformation", (Object)clauseInformation);
        this.permissionHandler = (ClausePermissionHandler)Assertions.notNull((String)"permissionHandler", (Object)permissionHandler);
        this.factory = (ClauseQueryFactory)Assertions.notNull((String)"factory", (Object)factory);
        this.dbFactory = dbClauseQueryFactory;
        this.validator = (ClauseValidator)Assertions.notNull((String)"validator", (Object)validator);
        this.contextFactory = (ClauseContextFactory)Assertions.notNull((String)"contextFactory", (Object)contextFactory);
        this.valuesGenerator = (ClauseValuesGenerator)Assertions.notNull((String)"valuesGenerator", (Object)valuesGenerator);
    }

    public ClauseInformation getInformation() {
        return this.clauseInformation;
    }

    public ClauseValuesGenerator getClauseValuesGenerator() {
        return this.valuesGenerator;
    }

    public ClauseQueryFactory getFactory() {
        return this.factory;
    }

    public boolean isDbQueryCapable() {
        return this.dbFactory != null;
    }

    @Nonnull
    public DbClauseQueryFactory getDbClauseFactory() {
        if (!this.isDbQueryCapable()) {
            throw new UnsupportedOperationException("Not implemented - Consumers should call 'isDbQueryCapable()' prior to calling this method.");
        }
        return this.dbFactory;
    }

    public ClauseValidator getValidator() {
        return this.validator;
    }

    public ClausePermissionHandler getPermissionHandler() {
        return this.permissionHandler;
    }

    public ClauseContextFactory getClauseContextFactory() {
        return this.contextFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultValuesGeneratingClauseHandler that = (DefaultValuesGeneratingClauseHandler)o;
        if (!this.clauseInformation.equals(that.clauseInformation)) {
            return false;
        }
        if (!this.contextFactory.equals(that.contextFactory)) {
            return false;
        }
        if (!this.factory.equals(that.factory)) {
            return false;
        }
        if (!this.permissionHandler.equals(that.permissionHandler)) {
            return false;
        }
        if (!this.validator.equals(that.validator)) {
            return false;
        }
        return this.valuesGenerator.equals(that.valuesGenerator);
    }

    public int hashCode() {
        int result = this.valuesGenerator.hashCode();
        result = 31 * result + this.factory.hashCode();
        result = 31 * result + this.validator.hashCode();
        result = 31 * result + this.permissionHandler.hashCode();
        result = 31 * result + this.contextFactory.hashCode();
        result = 31 * result + this.clauseInformation.hashCode();
        return result;
    }
}

