/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.dbquery;

import com.atlassian.jira.jql.dbquery.AbstractEqualityDbQueryFactory;
import com.atlassian.jira.jql.dbquery.DbQueryFactoryResultQuerydsl;
import com.atlassian.jira.jql.dbquery.VisibilityClauseQueryFactory;
import com.atlassian.jira.jql.query.DbQueryFactoryResult;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.query.operator.Operator;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.NullExpression;
import com.mysema.query.types.Path;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.SimpleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqualityDbQueryFactory<T>
extends AbstractEqualityDbQueryFactory<T> {
    private static final Logger log = LoggerFactory.getLogger(EqualityDbQueryFactory.class);

    public EqualityDbQueryFactory(String fieldName, Path path, VisibilityClauseQueryFactory visibilityQueryFactory, NameResolver<T> nameResolver) {
        super(fieldName, path, visibilityQueryFactory, nameResolver);
    }

    @Override
    public DbQueryFactoryResult createQueryForEmptyOperand(Operator operator) {
        if (operator == Operator.IS || operator == Operator.EQUALS) {
            return DbQueryFactoryResultQuerydsl.builder().withPredicate(this.getIsEmptyQuery()).build();
        }
        if (operator == Operator.IS_NOT || operator == Operator.NOT_EQUALS) {
            return DbQueryFactoryResultQuerydsl.builder().withPredicate(this.getIsNotEmptyQuery()).build();
        }
        log.debug(String.format("Cannot create a query for an empty operand using the operator '%s'", operator.getDisplayString()));
        return DbQueryFactoryResultQuerydsl.createFalseResult();
    }

    @Override
    Predicate getIsEmptyQuery() {
        if (this.path instanceof SimpleExpression) {
            return ((SimpleExpression)this.path).isNull();
        }
        return ExpressionUtils.isNotNull((Expression)NullExpression.DEFAULT);
    }

    @Override
    Predicate getIsNotEmptyQuery() {
        if (this.path instanceof SimpleExpression) {
            return ((SimpleExpression)this.path).isNotNull();
        }
        return ExpressionUtils.isNotNull((Expression)NullExpression.DEFAULT);
    }
}

