/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.fugue.Effect;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClausePrecedence;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.MultiClause;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.Property;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.history.AndHistoryPredicate;
import com.atlassian.query.history.HistoryPredicate;
import com.atlassian.query.history.PredicateVisitor;
import com.atlassian.query.history.TerminalHistoryPredicate;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang3.StringUtils;

final class ToJqlStringVisitor
implements OperandVisitor<String>,
ClauseVisitor<Result>,
PredicateVisitor<String> {
    private final JqlStringSupport support;

    ToJqlStringVisitor(JqlStringSupport support) {
        this.support = (JqlStringSupport)Assertions.notNull((String)"support", (Object)support);
    }

    String toJqlString(Clause clause) {
        Assertions.notNull((String)"clause", (Object)clause);
        return ((Result)clause.accept((ClauseVisitor)this)).getJql();
    }

    public String visit(EmptyOperand empty) {
        return "EMPTY";
    }

    public String visit(FunctionOperand function) {
        StringBuilder sb = new StringBuilder(this.support.encodeFunctionName(function.getName()));
        sb.append("(");
        List args = function.getArgs();
        boolean first = true;
        for (String arg : args) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(this.support.encodeFunctionArgument(arg));
        }
        sb.append(")");
        return sb.toString();
    }

    public String visit(MultiValueOperand multiValue) {
        StringBuilder sb = new StringBuilder("(");
        List operands = multiValue.getValues();
        boolean first = true;
        for (Operand operand : operands) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append((String)operand.accept((OperandVisitor)this));
        }
        sb.append(")");
        return sb.toString();
    }

    public String visit(SingleValueOperand singleValueOperand) {
        if (singleValueOperand.getLongValue() != null) {
            return singleValueOperand.getLongValue().toString();
        }
        return this.support.encodeStringValue(singleValueOperand.getStringValue());
    }

    public Result visit(AndClause andClause) {
        return this.visitMultiClause((MultiClause)andClause, "AND", ClausePrecedence.AND);
    }

    public Result visit(OrClause orClause) {
        return this.visitMultiClause((MultiClause)orClause, "OR", ClausePrecedence.OR);
    }

    public Result visit(NotClause notClause) {
        Result subResult = (Result)notClause.getSubClause().accept((ClauseVisitor)this);
        boolean brackets = subResult.getPrecedence().compareTo((Enum)ClausePrecedence.NOT) < 0;
        String jql = brackets ? String.format("%s (%s)", "NOT", subResult.getJql()) : String.format("%s %s", "NOT", subResult.getJql());
        return new Result(jql, ClausePrecedence.NOT);
    }

    public Result visit(TerminalClause clause) {
        return this.buildJqlString(clause);
    }

    public Result visit(WasClause clause) {
        return this.buildJqlString((TerminalClause)clause);
    }

    public Result visit(ChangedClause clause) {
        return this.buildJqlString(clause);
    }

    public String visit(HistoryPredicate predicate) {
        if (predicate instanceof TerminalHistoryPredicate) {
            return this.visit((TerminalHistoryPredicate)predicate);
        }
        if (predicate instanceof AndHistoryPredicate) {
            return this.visit((AndHistoryPredicate)predicate);
        }
        return predicate.getDisplayString();
    }

    private String visit(TerminalHistoryPredicate predicate) {
        StringBuilder sb = new StringBuilder();
        sb.append(predicate.getOperator().getDisplayString());
        sb.append(" ");
        sb.append((String)predicate.getOperand().accept((OperandVisitor)this));
        return sb.toString();
    }

    private String visit(AndHistoryPredicate predicate) {
        StringBuilder sb = new StringBuilder();
        for (HistoryPredicate p : predicate.getPredicates()) {
            sb.append((String)p.accept((PredicateVisitor)this)).append(" ");
        }
        return sb.toString();
    }

    private Result visitMultiClause(MultiClause andClause, String clauseName, ClausePrecedence clausePrecedence) {
        StringBuilder sb = new StringBuilder();
        Iterator clauseIterator = andClause.getClauses().iterator();
        while (clauseIterator.hasNext()) {
            boolean brackets;
            Clause clause = (Clause)clauseIterator.next();
            Result clauseResult = (Result)clause.accept((ClauseVisitor)this);
            boolean bl = brackets = clauseResult.getPrecedence().compareTo((Enum)clausePrecedence) < 0;
            if (brackets) {
                sb.append("(");
            }
            sb.append(clauseResult.getJql());
            if (brackets) {
                sb.append(")");
            }
            if (!clauseIterator.hasNext()) continue;
            sb.append(" ").append(clauseName).append(" ");
        }
        return new Result(sb.toString(), clausePrecedence);
    }

    private Result buildJqlString(TerminalClause clause) {
        HistoryPredicate predicate;
        final StringBuilder builder = new StringBuilder(this.support.encodeFieldName(clause.getName()));
        clause.getProperty().foreach((Effect)new Effect<Property>(){

            public void apply(Property property) {
                builder.append("[").append(ToJqlStringVisitor.this.support.encodeFieldName(property.getKeysAsString())).append("]");
                if (StringUtils.isNotEmpty((CharSequence)property.getObjectReferencesAsString())) {
                    builder.append(".").append(ToJqlStringVisitor.this.support.encodeFieldName(property.getObjectReferencesAsString()));
                }
            }
        });
        builder.append(" ").append(clause.getOperator().getDisplayString());
        builder.append(" ").append((String)clause.getOperand().accept((OperandVisitor)this));
        if (clause instanceof WasClause && (predicate = ((WasClause)clause).getPredicate()) != null) {
            builder.append(" ").append((String)predicate.accept((PredicateVisitor)this));
        }
        return new Result(builder.toString(), ClausePrecedence.TERMINAL);
    }

    private Result buildJqlString(ChangedClause clause) {
        StringBuilder builder = new StringBuilder(this.support.encodeFieldName(clause.getField()));
        builder.append(" ").append("changed");
        if (clause.getPredicate() != null) {
            builder.append(" ");
            builder.append((String)clause.getPredicate().accept((PredicateVisitor)this));
        }
        return new Result(builder.toString(), ClausePrecedence.TERMINAL);
    }

    public static final class Result {
        private final String jql;
        private final ClausePrecedence precedence;

        private Result(String jql, ClausePrecedence precedence) {
            this.jql = jql;
            this.precedence = precedence;
        }

        public String getJql() {
            return this.jql;
        }

        public ClausePrecedence getPrecedence() {
            return this.precedence;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

