/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.util;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.util.IndexValueConverter;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.lucene.document.NumberTools;

@InjectableComponent
public class WatchesIndexValueConverter
implements IndexValueConverter {
    public String convertToIndexValue(QueryLiteral rawValue) {
        Assertions.notNull((String)"rawValue", (Object)rawValue);
        if (rawValue.isEmpty()) {
            return null;
        }
        if (rawValue.getLongValue() != null) {
            return this.convertLong(rawValue.getLongValue());
        }
        return this.convertString(rawValue.getStringValue());
    }

    private String convertString(String stringValue) {
        try {
            return this.convertLong(Long.parseLong(stringValue));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String convertLong(Long longValue) {
        if (longValue >= 0L) {
            return NumberTools.longToString((long)longValue);
        }
        return null;
    }
}

