/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.constants.PropertyClauseInformation;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import javax.annotation.Nonnull;

public abstract class EntityPropertyClauseValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final String propertyType;

    public EntityPropertyClauseValidator(String propertyType) {
        this.propertyType = propertyType;
        this.supportedOperatorsValidator = new SupportedOperatorsValidator(new Collection[]{EntityPropertyClauseValidator.supportedOperators()});
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        MessageSet errors = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (!errors.hasAnyErrors()) {
            if (terminalClause.getProperty().isEmpty()) {
                errors.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.invalid.property.query", this.propertyType, terminalClause.getName()));
            } else if (!terminalClause.getName().equals(this.propertyType)) {
                errors.addErrorMessage(this.getI18n(searcher).getText("jira.jql.clause.unknown.property", terminalClause.getName(), this.propertyType));
            }
        }
        return errors;
    }

    protected I18nHelper getI18n(ApplicationUser user) {
        return ComponentAccessor.getI18nHelperFactory().getInstance(user);
    }

    public static boolean isSupportedOperator(Operator operator) {
        return EntityPropertyClauseValidator.supportedOperators().contains(operator);
    }

    public static Collection<Operator> supportedOperators() {
        return PropertyClauseInformation.operators;
    }
}

