/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.jira.avatar.AvatarManager;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.avatar.AvatarTranscoder;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.mail.MailImageInliner;
import com.atlassian.jira.mail.util.MailAttachment;
import com.atlassian.jira.mail.util.MailAttachments;
import com.atlassian.jira.mail.util.MailAttachmentsManagerImpl;
import com.atlassian.jira.user.util.UserManager;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class MailImageInlinerImpl
implements MailImageInliner {
    private static final Logger log = LoggerFactory.getLogger(MailImageInlinerImpl.class);
    private static final String HTML_LINK = "a";
    private static final String HTML_IMG = "img";
    private static final String HTML_SRC = "src";
    private static final String HTML_ID = "id";
    private static final String CONTENT_ID_PREFIX = "cid:";
    private static final String THUMBNAIL_PATH = "/secure/thumbnail";
    private static final String THUMBNAIL_ID = "_thumb";
    private static final String ATTACHMENT_PATH = "/secure/attachment";
    private static final BiFunction<String, String, Option<String>> substringAfterToOptionFunction = (imageSource, find) -> {
        String s = StringUtils.substringAfterLast((String)imageSource, (String)find);
        if (StringUtils.isNotBlank((String)s)) {
            return Option.some((Object)s);
        }
        return Option.none();
    };
    private final AvatarService avatarService;
    private final AvatarTranscoder avatarTranscoder;
    private final UserManager userManager;
    private final AvatarManager avatarManager;
    private final ApplicationProperties applicationProperties;
    private final AttachmentManager attachmentManager;
    private final ThumbnailManager thumbnailManager;

    public MailImageInlinerImpl(ApplicationProperties applicationProperties, AvatarService avatarService, AvatarTranscoder avatarTranscoder, UserManager userManager, AvatarManager avatarManager, AttachmentManager attachmentManager, ThumbnailManager thumbnailManager) {
        this.applicationProperties = applicationProperties;
        this.avatarService = avatarService;
        this.avatarTranscoder = avatarTranscoder;
        this.userManager = userManager;
        this.avatarManager = avatarManager;
        this.attachmentManager = attachmentManager;
        this.thumbnailManager = thumbnailManager;
    }

    @Nonnull
    public MailImageInliner.InlinedEmailBody inlineImages(String html) {
        return this.doInlineImages(html, Collections.emptyList());
    }

    @Nonnull
    public MailImageInliner.InlinedEmailBody inlineImages(String html, Issue issue) {
        List<Attachment> attachments = issue.getAttachments() != null ? issue.getAttachments() : Collections.emptyList();
        return this.doInlineImages(html, attachments);
    }

    private MailImageInliner.InlinedEmailBody doInlineImages(String html, Collection<Attachment> issueAttachments) {
        MailAttachmentsManagerImpl mailAttachmentsManager = new MailAttachmentsManagerImpl(this.avatarService, this.avatarTranscoder, this.userManager, this.avatarManager, this.applicationProperties);
        String updatedHtml = mailAttachmentsManager.inlineImages(html);
        Document document = Jsoup.parse((String)updatedHtml);
        if (!issueAttachments.isEmpty()) {
            Predicate<String> isLinkOnInstancePredicate = link -> !link.equals(mailAttachmentsManager.removeBaseUrl((String)link));
            HashMap mailAttachmentCache = Maps.newHashMap();
            for (Element imageElement : document.body().getElementsByTag(HTML_IMG)) {
                this.constructMailAttachment(imageElement, issueAttachments, mailAttachmentCache, isLinkOnInstancePredicate).foreach(mailAttachment -> {
                    String cid = mailAttachmentsManager.addAttachmentAndReturnCid((MailAttachment)mailAttachment);
                    imageElement.attr(HTML_SRC, cid);
                });
            }
        }
        return new MailImageInliner.InlinedEmailBody(document.outerHtml(), mailAttachmentsManager.buildAttachmentsBodyParts());
    }

    private Option<MailAttachment> constructMailAttachment(Element imageElement, Collection<Attachment> issueAttachments, Map<String, MailAttachment> mailAttachmentCache, Predicate<String> isLinkOnInstancePredicate) {
        MailAttachment cachedMailAttachment;
        String imageSource = imageElement.attr(HTML_SRC);
        if (StringUtils.isBlank((String)imageSource) || StringUtils.startsWithIgnoreCase((String)imageSource, (String)CONTENT_ID_PREFIX)) {
            return Option.none();
        }
        if (mailAttachmentCache.containsKey(imageSource) && (cachedMailAttachment = mailAttachmentCache.get(imageSource)) != null) {
            return Option.some((Object)cachedMailAttachment);
        }
        if (!isLinkOnInstancePredicate.test(imageSource)) {
            return Option.none();
        }
        Long id = (Long)substringAfterToOptionFunction.apply(imageSource, ATTACHMENT_PATH).orElse(() -> substringAfterToOptionFunction.apply(imageSource, THUMBNAIL_PATH)).flatMap(p -> Option.option((Object)StringUtils.substringBetween((String)p, (String)"/"))).flatMap(imId -> {
            try {
                return Option.option((Object)Long.parseLong(imId));
            }
            catch (NumberFormatException nfe) {
                log.warn("{} can not be converted to a Long - the image id appears invalid", imId);
                return Option.none();
            }
        }).getOrNull();
        if (id == null) {
            log.debug("No id was able to be extracted from the HTML image source of {}", (Object)imageSource);
            return Option.none();
        }
        Option attachment = Iterables.findFirst(issueAttachments, att -> id.equals(att.getId()));
        if (attachment.isEmpty()) {
            log.debug("No attachment was found with id {} from HTML image source of {}", (Object)id, (Object)imageSource);
            return Option.none();
        }
        boolean thumbnail = imageSource.contains(THUMBNAIL_PATH) || Option.option((Object)imageElement.parent()).filter(el -> HTML_LINK.equals(el.tagName())).flatMap(el -> Option.option((Object)el.attr(HTML_ID))).exists(thId -> thId.endsWith(THUMBNAIL_ID));
        MailAttachment mailAttachment = thumbnail ? MailAttachments.newMailAttachmentByStreamingFromThumbnailManager((Attachment)attachment.get(), this.thumbnailManager) : MailAttachments.newMailAttachmentByStreamingFromAttachmentManager((Attachment)attachment.get(), this.attachmentManager);
        mailAttachmentCache.put(imageSource, mailAttachment);
        return Option.option((Object)mailAttachment);
    }
}

