/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class OfBizPluginPersistentStateStore {
    private static final String ENTITY = "PluginState";
    private static final String KEY = "key";
    private static final String ENABLED = "enabled";
    private final OfBizDelegator ofBizDelegator;

    public OfBizPluginPersistentStateStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    public void updateState(Map<String, Boolean> state) {
        this.ofBizDelegator.storeAll(this.fromStateMap(state));
    }

    public void deleteState(Map<String, Boolean> state) {
        this.ofBizDelegator.removeAll(this.fromStateMap(state));
    }

    public Map<String, Boolean> getState() {
        return this.fromGVs(this.ofBizDelegator.findAll(ENTITY));
    }

    public Map<String, Boolean> getStateFor(String prefix) {
        return this.fromGVs(this.ofBizDelegator.findByLike(ENTITY, (Map)ImmutableMap.of((Object)KEY, (Object)(prefix + "%"))));
    }

    private List<GenericValue> fromStateMap(Map<String, Boolean> stateMap) {
        ArrayList gvs = Lists.newArrayList();
        for (Map.Entry<String, Boolean> entry : stateMap.entrySet()) {
            gvs.add(this.fromEntry(entry));
        }
        return gvs;
    }

    private GenericValue fromEntry(Map.Entry<String, Boolean> entry) {
        ImmutableMap fields = ImmutableMap.of((Object)KEY, (Object)entry.getKey(), (Object)ENABLED, (Object)entry.getValue().toString());
        return this.ofBizDelegator.makeValue(ENTITY, (Map)fields);
    }

    private Map<String, Boolean> fromGVs(List<GenericValue> gvs) {
        HashMap stateMap = Maps.newHashMap();
        for (GenericValue gv : gvs) {
            stateMap.put(gv.getString(KEY), Boolean.valueOf(gv.getString(ENABLED)));
        }
        return stateMap;
    }
}

