/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.jql.function;

import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.JiraDataTypes;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.util.JqlCascadingSelectLiteralUtil;
import com.atlassian.jira.jql.util.JqlSelectOptionsUtil;
import com.atlassian.jira.plugin.jql.function.AbstractJqlFunction;
import com.atlassian.jira.plugin.jql.function.JqlFunction;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.Operand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CascadeOptionFunction
extends AbstractJqlFunction
implements JqlFunction {
    public static final String FUNCTION_CASCADE_OPTION = "cascadeOption";
    private static final Logger log = LoggerFactory.getLogger(CascadeOptionFunction.class);
    public static final String EMPTY_VALUE = "none";
    public static final String QUOTED_EMPTY_VALUE = "\"none\"";
    private final JqlSelectOptionsUtil jqlSelectOptionsUtil;
    private final SearchHandlerManager searchHandlerManager;
    private final CustomFieldManager customFieldManager;
    private final JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil;

    public CascadeOptionFunction(JqlSelectOptionsUtil jqlSelectOptionsUtil, SearchHandlerManager searchHandlerManager, CustomFieldManager customFieldManager, JqlCascadingSelectLiteralUtil jqlCascadingSelectLiteralUtil) {
        this.jqlCascadingSelectLiteralUtil = (JqlCascadingSelectLiteralUtil)Assertions.notNull((String)"jqlCascadingSelectLiteralUtil", (Object)jqlCascadingSelectLiteralUtil);
        this.customFieldManager = (CustomFieldManager)Assertions.notNull((String)"customFieldManager", (Object)customFieldManager);
        this.searchHandlerManager = (SearchHandlerManager)Assertions.notNull((String)"searchHandlerManager", (Object)searchHandlerManager);
        this.jqlSelectOptionsUtil = (JqlSelectOptionsUtil)Assertions.notNull((String)"jqlSelectOptionsUtil", (Object)jqlSelectOptionsUtil);
    }

    public MessageSet validate(ApplicationUser searcher, FunctionOperand operand, TerminalClause terminalClause) {
        MessageSetImpl messageSet = new MessageSetImpl();
        List args = operand.getArgs();
        Set<CustomField> fields = this.resolveField(false, searcher, terminalClause.getName());
        if (fields.isEmpty()) {
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.cascade.option.not.cascade.field", terminalClause.getName(), this.getFunctionName()));
            return messageSet;
        }
        if (args.isEmpty() || args.size() > 2) {
            messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.cascade.option.incorrect.args", this.getFunctionName()));
            return messageSet;
        }
        String parentArg = (String)args.get(0);
        if (CascadeOptionFunction.isEmptyArg(parentArg)) {
            if (args.size() == 2) {
                messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.cascade.option.not.parent", this.getFunctionName(), parentArg));
                return messageSet;
            }
        } else {
            Collection<Option> chosenOptions;
            String childArg;
            Collection<Option> parentOptions = this.getParentOptions((Operand)operand, fields, parentArg = CascadeOptionFunction.cleanArg(parentArg));
            if (parentOptions.isEmpty()) {
                messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.cascade.option.not.parent", this.getFunctionName(), parentArg));
                return messageSet;
            }
            if (args.size() == 2 && !CascadeOptionFunction.isEmptyArg(childArg = (String)args.get(1)) && (chosenOptions = this.getRepresentedChildrenOptions((Operand)operand, fields, parentOptions, childArg = CascadeOptionFunction.cleanArg(childArg))).isEmpty()) {
                messageSet.addErrorMessage(this.getI18n().getText("jira.jql.function.cascade.option.parent.children.doesnt.match", childArg, parentArg, this.getFunctionName()));
                return messageSet;
            }
        }
        return messageSet;
    }

    public List<QueryLiteral> getValues(QueryCreationContext queryCreationContext, FunctionOperand operand, TerminalClause terminalClause) {
        Assertions.notNull((String)"queryCreationContext", (Object)queryCreationContext);
        List<QueryLiteral> result = new ArrayList<QueryLiteral>();
        List args = operand.getArgs();
        Set<CustomField> fields = this.resolveField(queryCreationContext.isSecurityOverriden(), queryCreationContext.getQueryUser(), terminalClause.getName());
        if (!args.isEmpty() && args.size() <= 2 && !fields.isEmpty()) {
            String parent = (String)args.get(0);
            if (CascadeOptionFunction.isEmptyArg(parent)) {
                return args.size() == 1 ? Collections.singletonList(new QueryLiteral((Operand)operand)) : Collections.emptyList();
            }
            parent = CascadeOptionFunction.cleanArg(parent);
            Collection<Option> parentOptions = this.getParentOptions((Operand)operand, fields, parent);
            if (args.size() == 2) {
                String childArg = (String)args.get(1);
                if (CascadeOptionFunction.isEmptyArg(childArg)) {
                    HashSet<Option> childOptions = new HashSet<Option>();
                    for (Option parentOption : parentOptions) {
                        childOptions.addAll(parentOption.getChildOptions());
                    }
                    result = this.createLiterals((Operand)operand, parentOptions, childOptions);
                } else {
                    childArg = CascadeOptionFunction.cleanArg(childArg);
                    Collection<Option> chosenOptions = this.getRepresentedChildrenOptions((Operand)operand, fields, parentOptions, childArg);
                    result = this.createLiterals((Operand)operand, chosenOptions, Collections.emptySet());
                }
            } else {
                result = this.createLiterals((Operand)operand, parentOptions, Collections.emptySet());
            }
        }
        return result;
    }

    public int getMinimumNumberOfExpectedArguments() {
        return 1;
    }

    public JiraDataType getDataType() {
        return JiraDataTypes.CASCADING_OPTION;
    }

    List<QueryLiteral> createLiterals(Operand operand, Collection<Option> positiveOptions, Collection<Option> negativeOptions) {
        return this.jqlCascadingSelectLiteralUtil.createQueryLiteralsFromOptions(operand, positiveOptions, negativeOptions);
    }

    private static boolean isEmptyArg(String arg) {
        return EMPTY_VALUE.equalsIgnoreCase(arg);
    }

    private static String cleanArg(String arg) {
        return QUOTED_EMPTY_VALUE.equalsIgnoreCase(arg) ? EMPTY_VALUE : arg;
    }

    private Set<CustomField> resolveField(boolean overrideSecurity, ApplicationUser searcher, String clauseName) {
        HashSet<CustomField> fields = new HashSet<CustomField>();
        Collection fieldIds = overrideSecurity ? this.searchHandlerManager.getFieldIds(clauseName) : this.searchHandlerManager.getFieldIds(searcher, clauseName);
        for (String fieldId : fieldIds) {
            CustomField field = this.customFieldManager.getCustomFieldObject(fieldId);
            if (field != null && field.getCustomFieldType() instanceof CascadingSelectCFType) {
                fields.add(field);
                continue;
            }
            log.info(String.format("jql clause name %s does not resolve to a cascading select field", clauseName));
        }
        return fields;
    }

    private Collection<Option> getRepresentedChildrenOptions(Operand operand, Set<CustomField> fields, Collection<Option> parentOptionList, String childArg) {
        Set<Option> argumentOptions = this.getOptions(operand, fields, childArg);
        HashSet<Option> chosenOptions = new HashSet<Option>();
        for (Option parentOption : parentOptionList) {
            List children = parentOption.getChildOptions();
            chosenOptions.addAll(CascadeOptionFunction.intersection(children, argumentOptions));
        }
        return chosenOptions;
    }

    private Collection<Option> getParentOptions(Operand operand, Set<CustomField> fields, String optionArg) {
        Set<Option> possibleParents = this.getOptions(operand, fields, optionArg);
        Iterator parentIterator = possibleParents.iterator();
        while (parentIterator.hasNext()) {
            Option parentOption = (Option)parentIterator.next();
            if (parentOption.getParentOption() == null) continue;
            parentIterator.remove();
        }
        return possibleParents;
    }

    private Set<Option> getOptions(Operand operand, Set<CustomField> fields, String optionArg) {
        HashSet<Option> optionList = new HashSet<Option>();
        for (CustomField customField : fields) {
            optionList.addAll(this.jqlSelectOptionsUtil.getOptions(customField, new QueryLiteral(operand, optionArg), true));
        }
        return optionList;
    }

    private static <T> Set<T> intersection(Collection<T> c1, Collection<T> c2) {
        HashSet<T> intersection = new HashSet<T>();
        for (T t : c1) {
            if (!c2.contains(t)) continue;
            intersection.add(t);
        }
        return intersection;
    }
}

