/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webpanel.notification;

import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.RecoveryMode;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.plugin.web.ContextProvider;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class RecoveryModeContextProvider
implements ContextProvider {
    private final RecoveryMode recoveryMode;
    private final HelpUrls helpUrls;
    private final JiraAuthenticationContext authContext;
    private final GlobalPermissionManager permissionManager;

    public RecoveryModeContextProvider(RecoveryMode recoveryMode, HelpUrls urls, JiraAuthenticationContext authContext, GlobalPermissionManager permissionManager) {
        this.permissionManager = (GlobalPermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
        this.recoveryMode = (RecoveryMode)Assertions.notNull((String)"recoveryMode", (Object)recoveryMode);
        this.helpUrls = (HelpUrls)Assertions.notNull((String)"helpUrls", (Object)urls);
        this.authContext = (JiraAuthenticationContext)Assertions.notNull((String)"authContext", (Object)authContext);
    }

    public void init(Map<String, String> params) {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ApplicationUser user = this.authContext.getUser();
        return ImmutableMap.of((Object)"helpUrl", (Object)this.helpUrls.getUrl("recovery-mode").getUrl(), (Object)"isRecoveryAdmin", (Object)this.recoveryMode.isRecoveryUser(user), (Object)"isAdmin", (Object)this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user));
    }
}

