/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.portal;

import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.model.querydsl.QPortalPage;
import com.atlassian.jira.model.querydsl.QProjectRoleActor;
import com.atlassian.jira.model.querydsl.QSharePermissions;
import com.atlassian.jira.model.querydsl.SharePermissionsDTO;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.portal.PortalPageSearcher;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.IdsRetrievalDescriptor;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.jira.sharing.search.SharedEntitySearchParameters;
import com.atlassian.jira.sharing.search.SharedEntitySearchResult;
import com.atlassian.jira.sharing.type.ShareType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionEnclosedIterable;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.lang.Pair;
import com.mysema.query.BooleanBuilder;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.sql.SQLSubQuery;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Expression;
import com.mysema.query.types.ExpressionUtils;
import com.mysema.query.types.OrderSpecifier;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.expr.BooleanExpression;
import com.mysema.query.types.path.StringPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class QueryDslPortalPageSearcher
implements PortalPageSearcher {
    private static final QPortalPage PORTAL_PAGE = QPortalPage.PORTAL_PAGE;
    private static final QSharePermissions SHARE_PERMISSIONS = QSharePermissions.SHARE_PERMISSIONS;
    private static final QProjectRoleActor PROJECT_ROLE_ACTOR = QProjectRoleActor.PROJECT_ROLE_ACTOR;
    private static final String ROLE_TYPE_USER = "atlassian-user-role-actor";
    private static final String ROLE_TYPE_GROUP = "atlassian-group-role-actor";
    private static final int DEFAULT_PAGE_SIZE = 20;
    private final DbConnectionManager dbConnectionManager;
    private final GroupManager groupManager;
    private final SharedEntityAccessor.Factory sharedEntityAccessorFactory;

    public QueryDslPortalPageSearcher(DbConnectionManager connectionManager, GroupManager groupManager, SharedEntityAccessor.Factory sharedEntityAccesorFactory) {
        this.dbConnectionManager = connectionManager;
        this.groupManager = groupManager;
        this.sharedEntityAccessorFactory = sharedEntityAccesorFactory;
    }

    @Override
    public SharedEntitySearchResult<PortalPage> search(@Nonnull SharedEntitySearchParameters searchParameters, @Nullable ApplicationUser user, int pageOffset, int pageSize) {
        Assertions.not((String)"pageOffset < 0", (pageOffset < 0 ? 1 : 0) != 0);
        Assertions.not((String)"pageSize <= 0", (pageSize <= 0 ? 1 : 0) != 0);
        Assertions.not((String)"pageSize of MAX_VALUE used with non zero pageOffset", (pageSize == Integer.MAX_VALUE && pageOffset != 0 ? 1 : 0) != 0);
        Assertions.notNull((String)"searchParameters", (Object)searchParameters);
        Pair resultPage = this.dbConnectionManager.executeQuery(dbConnection -> {
            Long count = (Long)this.buildSearchQuery(dbConnection, user, searchParameters, null, null).singleResult((Expression)QueryDslPortalPageSearcher.PORTAL_PAGE.id.count());
            ArrayList ids = new ArrayList();
            if (count > 0L) {
                List searchResults = ((SQLQuery)this.buildSearchQuery(dbConnection, user, searchParameters, pageOffset, pageSize).orderBy(QueryDslPortalPageSearcher.buildOrderByExpression(searchParameters))).list(QueryDslPortalPageSearcher.PORTAL_PAGE.id);
                ids.addAll(searchResults);
            }
            return Pair.nicePairOf((Object)count, ids);
        });
        EnclosedIterable portalPages = !((List)resultPage.second()).isEmpty() ? this.sharedEntityAccessorFactory.getSharedEntityAccessor(PortalPage.ENTITY_TYPE).get(user, (SharedEntityAccessor.RetrievalDescriptor)new IdsRetrievalDescriptor((Collection)resultPage.second(), true)) : CollectionEnclosedIterable.from((Collection)Collections.EMPTY_LIST);
        return new SharedEntitySearchResult(portalPages, (long)(pageOffset * pageSize) < (Long)resultPage.first(), ((Long)resultPage.first()).intValue());
    }

    @Override
    public SharedEntitySearchResult<PortalPage> search(@Nonnull SharedEntitySearchParameters searchParameters) {
        return this.search(searchParameters, null, 0, 20);
    }

    @Nullable
    private SharedEntity.SharePermissions buildSharePermissionsResult(@Nullable List<SharePermissionsDTO> permissionDTOs) {
        if (permissionDTOs != null) {
            Set permissions = permissionDTOs.stream().map(permissionsDTO -> {
                ShareType.Name shareType = this.parseSharePermissionType(permissionsDTO.getType());
                if (shareType != null) {
                    return new SharePermissionImpl(permissionsDTO.getId(), shareType, permissionsDTO.getParam1(), permissionsDTO.getParam2());
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
            return new SharedEntity.SharePermissions(permissions);
        }
        return null;
    }

    @Nullable
    private ShareType.Name parseSharePermissionType(@Nullable String type) {
        if (type != null) {
            switch (type) {
                case "global": {
                    return ShareType.Name.GLOBAL;
                }
                case "group": {
                    return ShareType.Name.GROUP;
                }
                case "project": {
                    return ShareType.Name.PROJECT;
                }
            }
        }
        return null;
    }

    private SQLQuery buildSearchQuery(@Nonnull DbConnection connection, @Nullable ApplicationUser user, @Nonnull SharedEntitySearchParameters searchParameters, @Nullable Integer pageOffset, @Nullable Integer pageSize) {
        Collection<String> userGroups = this.fetchUserGroups(user);
        Predicate searchConstraint = QueryDslPortalPageSearcher.buildSearchPredicate(searchParameters);
        Predicate permissionsConstraint = QueryDslPortalPageSearcher.buildPermissionsPredicate(user, userGroups);
        SQLQuery query = (SQLQuery)((SQLQuery)connection.newSqlQuery().from((Expression)PORTAL_PAGE)).where(ExpressionUtils.and((Predicate)searchConstraint, (Predicate)permissionsConstraint));
        if (pageOffset != null) {
            query.offset((long)(pageOffset * pageSize));
        }
        if (pageSize != null) {
            query.limit((long)pageSize.intValue());
        }
        return query;
    }

    private static Predicate buildSearchPredicate(SharedEntitySearchParameters searchParameters) {
        BooleanBuilder predicateBuilder = new BooleanBuilder();
        if (StringUtils.isNotEmpty((CharSequence)searchParameters.getName())) {
            predicateBuilder.or((Predicate)QueryDslPortalPageSearcher.PORTAL_PAGE.pagename.lower().like(Expressions.constant((Object)("%" + searchParameters.getName().toLowerCase() + "%"))));
        }
        if (StringUtils.isNotEmpty((CharSequence)searchParameters.getDescription())) {
            predicateBuilder.or((Predicate)QueryDslPortalPageSearcher.PORTAL_PAGE.description.lower().like(Expressions.constant((Object)("%" + searchParameters.getDescription().toLowerCase() + "%"))));
        }
        if (StringUtils.isNotEmpty((CharSequence)searchParameters.getUserName())) {
            predicateBuilder.and((Predicate)QueryDslPortalPageSearcher.PORTAL_PAGE.username.eq((Object)searchParameters.getUserName()));
        }
        return predicateBuilder;
    }

    private static Predicate buildPermissionsPredicate(ApplicationUser user, Collection<String> userGroups) {
        BooleanBuilder simplePermissions = QueryDslPortalPageSearcher.buildSimplePermissionsConstraint(userGroups);
        Predicate projectPermissions = QueryDslPortalPageSearcher.buildProjectPermissionsConstraint(user, userGroups);
        SQLSubQuery permissionsSubQuery = (SQLSubQuery)((SQLSubQuery)new SQLSubQuery().from((Expression)SHARE_PERMISSIONS)).where((Predicate)QueryDslPortalPageSearcher.SHARE_PERMISSIONS.entityId.eq(QueryDslPortalPageSearcher.PORTAL_PAGE.id).and((Predicate)QueryDslPortalPageSearcher.SHARE_PERMISSIONS.entityType.eq((Object)"PortalPage").and((Predicate)simplePermissions.or(projectPermissions))));
        if (user != null) {
            return QueryDslPortalPageSearcher.PORTAL_PAGE.username.eq((Object)user.getKey()).or((Predicate)permissionsSubQuery.exists());
        }
        return permissionsSubQuery.exists();
    }

    private static BooleanBuilder buildSimplePermissionsConstraint(Collection<String> userGroups) {
        BooleanBuilder predicateBuilder = new BooleanBuilder();
        predicateBuilder.or((Predicate)QueryDslPortalPageSearcher.SHARE_PERMISSIONS.type.eq((Object)ShareType.Name.GLOBAL.get()));
        if (CollectionUtils.isNotEmpty(userGroups)) {
            predicateBuilder.or((Predicate)QueryDslPortalPageSearcher.SHARE_PERMISSIONS.type.eq((Object)ShareType.Name.GROUP.get()).and((Predicate)QueryDslPortalPageSearcher.SHARE_PERMISSIONS.param1.in(userGroups)));
        }
        return predicateBuilder;
    }

    private static Predicate buildProjectPermissionsConstraint(ApplicationUser user, Collection<String> userGroups) {
        if (user != null) {
            BooleanExpression roleTypePredicate = QueryDslPortalPageSearcher.PROJECT_ROLE_ACTOR.roletype.eq((Object)ROLE_TYPE_USER).and((Predicate)QueryDslPortalPageSearcher.PROJECT_ROLE_ACTOR.roletypeparameter.eq((Object)user.getKey()));
            if (CollectionUtils.isNotEmpty(userGroups)) {
                roleTypePredicate = roleTypePredicate.or((Predicate)QueryDslPortalPageSearcher.PROJECT_ROLE_ACTOR.roletype.eq((Object)ROLE_TYPE_GROUP).and((Predicate)QueryDslPortalPageSearcher.PROJECT_ROLE_ACTOR.roletypeparameter.in(userGroups)));
            }
            SQLSubQuery roleTypeSubQuery = (SQLSubQuery)((SQLSubQuery)new SQLSubQuery().from((Expression)PROJECT_ROLE_ACTOR)).where((Predicate)QueryDslPortalPageSearcher.PROJECT_ROLE_ACTOR.pid.stringValue().eq((Expression)QueryDslPortalPageSearcher.SHARE_PERMISSIONS.param1).and((Predicate)QueryDslPortalPageSearcher.SHARE_PERMISSIONS.param2.isNull().or((Predicate)QueryDslPortalPageSearcher.PROJECT_ROLE_ACTOR.roletype.eq((Expression)QueryDslPortalPageSearcher.SHARE_PERMISSIONS.param2))).and((Predicate)roleTypePredicate));
            return QueryDslPortalPageSearcher.SHARE_PERMISSIONS.type.eq((Object)ShareType.Name.PROJECT.get()).and((Predicate)roleTypeSubQuery.exists());
        }
        return new BooleanBuilder();
    }

    private static OrderSpecifier<?> buildOrderByExpression(SharedEntitySearchParameters searchParameters) {
        StringPath sortExpression;
        switch (searchParameters.getSortColumn()) {
            case ID: {
                sortExpression = QueryDslPortalPageSearcher.PORTAL_PAGE.id;
                break;
            }
            case NAME: {
                sortExpression = QueryDslPortalPageSearcher.PORTAL_PAGE.pagename;
                break;
            }
            case DESCRIPTION: {
                sortExpression = QueryDslPortalPageSearcher.PORTAL_PAGE.description;
                break;
            }
            case OWNER: {
                sortExpression = QueryDslPortalPageSearcher.PORTAL_PAGE.username;
                break;
            }
            case FAVOURITE_COUNT: {
                sortExpression = QueryDslPortalPageSearcher.PORTAL_PAGE.favCount;
                break;
            }
            default: {
                sortExpression = QueryDslPortalPageSearcher.PORTAL_PAGE.pagename;
            }
        }
        if (searchParameters.isAscendingSort()) {
            return sortExpression.asc();
        }
        return sortExpression.desc();
    }

    private Collection<String> fetchUserGroups(ApplicationUser user) {
        if (user != null) {
            return this.groupManager.getGroupNamesForUser(user);
        }
        return Collections.EMPTY_LIST;
    }
}

