/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.renderer;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.renderer.FullHtmlProjectDescriptionRenderer;
import com.atlassian.jira.project.renderer.ProjectDescriptionRenderer;
import com.atlassian.jira.project.renderer.WikiMarkupProjectDescriptionRenderer;
import javax.annotation.Nonnull;

public class ProjectDescriptionRendererImpl
implements ProjectDescriptionRenderer {
    private final RendererManager rendererManager;
    private final ApplicationProperties applicationProperties;
    private final WikiMarkupProjectDescriptionRenderer wikiMarkupProjectDescriptionRenderer;
    private final FullHtmlProjectDescriptionRenderer fullHtmlProjectDescriptionRenderer;

    public ProjectDescriptionRendererImpl(@Nonnull RendererManager rendererManager, @Nonnull ApplicationProperties applicationProperties) {
        this.rendererManager = rendererManager;
        this.applicationProperties = applicationProperties;
        this.wikiMarkupProjectDescriptionRenderer = new WikiMarkupProjectDescriptionRenderer(rendererManager);
        this.fullHtmlProjectDescriptionRenderer = new FullHtmlProjectDescriptionRenderer();
    }

    @Override
    @Nonnull
    public String getViewHtml(@Nonnull Project project) {
        return this.getViewHtml(project.getDescription());
    }

    @Override
    @Nonnull
    public String getEditHtml(@Nonnull Project project) {
        return this.getEditHtml(project.getDescription());
    }

    @Override
    @Nonnull
    public String getViewHtml(@Nonnull String description) {
        return this.renderer().getViewHtml(description);
    }

    @Override
    @Nonnull
    public String getEditHtml(@Nonnull String description) {
        return this.renderer().getEditHtml(description);
    }

    @Override
    @Nonnull
    public String getDescriptionI18nKey() {
        return this.renderer().getDescriptionI18nKey();
    }

    @Nonnull
    private ProjectDescriptionRenderer renderer() {
        return this.isUseWikiMarkup() ? this.wikiMarkupProjectDescriptionRenderer : this.fullHtmlProjectDescriptionRenderer;
    }

    @Override
    public boolean isUseWikiMarkup() {
        return !this.applicationProperties.getOption("jira.project.description.html.enabled");
    }
}

