/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.template.descriptor;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.project.template.descriptor.ResourceDescriptorFactory;
import com.atlassian.jira.project.template.module.DemoProjectModule;
import com.atlassian.jira.project.template.module.DemoProjectModuleBuilder;
import com.atlassian.jira.project.template.module.Icon;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.base.Preconditions;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

public class DemoProjectModuleDescriptor
extends AbstractModuleDescriptor<DemoProjectModule> {
    private final ResourceDescriptorFactory resourceDescriptorFactory;
    private final WebResourceUrlProvider urlProvider;
    private DemoProjectModule module;

    public DemoProjectModuleDescriptor(ModuleFactory moduleFactory, ResourceDescriptorFactory resourceDescriptorFactory, WebResourceUrlProvider urlProvider) {
        super(moduleFactory);
        this.resourceDescriptorFactory = resourceDescriptorFactory;
        this.urlProvider = urlProvider;
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        super.init(plugin, element);
        this.createModuleFromXml(element);
    }

    public void enabled() {
        super.enabled();
    }

    public void disabled() {
        super.disabled();
    }

    public DemoProjectModule getModule() {
        return this.module;
    }

    private Pair<Icon, ResourceDescriptor> createIconFor(Element element) {
        if (element == null) {
            return null;
        }
        String location = element.attributeValue("location");
        String contentType = StringUtils.trimToNull((String)element.attributeValue("content-type"));
        if (StringUtils.isBlank((CharSequence)location)) {
            return null;
        }
        String resourceName = Paths.get(location, new String[0]).getFileName().toString();
        ResourceDescriptor resource = this.resourceDescriptorFactory.makeResourceDescriptorNode(resourceName, location, contentType);
        return Pair.of((Object)new Icon(this.urlProvider, location, this.getCompleteKey(), resource.getName()), (Object)resource);
    }

    private void createModuleFromXml(Element element) {
        DemoProjectModuleBuilder builder = new DemoProjectModuleBuilder();
        Optional<Integer> weight = Optional.ofNullable(element.attributeValue("weight")).map(Integer::valueOf);
        Pair<Icon, ResourceDescriptor> icon = this.createIconFor(element.element("icon"));
        Optional<Pair<Icon, ResourceDescriptor>> backgroundIcon = Optional.ofNullable(this.createIconFor(element.element("backgroundIcon")));
        this.module = builder.setKey(this.getKey()).setWeight(weight.orElse(100)).setLabelKey((String)Preconditions.checkNotNull((Object)element.element("label").attributeValue("key"))).setDescriptionKey((String)Preconditions.checkNotNull((Object)element.element("description").attributeValue("key"))).setLongDescriptionKey(Optional.ofNullable(element.element("longDescription")).map(e -> e.attributeValue("key"))).setIcon((Icon)((Pair)Preconditions.checkNotNull(icon)).first()).setBackgroundIcon(backgroundIcon.map(Pair::first)).setProjectTemplateKey(Optional.ofNullable(element.element("projectTemplate")).map(e -> e.attributeValue("key"))).setProjectTypeKey(Optional.ofNullable(element.element("projectType")).map(e -> e.attributeValue("key"))).setImportFile((String)Preconditions.checkNotNull((Object)element.element("importFile").attributeValue("location"))).setModulePlugin(this.getPlugin()).createDemoProjectModule();
        this.resources = new Resources((Iterable)Stream.of(Optional.of(icon), backgroundIcon).filter(Optional::isPresent).map(Optional::get).map(Pair::second).collect(CollectorsUtil.toImmutableList()));
    }
}

