/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.fugue.Option;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.permission.LegacyProjectPermissionKeyMapping;
import com.atlassian.jira.permission.ProjectPermission;
import com.atlassian.jira.permission.ProjectPermissionCategory;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.security.ProjectPermissionOverrideDescriptorCache;
import com.atlassian.jira.security.ProjectWidePermission;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.plugin.ProjectPermissionOverride;
import com.atlassian.jira.security.plugin.ProjectPermissionOverrideModuleDescriptor;
import com.atlassian.jira.security.plugin.ProjectPermissionTypesManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPermissionManager
implements PermissionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultPermissionManager.class);
    private final ProjectPermissionTypesManager projectPermissionTypesManager;
    private final ProjectPermissionOverrideDescriptorCache projectPermissionOverrideDescriptorCache;

    public DefaultPermissionManager(ProjectPermissionTypesManager projectPermissionTypesManager, ProjectPermissionOverrideDescriptorCache projectPermissionOverrideDescriptorCache) {
        this.projectPermissionTypesManager = projectPermissionTypesManager;
        this.projectPermissionOverrideDescriptorCache = projectPermissionOverrideDescriptorCache;
    }

    public Collection<ProjectPermission> getAllProjectPermissions() {
        return this.projectPermissionTypesManager.all();
    }

    public Collection<ProjectPermission> getProjectPermissions(@Nonnull ProjectPermissionCategory category) {
        return this.projectPermissionTypesManager.withCategory(category);
    }

    public Option<ProjectPermission> getProjectPermission(@Nonnull ProjectPermissionKey permissionKey) {
        return this.projectPermissionTypesManager.withKey(permissionKey);
    }

    public boolean hasPermission(int permissionsId, ApplicationUser user) {
        if (!this.isGlobalPermission(permissionsId)) {
            throw new IllegalArgumentException("Expected global permission, got " + permissionsId);
        }
        if (user == null) {
            return ComponentAccessor.getGlobalPermissionManager().hasPermission(permissionsId);
        }
        return user.isActive() && ComponentAccessor.getGlobalPermissionManager().hasPermission(permissionsId, user);
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user) {
        return this.withPermissionOverriding(this.doIssuePermissionCheck(permissionKey, issue, user), permissionKey, issue.getProjectObject(), user);
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nullable ActionDescriptor actionDescriptor) {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Issue issue, @Nullable ApplicationUser user, @Nonnull Status status) {
        throw new UnsupportedOperationException();
    }

    public boolean hasPermission(int permissionsId, Issue issue, ApplicationUser user) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionsId);
        return this.hasPermission(permissionKey, issue, user);
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        return this.withPermissionOverriding(this.doProjectPermissionCheck(permissionKey, project, user, false), permissionKey, project, user);
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionsId);
        return this.hasPermission(permissionKey, project, user);
    }

    @Nonnull
    public ProjectWidePermission hasProjectWidePermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user) {
        ProjectWidePermission corePermissionCheckResult = this.doProjectWidePermissionCheck(permissionKey, project, user, false);
        return this.withPermissionOverriding(corePermissionCheckResult, permissionKey, project, user);
    }

    public boolean hasPermission(int permissionsId, Project project, ApplicationUser user, boolean issueCreation) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionsId);
        return this.hasPermission(permissionKey, project, user, issueCreation);
    }

    public boolean hasPermission(@Nonnull ProjectPermissionKey permissionKey, @Nonnull Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        return this.withPermissionOverriding(this.doProjectPermissionCheck(permissionKey, project, user, issueCreation), permissionKey, project, user);
    }

    private boolean doIssuePermissionCheck(ProjectPermissionKey permissionKey, Issue issue, ApplicationUser user) {
        if (issue.getId() != null) {
            return this.doIssuePermissionCheck(permissionKey, issue, user, false);
        }
        return this.doProjectPermissionCheck(permissionKey, issue.getProjectObject(), user, true);
    }

    private boolean doIssuePermissionCheck(ProjectPermissionKey permissionKey, Issue issue, ApplicationUser user, boolean issueCreation) {
        if (!this.doProjectPermissionCheck(permissionKey, issue.getProjectObject(), user, false)) {
            return false;
        }
        if (!this.doPermissionSchemeCheck(permissionKey, issue, user, issueCreation)) {
            return false;
        }
        if (ProjectPermissions.BROWSE_PROJECTS.equals((Object)permissionKey)) {
            return ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).hasSecurityLevelAccess(issue, user);
        }
        return true;
    }

    private boolean doPermissionSchemeCheck(ProjectPermissionKey permissionKey, Issue issue, ApplicationUser user, boolean issueCreation) {
        if (!this.projectPermissionTypesManager.exists(permissionKey)) {
            return false;
        }
        if (user == null) {
            return ComponentAccessor.getPermissionSchemeManager().hasSchemePermission(permissionKey, issue);
        }
        return user.isActive() && ComponentAccessor.getPermissionSchemeManager().hasSchemePermission(permissionKey, issue, user, issueCreation);
    }

    private boolean doProjectPermissionCheck(@Nonnull ProjectPermissionKey permissionKey, Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        if (project == null || project.getId() == null) {
            throw new IllegalArgumentException("The Project argument and its backing generic value must not be null");
        }
        if (!this.projectPermissionTypesManager.exists(permissionKey)) {
            return false;
        }
        if (user == null) {
            return ComponentAccessor.getPermissionSchemeManager().hasSchemePermission(permissionKey, project);
        }
        return user.isActive() && ComponentAccessor.getPermissionSchemeManager().hasSchemePermission(permissionKey, project, user, issueCreation);
    }

    private ProjectWidePermission doProjectWidePermissionCheck(@Nonnull ProjectPermissionKey permissionKey, Project project, @Nullable ApplicationUser user, boolean issueCreation) {
        if (project == null || project.getId() == null) {
            throw new IllegalArgumentException("The Project argument and its backing generic value must not be null");
        }
        if (!this.projectPermissionTypesManager.exists(permissionKey)) {
            return ProjectWidePermission.NO_ISSUES;
        }
        if (user == null) {
            return ComponentAccessor.getPermissionSchemeManager().hasSchemePermission(permissionKey, project) ? ProjectWidePermission.ALL_ISSUES : ProjectWidePermission.NO_ISSUES;
        }
        if (user.isActive()) {
            return ComponentAccessor.getPermissionSchemeManager().hasProjectWidePermission(permissionKey, project, user, issueCreation);
        }
        return ProjectWidePermission.NO_ISSUES;
    }

    public void removeGroupPermissions(String group) throws RemoveException {
        Assertions.notNull((String)"group", (Object)group);
        Assertions.notNull((Object)ComponentAccessor.getGroupManager().getGroup(group));
        ComponentAccessor.getGlobalPermissionManager().removePermissions(group);
        ComponentAccessor.getPermissionSchemeManager().removeEntities("group", group);
        ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).removeEntities("group", group);
    }

    public void removeUserPermissions(ApplicationUser user) throws RemoveException {
        Assertions.notNull((String)"user", (Object)user);
        ComponentAccessor.getPermissionSchemeManager().removeEntities("user", user.getKey());
        ((IssueSecuritySchemeManager)ComponentAccessor.getComponent(IssueSecuritySchemeManager.class)).removeEntities("user", user.getKey());
    }

    public boolean hasProjects(int permissionId, ApplicationUser user) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionId);
        return this.hasProjects(permissionKey, user);
    }

    public boolean hasProjects(@Nonnull ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.projectPermissionTypesManager.exists(permissionKey) && Iterables.any((Iterable)ComponentAccessor.getProjectManager().getProjectObjects(), project -> this.hasPermission(permissionKey, (Project)project, user));
    }

    public Collection<Project> getProjects(int permissionId, ApplicationUser user) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionId);
        return this.getProjectObjects(permissionKey, user);
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.getProjectObjects(permissionKey, user);
    }

    protected Collection<Project> getProjectObjects(ProjectPermissionKey permissionKey, ApplicationUser user) {
        return this.getProjectObjectsWithPermission(ComponentAccessor.getProjectManager().getProjectObjects(), permissionKey, user);
    }

    public Collection<Project> getProjects(int permissionId, ApplicationUser user, ProjectCategory projectCategory) {
        ProjectPermissionKey permissionKey = this.getNonGlobalKey(permissionId);
        return this.getProjects(permissionKey, user, projectCategory);
    }

    public Collection<Project> getProjects(@Nonnull ProjectPermissionKey permissionKey, @Nullable ApplicationUser user, @Nullable ProjectCategory projectCategory) {
        Collection projects = projectCategory == null ? ComponentAccessor.getProjectManager().getProjectObjectsWithNoCategory() : ComponentAccessor.getProjectManager().getProjectsFromProjectCategory(projectCategory);
        return this.getProjectObjectsWithPermission(projects, permissionKey, user);
    }

    public void flushCache() {
    }

    private Collection<Project> getProjectObjectsWithPermission(Collection<Project> projects, ProjectPermissionKey permissionKey, ApplicationUser user) {
        if (!this.projectPermissionTypesManager.exists(permissionKey)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Iterable)Iterables.filter(projects, project -> this.hasPermission(permissionKey, (Project)project, user)));
    }

    private ProjectPermissionKey getNonGlobalKey(int permissionId) {
        if (this.isGlobalPermission(permissionId)) {
            throw new IllegalArgumentException("PermissionType passed to this function must NOT be a global permission, " + permissionId + " is global");
        }
        return LegacyProjectPermissionKeyMapping.getKey(permissionId);
    }

    protected boolean isGlobalPermission(int permissionId) {
        return Permissions.isGlobalPermission((int)permissionId);
    }

    public Collection<Group> getAllGroups(int permissionId, Project project) {
        HashSet<Group> groups = new HashSet<Group>();
        groups.addAll(ComponentAccessor.getPermissionSchemeManager().getGroups(new ProjectPermissionKey(permissionId), project));
        groups.addAll(ComponentAccessor.getGlobalPermissionManager().getGroupsWithPermission(permissionId));
        return groups;
    }

    private ProjectWidePermission withPermissionOverriding(ProjectWidePermission corePermissionCheckResult, final ProjectPermissionKey permissionKey, final Project project, final ApplicationUser applicationUser) {
        if (corePermissionCheckResult == ProjectWidePermission.NO_ISSUES || ProjectPermissions.BROWSE_PROJECTS.equals((Object)permissionKey)) {
            return corePermissionCheckResult;
        }
        boolean pluginPermissionCheckDeclined = Iterables.any(this.projectPermissionOverrideDescriptorCache.getProjectPermissionOverrideDescriptors(), (Predicate)new Predicate<ProjectPermissionOverrideModuleDescriptor>(){

            public boolean apply(ProjectPermissionOverrideModuleDescriptor permissionOverrideModuleDescriptor) {
                return SafePluginPointAccess.safe((Predicate)new Predicate<ProjectPermissionOverrideModuleDescriptor>(){

                    public boolean apply(ProjectPermissionOverrideModuleDescriptor permissionOverrideModuleDescriptor) {
                        ProjectPermissionOverride.Decision decision = ((ProjectPermissionOverride)permissionOverrideModuleDescriptor.getModule()).hasPermission(permissionKey, project, applicationUser);
                        if (log.isDebugEnabled() && decision == ProjectPermissionOverride.Decision.DENY) {
                            log.debug("Permission check result to project " + project.getKey() + "was overriden by " + permissionOverrideModuleDescriptor.getCompleteKey());
                        }
                        return decision == ProjectPermissionOverride.Decision.DENY;
                    }
                }).apply((Object)permissionOverrideModuleDescriptor);
            }
        });
        if (pluginPermissionCheckDeclined) {
            return ProjectWidePermission.NO_ISSUES;
        }
        return corePermissionCheckResult;
    }

    private boolean withPermissionOverriding(boolean corePermissionCheckResult, final ProjectPermissionKey permissionKey, final Project project, final ApplicationUser applicationUser) {
        if (!corePermissionCheckResult || ProjectPermissions.BROWSE_PROJECTS.equals((Object)permissionKey)) {
            return corePermissionCheckResult;
        }
        Boolean pluginPermissionCheckDeclined = (Boolean)MoreObjects.firstNonNull((Object)Iterables.any(this.projectPermissionOverrideDescriptorCache.getProjectPermissionOverrideDescriptors(), permissionOverrideModuleDescriptor -> SafePluginPointAccess.safe((Predicate)new Predicate<ProjectPermissionOverrideModuleDescriptor>(){

            public boolean apply(ProjectPermissionOverrideModuleDescriptor permissionOverrideModuleDescriptor) {
                ProjectPermissionOverride.Decision decision = ((ProjectPermissionOverride)permissionOverrideModuleDescriptor.getModule()).hasPermission(permissionKey, project, applicationUser);
                if (log.isDebugEnabled() && decision == ProjectPermissionOverride.Decision.DENY) {
                    log.debug("Permission check result to project " + project.getKey() + "was overriden by " + permissionOverrideModuleDescriptor.getCompleteKey());
                }
                return decision == ProjectPermissionOverride.Decision.DENY;
            }
        }).apply(permissionOverrideModuleDescriptor)), (Object)false);
        return pluginPermissionCheckDeclined == false;
    }
}

