/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.roles.actor;

import com.atlassian.annotations.Internal;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.database.DbConnectionManager;
import com.atlassian.jira.model.querydsl.QProjectRoleActor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleActor;
import com.atlassian.jira.security.roles.RoleActor;
import com.atlassian.jira.security.roles.RoleActorDoesNotExistException;
import com.atlassian.jira.security.roles.RoleActorFactory;
import com.atlassian.jira.security.roles.actor.AbstractRoleActor;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableSet;
import com.mysema.commons.lang.CloseableIterator;
import com.mysema.query.Tuple;
import com.mysema.query.sql.SQLQuery;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Predicate;
import com.mysema.query.types.Projections;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Internal
public class GroupRoleActorFactory
implements RoleActorFactory {
    private final GroupManager groupManager;
    private final DbConnectionManager dbConnectionManager;

    public GroupRoleActorFactory(GroupManager groupManager, DbConnectionManager dbConnectionManager) {
        this.groupManager = groupManager;
        this.dbConnectionManager = dbConnectionManager;
    }

    public ProjectRoleActor createRoleActor(Long id, Long projectRoleId, Long projectId, String type, String groupName) throws RoleActorDoesNotExistException {
        if (!"atlassian-group-role-actor".equals(type)) {
            throw new IllegalArgumentException(this.getClass().getName() + " cannot create RoleActors of type: " + type);
        }
        return new GroupRoleActor(id, projectRoleId, projectId, groupName, this.groupManager.groupExists(groupName));
    }

    public Set<RoleActor> optimizeRoleActorSet(Set<RoleActor> roleActors) {
        return roleActors;
    }

    @Nonnull
    public Set<ProjectRoleActor> getAllRoleActorsForUser(@Nullable ApplicationUser user) {
        if (user == null) {
            return ImmutableSet.of();
        }
        List groupNames = this.groupManager.getGroupNamesForUser(user).stream().map(IdentifierUtils::toLowerCase).collect(Collectors.toList());
        ImmutableSet.Builder resultsBuilder = ImmutableSet.builder();
        this.dbConnectionManager.execute(dbConnection -> {
            QProjectRoleActor pra = new QProjectRoleActor("pra");
            try (CloseableIterator roleActorTuples = ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().from((Expression)pra)).where((Predicate)pra.roletype.eq((Object)"atlassian-group-role-actor").and((Predicate)pra.pid.isNotNull()))).iterate((Expression)Projections.tuple((Expression[])new Expression[]{pra.id, pra.pid, pra.projectroleid, pra.roletype, pra.roletypeparameter}));){
                this.addMatchingActors((Iterator<Tuple>)roleActorTuples, pra, groupNames, (ImmutableSet.Builder<ProjectRoleActor>)resultsBuilder);
            }
        });
        return resultsBuilder.build();
    }

    private void addMatchingActors(Iterator<Tuple> roleActorTuples, QProjectRoleActor pra, Collection<String> groupNames, ImmutableSet.Builder<ProjectRoleActor> resultsBuilder) {
        while (roleActorTuples.hasNext()) {
            Tuple tuple = roleActorTuples.next();
            String groupName = IdentifierUtils.toLowerCase((String)((String)tuple.get((Expression)pra.roletypeparameter)));
            if (!groupNames.contains(groupName)) continue;
            GroupRoleActor actor = new GroupRoleActor((Long)tuple.get(pra.id), (Long)tuple.get(pra.projectroleid), (Long)tuple.get(pra.pid), groupName, true);
            resultsBuilder.add((Object)actor);
        }
    }

    public class GroupRoleActor
    extends AbstractRoleActor {
        private final boolean active;

        GroupRoleActor(Long id, Long projectRoleId, Long projectId, String groupName, boolean active) {
            super(id, projectRoleId, projectId, groupName);
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public String getType() {
            return "atlassian-group-role-actor";
        }

        public String getDescriptor() {
            return this.getParameter();
        }

        public Set<ApplicationUser> getUsers() {
            HashSet<ApplicationUser> users = new HashSet<ApplicationUser>();
            for (ApplicationUser user : GroupRoleActorFactory.this.groupManager.getUsersInGroup(this.getParameter())) {
                users.add(user);
            }
            return users;
        }

        public boolean contains(ApplicationUser user) {
            return GroupRoleActorFactory.this.groupManager.isUserInGroup(user, this.getParameter());
        }

        public Group getGroup() throws IllegalArgumentException {
            return GroupRoleActorFactory.this.groupManager.getGroupEvenWhenUnknown(this.getParameter());
        }
    }
}

