/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.PermissionContext;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.security.type.SimpleIssueFieldSecurityType;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;

public class CurrentAssigneeHasAssignablePermission
extends SimpleIssueFieldSecurityType {
    private JiraAuthenticationContext authenticationContext;
    private ProjectFactory projectFactory;

    public CurrentAssigneeHasAssignablePermission(JiraAuthenticationContext jiraAuthenticationContext, ProjectFactory projectFactory) {
        this.authenticationContext = jiraAuthenticationContext;
        this.projectFactory = projectFactory;
    }

    @Override
    public String getDisplayName() {
        return this.authenticationContext.getI18nHelper().getText("admin.permission.types.current.assignee.has.assignable.perm");
    }

    @Override
    public String getType() {
        return "assigneeassignable";
    }

    public void doValidation(String key, Map parameters, JiraServiceContext jiraServiceContext) {
    }

    @Override
    protected String getFieldName(String parameter) {
        return "issue_assignee";
    }

    @Override
    public boolean isValidForPermission(ProjectPermissionKey permissionKey) {
        return !ProjectPermissions.ASSIGNABLE_USER.equals((Object)permissionKey);
    }

    @Override
    protected boolean hasProjectPermission(ApplicationUser user, boolean issueCreation, Project project) {
        return this.getPermissionManager().hasPermission(ProjectPermissions.ASSIGNABLE_USER, project, user, issueCreation);
    }

    @VisibleForTesting
    PermissionManager getPermissionManager() {
        return ComponentAccessor.getPermissionManager();
    }

    @Override
    protected String getField() {
        return "assignee";
    }

    @Override
    public Set<ApplicationUser> getUsers(PermissionContext ctx, String ignored) {
        Issue issue = ctx.getIssue();
        if (issue != null && issue.getAssignee() != null && this.getPermissionManager().hasPermission(17, issue.getAssignee())) {
            return Sets.newHashSet((Object[])new ApplicationUser[]{issue.getAssignee()});
        }
        return Sets.newHashSet();
    }

    @Override
    protected String getFieldValue(Issue issue) {
        return issue.getAssigneeId();
    }
}

