/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service;

import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.service.InBuiltServiceTypes;
import com.atlassian.jira.service.services.DebugService;
import com.atlassian.jira.service.services.auditing.AuditLogCleaningService;
import com.atlassian.jira.service.services.cluster.ClusterMessageCleaningService;
import com.atlassian.jira.service.services.export.ExportService;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.service.services.index.ReplicatedIndexCleaningService;
import com.atlassian.jira.service.services.mail.MailFetcherService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;

public class DefaultInBuiltServiceTypes
implements InBuiltServiceTypes {
    private static final Set<InBuiltServiceTypes.InBuiltServiceType> IN_BUILT_SERVICE_TYPES = ImmutableSet.of((Object)new InBuiltServiceTypes.InBuiltServiceType(MailFetcherService.class, "admin.services.create.issues.from.mail"), (Object)new InBuiltServiceTypes.InBuiltServiceType(FileService.class, "admin.services.create.issues.from.local.files"), (Object)new InBuiltServiceTypes.InBuiltServiceType(DebugService.class, "admin.services.debugging.service"), (Object)new InBuiltServiceTypes.InBuiltServiceType(ExportService.class, "admin.services.backup.service"), (Object)new InBuiltServiceTypes.InBuiltServiceType(ReplicatedIndexCleaningService.class, "admin.services.indexcleaner.service"), (Object)new InBuiltServiceTypes.InBuiltServiceType(ClusterMessageCleaningService.class, "admin.services.cluster.message.cleaner"), (Object[])new InBuiltServiceTypes.InBuiltServiceType[]{new InBuiltServiceTypes.InBuiltServiceType(AuditLogCleaningService.class, "admin.services.auditing.auditlogcleaner.service")});
    private static final Set<InBuiltServiceTypes.InBuiltServiceType> ADMIN_MANAGEABLE_SERVICE_TYPES = ImmutableSet.copyOf((Iterable)Iterables.filter(IN_BUILT_SERVICE_TYPES, (Predicate)new Predicate<InBuiltServiceTypes.InBuiltServiceType>(){

        public boolean apply(InBuiltServiceTypes.InBuiltServiceType input) {
            return MailFetcherService.class.isAssignableFrom(input.getType());
        }
    }));
    private final PermissionManager permissionManager;

    public DefaultInBuiltServiceTypes(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Override
    public Set<InBuiltServiceTypes.InBuiltServiceType> all() {
        return IN_BUILT_SERVICE_TYPES;
    }

    @Override
    public Set<InBuiltServiceTypes.InBuiltServiceType> manageableBy(ApplicationUser user) {
        if (Users.isAnonymous((ApplicationUser)user)) {
            return ImmutableSet.of();
        }
        if (this.permissionManager.hasPermission(44, user)) {
            return this.all();
        }
        if (this.permissionManager.hasPermission(0, user)) {
            return ADMIN_MANAGEABLE_SERVICE_TYPES;
        }
        return ImmutableSet.of();
    }
}

