/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.analytics.start;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.service.services.analytics.JiraAnalyticTask;
import com.atlassian.jira.util.collect.MapBuilder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupAnalyticTask
implements JiraAnalyticTask {
    private static final Logger LOG = LoggerFactory.getLogger(GroupAnalyticTask.class);
    private GroupManager groupManager;

    @Override
    public void init() {
        this.groupManager = ComponentAccessor.getGroupManager();
    }

    @Override
    public Map<String, Object> getAnalytics() {
        LOG.debug("Running GroupAnalyticTask");
        MapBuilder builder = MapBuilder.newBuilder();
        builder.add((Object)"groups.total", (Object)this.groupManager.getAllGroups().size());
        return builder.toMap();
    }

    @Override
    public boolean isReportingDataShape() {
        return true;
    }
}

