/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.startup.DelayedStartupState;
import com.atlassian.jira.startup.JiraHomeStartupCheck;
import com.atlassian.jira.startup.JiraStartupState;
import com.atlassian.jira.startup.JiraWebappStartupCheck;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.startup.StartupStateTemplate;
import com.google.common.collect.ImmutableList;
import java.util.concurrent.atomic.AtomicReference;

public class BootstrappingStartupState
extends StartupStateTemplate
implements JiraStartupState {
    private static final ImmutableList<StartupCheck> STARTUP_CHECKS = ImmutableList.of((Object)new JiraWebappStartupCheck(), (Object)JiraHomeStartupCheck.getInstance());
    private final AtomicReference<JiraStartupState> currentState;

    public BootstrappingStartupState(AtomicReference<JiraStartupState> currentState) {
        this.currentState = currentState;
    }

    @Override
    public void onPluginSystemStarted() throws IllegalStateException {
        throw new IllegalStateException("onPluginSystemStarted() called before onPluginSystemDelayed()");
    }

    @Override
    public void onPluginSystemDelayed() throws IllegalStateException {
        this.currentState.set(new DelayedStartupState(this, this.currentState));
    }

    @Override
    public void onPluginSystemStopped() {
        throw new IllegalStateException("onPluginSystemStopped() called before onPluginSystemDelayed()");
    }

    @Override
    public void onPluginSystemRestarted() {
        throw new IllegalStateException("onPluginSystemRestarted() called before onPluginSystemDelayed()");
    }

    @Override
    public void onJiraStopping() {
        for (StartupCheck startupCheck : STARTUP_CHECKS) {
            startupCheck.stop();
        }
        this.currentState.set(new BootstrappingStartupState(this.currentState));
    }

    @Override
    protected ImmutableList<StartupCheck> getStartupChecks() {
        return STARTUP_CHECKS;
    }
}

