/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.config.util.StartupJiraHome;
import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.StaticHelpUrls;
import com.atlassian.jira.plugin.PluginPath;
import com.atlassian.jira.service.services.file.FileService;
import com.atlassian.jira.startup.ApplicationPropertiesJiraHomePathLocator;
import com.atlassian.jira.startup.CompositeJiraHomePathLocator;
import com.atlassian.jira.startup.JiraHomeException;
import com.atlassian.jira.startup.JiraHomeLockAcquirer;
import com.atlassian.jira.startup.JiraHomePathLocator;
import com.atlassian.jira.startup.StartupCheck;
import com.atlassian.jira.startup.SystemPropertyJiraHomePathLocator;
import com.atlassian.jira.startup.WebContextJiraHomePathLocator;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ServletContextProvider;
import com.google.common.annotations.VisibleForTesting;
import com.opensymphony.util.TextUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraHomeStartupCheck
implements StartupCheck {
    private static final Logger log = LoggerFactory.getLogger(JiraHomeStartupCheck.class);
    private static JiraHomeStartupCheck HOME_STARTUP_CHECK;
    private static final CompositeJiraHomePathLocator pathLocator;
    private final JiraHomePathLocator locator;
    private final JiraHomeLockAcquirer lockAcquirer;
    private volatile String faultDescription;
    private volatile String faultDescriptionHtml;
    private volatile File jiraHomeDirectory;
    private volatile boolean initalised = false;

    @ClusterSafe(value="Program Artifact")
    public static synchronized JiraHomeStartupCheck getInstance() {
        if (HOME_STARTUP_CHECK == null) {
            HOME_STARTUP_CHECK = new JiraHomeStartupCheck(pathLocator);
        }
        return HOME_STARTUP_CHECK;
    }

    @VisibleForTesting
    JiraHomeStartupCheck(JiraHomePathLocator locator) {
        this.locator = locator;
        this.lockAcquirer = new JiraHomeLockAcquirer();
    }

    @Override
    public String getName() {
        return "Jira.Home Startup Check";
    }

    @Override
    public boolean isOk() {
        if (!this.initalised) {
            try {
                String jiraHome = this.getConfiguredJiraHome();
                this.jiraHomeDirectory = this.validateJiraHome(jiraHome);
            }
            catch (JiraHomeException ex) {
                this.faultDescriptionHtml = ex.getHtmlMessage();
                this.faultDescription = ex.getMessage();
            }
            finally {
                this.initalised = true;
            }
        }
        return this.jiraHomeDirectory != null;
    }

    public boolean isInitialised() {
        return this.initalised;
    }

    private String getConfiguredJiraHome() throws JiraHomeException {
        String home = this.locator.getJiraHome();
        if (StringUtils.isBlank((String)home)) {
            throw this.newJiraHomeExceptionWithHelpLink("No jira.home is configured.\nSee %s for instructions on setting jira.home", "jirahome");
        }
        return home;
    }

    private boolean findDirectory(File directoryToTraverse, File directoryToFind) {
        for (File currentDirectory = directoryToTraverse; currentDirectory != null; currentDirectory = currentDirectory.getParentFile()) {
            if (!currentDirectory.equals(directoryToFind)) continue;
            return true;
        }
        return false;
    }

    private File validateJiraHome(String jiraHome) throws JiraHomeException {
        ServletContext servletContext;
        File proposedJiraHome = new File(jiraHome);
        if (!proposedJiraHome.isAbsolute()) {
            if (JiraSystemProperties.isDevMode()) {
                log.warn("jira.home is a relative path, but jira.dev.mode is set to true so we will allow this.");
            } else {
                HelpUrl helpPath = StaticHelpUrls.getInstance().getUrl("jirahome");
                String s = "jira.home must be an absolute path.\nSee %s for instructions on setting jira.home";
                StringBuilder plainText = new StringBuilder(String.format("jira.home must be an absolute path.\nSee %s for instructions on setting jira.home", helpPath.getUrl()));
                String href = String.format("<a href=\"%s\">%s</a>", helpPath.getUrl(), TextUtils.htmlEncode((String)helpPath.getTitle()));
                String htmlText = String.format(TextUtils.htmlEncode((String)"jira.home must be an absolute path.\nSee %s for instructions on setting jira.home"), href);
                plainText.append("\nYour current jira.home is:\n");
                plainText.append(jiraHome);
                boolean deadlyBackslash = JiraSystemProperties.getInstance().getProperty("file.separator").equals("\\");
                if (deadlyBackslash) {
                    plainText.append("\n");
                    plainText.append("It looks like you are on Windows. This is usually caused by incorrect use of backslashes inside of jira-application.properties.\n");
                    plainText.append("Use forward slashes (/) instead.");
                }
                throw new JiraHomeException(plainText.toString(), htmlText);
            }
        }
        if ((servletContext = ServletContextProvider.getServletContext()) == null) {
            log.error("No ServletContext exists - cannot check if jira.home is on the servlet path.");
        } else {
            String realPath = servletContext.getRealPath("/");
            if (realPath != null) {
                File webappServletPath = new File(realPath);
                if (proposedJiraHome.equals(webappServletPath)) {
                    throw new JiraHomeException("Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' must not be the same as the webapp servlet path '" + webappServletPath.getAbsolutePath() + "'");
                }
                if (this.findDirectory(webappServletPath, proposedJiraHome)) {
                    throw new JiraHomeException("Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' must not be a parent directory of the webapp servlet path '" + webappServletPath.getAbsolutePath() + "'");
                }
                if (this.findDirectory(proposedJiraHome, webappServletPath)) {
                    throw new JiraHomeException("Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' must not be a directory within the webapp servlet path '" + webappServletPath.getAbsolutePath() + "'");
                }
            }
        }
        if (proposedJiraHome.exists()) {
            if (!proposedJiraHome.isDirectory()) {
                String message = "Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' is not a directory.";
                throw new JiraHomeException(message);
            }
        } else {
            log.info("Configured jira.home '" + proposedJiraHome.getAbsolutePath() + "' does not exist. We will create it.");
            try {
                if (!proposedJiraHome.mkdirs()) {
                    throw this.newJiraHomeExceptionWithHelpLink("Could not create jira.home directory '" + proposedJiraHome.getAbsolutePath() + "'. " + "Please see %s for more information on how to set up your JIRA home directory.", "jirahome");
                }
            }
            catch (SecurityException ex) {
                throw this.newJiraHomeExceptionWithHelpLink("Could not create jira.home directory '" + proposedJiraHome.getAbsolutePath() + "'. " + "A Security Exception occured. Please see %s for more information on how to set up your JIRA home directory.", "jirahome");
            }
        }
        try {
            this.createLocalHomeDirectories(proposedJiraHome);
            StartupJiraHome home = new StartupJiraHome(this.locator);
            this.createSharedHomeDirectories(home.getHome());
        }
        catch (SecurityException ex) {
            throw this.newJiraHomeExceptionWithHelpLink("Could not create jira.home directory '" + proposedJiraHome.getAbsolutePath() + "'. " + "A Security Exception occured. Please see %s for more information on how to set up your JIRA home directory.", "jirahome");
        }
        this.lockJiraHome(proposedJiraHome);
        log.info("The jira.home directory '" + proposedJiraHome.getAbsolutePath() + "' is validated and locked for exclusive use by this instance.");
        return proposedJiraHome;
    }

    private JiraHomeException newJiraHomeExceptionWithHelpLink(String messageWithUrlPlaceholder, String helpPathKey) {
        HelpUrl helpPath = StaticHelpUrls.getInstance().getUrl(helpPathKey);
        String plainText = String.format(messageWithUrlPlaceholder, helpPath.getUrl());
        String href = String.format("<a href=\"%s\">%s</a>", helpPath.getUrl(), TextUtils.htmlEncode((String)helpPath.getTitle()));
        String htmlText = String.format(TextUtils.htmlEncode((String)messageWithUrlPlaceholder), href);
        return new JiraHomeException(plainText, htmlText);
    }

    void createLocalHomeDirectories(File localJiraHome) throws JiraHomeException {
        SortedSet subdirs = CollectionBuilder.newBuilder().add((Object)IndexPathManager.INDEXES_DIR).add((Object)"plugins").add((Object)PluginPath.INSTALLED_PLUGINS_SUBDIR).addAll((Collection)JiraHome.localsubdirs).asMutableSortedSet();
        this.createHomeDirectories(localJiraHome, subdirs);
    }

    void createSharedHomeDirectories(File sharedJiraHome) throws JiraHomeException {
        SortedSet subdirs = CollectionBuilder.newBuilder().add((Object)AttachmentPathManager.ATTACHMENTS_DIR).add((Object)"plugins").add((Object)PluginPath.BUNDLED_SUBDIR).add((Object)PluginPath.OSGI_SUBDIR).add((Object)FileService.MAIL_DIR).addAll((Collection)JiraHome.sharedsubdirs).asMutableSortedSet();
        this.createHomeDirectories(sharedJiraHome, subdirs);
    }

    private void createHomeDirectories(File proposedJiraHome, Set<String> subdirs) throws JiraHomeException {
        for (String subdir : subdirs) {
            try {
                File dir = new File(proposedJiraHome, subdir);
                if (this.canCreateAndWriteTo(dir)) continue;
                throw new JiraHomeException(String.format("JIRA has no permission to either create or write to subdirectory '%s' of jira.home '%s'.", subdir, proposedJiraHome));
            }
            catch (JiraHomeException homeException) {
                throw homeException;
            }
            catch (Exception e) {
                throw new JiraHomeException(String.format("Error creating subdirectory '%s' of jira.home '%s'.", subdir, proposedJiraHome) + "\n" + e.getMessage());
            }
        }
    }

    private boolean canCreateAndWriteTo(File dir) {
        return dir.exists() && dir.canWrite() || dir.mkdirs();
    }

    private void lockJiraHome(File proposedJiraHome) throws JiraHomeException {
        Assertions.notNull((String)"You should not be in this method if you have a null lockAcquirer", (Object)this.lockAcquirer);
        String jiraHomePath = this.getJiraHomePath(proposedJiraHome);
        String failMsg = "Unable to create and acquire lock file for jira.home directory '" + jiraHomePath + "'.";
        try {
            JiraHomeLockAcquirer.LockResult result = this.lockAcquirer.acquire(proposedJiraHome);
            if (result != JiraHomeLockAcquirer.LockResult.OK) {
                if (result == JiraHomeLockAcquirer.LockResult.HELD_BY_OTHERS) {
                    String s = "The jira.home directory '%s' is already locked by another running instance of JIRA.";
                    String htmlText = String.format(TextUtils.htmlEncode((String)"The jira.home directory '%s' is already locked by another running instance of JIRA."), TextUtils.htmlEncode((String)jiraHomePath));
                    String plainText = "The jira.home directory '" + jiraHomePath + "' is already locked by another running instance of JIRA.";
                    throw new JiraHomeException(plainText, htmlText);
                }
                throw new JiraHomeException(failMsg);
            }
        }
        catch (JiraHomeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.error(failMsg + " " + ex.getMessage(), (Throwable)ex);
            throw new JiraHomeException(failMsg);
        }
    }

    private String getJiraHomePath(File proposedJiraHome) {
        try {
            return proposedJiraHome.getCanonicalPath();
        }
        catch (IOException e) {
            log.debug("Couldn't obtain canonical path for jira.home", (Throwable)e);
            return proposedJiraHome.getAbsolutePath();
        }
    }

    @Override
    public void stop() {
        this.lockAcquirer.release();
    }

    @Override
    public String getFaultDescription() {
        return this.faultDescription;
    }

    @Override
    public String getHTMLFaultDescription() {
        return this.faultDescriptionHtml;
    }

    public File getJiraHomeDirectory() {
        return this.jiraHomeDirectory;
    }

    public String toString() {
        return this.getName();
    }

    static {
        pathLocator = new CompositeJiraHomePathLocator(new SystemPropertyJiraHomePathLocator(), new WebContextJiraHomePathLocator(), new ApplicationPropertiesJiraHomePathLocator());
    }
}

