/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.startup.BootstrappingStartupState;
import com.atlassian.jira.startup.JiraStartupState;
import com.atlassian.jira.startup.StartupCheck;
import java.util.concurrent.atomic.AtomicReference;

public class JiraStartupChecklist {
    private static JiraStartupChecklist INSTANCE;
    private final AtomicReference<JiraStartupState> startupState = new AtomicReference();

    public JiraStartupChecklist() {
        this.startupState.set(new BootstrappingStartupState(this.startupState));
    }

    @ClusterSafe(value="Program Artifact")
    public static synchronized JiraStartupChecklist getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JiraStartupChecklist();
        }
        return INSTANCE;
    }

    public static boolean startupOK() {
        return JiraStartupChecklist.getInstance().startupState().isStartupChecksPassed();
    }

    public static StartupCheck getFailedStartupCheck() {
        return JiraStartupChecklist.getInstance().startupState().getFailedStartupCheck();
    }

    public static void setFailedStartupCheck(StartupCheck startupCheck) {
        JiraStartupChecklist.getInstance().startupState().setFailedStartupCheck(startupCheck);
    }

    public static void stop() {
        JiraStartupChecklist.getInstance().startupState().onJiraStopping();
    }

    protected JiraStartupState startupState() {
        return this.startupState.get();
    }
}

