/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.plugin.JiraPluginSystemListener;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.plugin.event.events.PluginContainerRefreshedEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginEnablingEvent;
import com.atlassian.plugin.event.events.PluginFrameworkDelayedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartingEvent;
import com.atlassian.plugin.event.events.PluginFrameworkWarmRestartedEvent;
import com.atlassian.plugin.util.PluginUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class JiraStartupPluginSystemListener
implements JiraPluginSystemListener {
    static final int PLUGIN_ENABLING_WAIT_PERIOD = PluginUtils.getDefaultEnablingWaitPeriod();
    private static final int WEIGHT_FOR_ENABLING = 1;
    private static final int WEIGHT_FOR_REFRESHED = 98;
    private static final int WEIGHT_FOR_ENABLED = 1;
    private static final int TOTAL_WEIGHT = 100;
    private static final double FUDGE_FACTOR = 0.3;
    private static final double EARLY_STARTUP_FACTOR = 0.95;
    private static final AtomicReference<Tracker> TRACKER = new AtomicReference<StartupTracker>(new StartupTracker(0.0, 0.95));

    public JiraStartupPluginSystemListener(EventPublisher eventPublisher) {
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onPluginSystemStarting(PluginFrameworkStartingEvent event) {
        TRACKER.set(new StartupTracker(0.0, 0.95));
    }

    @EventListener
    public void onPluginSystemStarted(PluginFrameworkStartedEvent event) {
        JiraStartupChecklist.getInstance().startupState().onPluginSystemStarted();
        TRACKER.set(new DoneTracker());
    }

    @EventListener
    public void onPluginSystemShutdown(PluginFrameworkShutdownEvent event) {
        JiraStartupChecklist.getInstance().startupState().onPluginSystemStopped();
    }

    @EventListener
    public void onPluginSystemRestarted(PluginFrameworkWarmRestartedEvent event) {
        JiraStartupChecklist.getInstance().startupState().onPluginSystemRestarted();
    }

    @EventListener
    public void onPluginSystemDelayed(PluginFrameworkDelayedEvent event) {
        JiraStartupChecklist.getInstance().startupState().onPluginSystemDelayed();
        TRACKER.set(new StartupTracker(0.95, 0.050000000000000044));
    }

    @EventListener
    public void onPluginEnabling(PluginEnablingEvent event) {
        TRACKER.get().accept(1);
    }

    @EventListener
    public void onPluginContainerRefreshed(PluginContainerRefreshedEvent event) {
        TRACKER.get().accept(98);
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        TRACKER.get().accept(1);
    }

    public static void addPlugins(int expectedCount) {
        TRACKER.get().expect(expectedCount * 100);
    }

    public static int getProgress(int budget) {
        return TRACKER.get().getProgress(budget);
    }

    static int budget(int budget, double ratio) {
        int progress = (int)((double)budget * ratio);
        return Math.max(0, Math.min(progress, budget));
    }

    static double ratio(int portion, int total) {
        return total == 0 ? 0.0 : JiraStartupPluginSystemListener.normalized((double)portion / (double)total);
    }

    static double normalized(double ratio) {
        return Math.max(0.0, Math.min(ratio, 1.0));
    }

    static class StartupTracker
    implements Tracker {
        private final AtomicInteger expected = new AtomicInteger();
        private final AtomicInteger accepted = new AtomicInteger();
        private final long startedAt = this.now();
        private final double offset;
        private final double scale;

        StartupTracker(double offset, double scale) {
            this.offset = offset;
            this.scale = scale;
        }

        @Override
        public void accept(int weight) {
            this.accepted.addAndGet(weight);
        }

        @Override
        public void expect(int count) {
            this.expected.addAndGet(count);
        }

        @Override
        public int getProgress(int budget) {
            if (budget <= 0) {
                return 0;
            }
            int accepted = this.accepted.get();
            int expected = this.expected.get();
            double ratio = expected > 0 ? this.fudge(JiraStartupPluginSystemListener.ratio(accepted, expected)) : 0.0;
            return JiraStartupPluginSystemListener.budget(budget, this.scale(ratio));
        }

        private double fudge(double progress) {
            int seconds = (int)TimeUnit.NANOSECONDS.toSeconds(this.now() - this.startedAt);
            double fudge = JiraStartupPluginSystemListener.ratio(seconds, this.timeout()) * (1.0 - progress) * 0.3;
            return JiraStartupPluginSystemListener.normalized(progress + fudge);
        }

        private double scale(double progress) {
            return JiraStartupPluginSystemListener.normalized(this.offset + this.scale * progress);
        }

        @VisibleForTesting
        protected long now() {
            return System.nanoTime();
        }

        @VisibleForTesting
        protected int timeout() {
            return PLUGIN_ENABLING_WAIT_PERIOD;
        }
    }

    static class DoneTracker
    implements Tracker {
        DoneTracker() {
        }
    }

    static interface Tracker {
        default public void accept(int weight) {
        }

        default public void expect(int weight) {
        }

        default public int getProgress(int budget) {
            return budget;
        }
    }
}

