/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.cluster.ClusterServicesRegistry;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.ForkedThreadExecutor;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.RequiresTaskInformation;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskDescriptorImpl;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskMatcher;
import com.atlassian.jira.task.TaskProgressAdapter;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.task.TaskProgressListener;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Functions;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.Transformed;
import com.atlassian.jira.util.concurrent.BlockingCounter;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;

public class TaskManagerImpl
implements TaskManager,
TaskProgressListener {
    public static final String TASK_CANCEL = "Task Cancel Request";
    private static final Logger log = Logger.getLogger(TaskManagerImpl.class);
    private static final Function<TaskDescriptorImpl<?>, TaskDescriptor<?>> COPY = new Function<TaskDescriptorImpl<?>, TaskDescriptor<?>>(){

        public TaskDescriptor<?> get(TaskDescriptorImpl<?> input) {
            return TaskManagerImpl.copy(input);
        }
    };
    private static final CacheSettings TASKMAP_CACHE_SETTINGS = new CacheSettingsBuilder().unflushable().replicateViaCopy().build();
    private static final CacheSettings FUTUREMAP_CACHE_SETTINGS = new CacheSettingsBuilder().local().unflushable().build();
    private final Cache<Long, TaskDescriptorImpl<?>> taskMap;
    private final Cache<Long, Future<?>> futureMap;
    private final JiraAuthenticationContext authenticationContext;
    private final ClusterServicesRegistry clusterServicesRegistry;
    private final DelegatorInterface delegatorInterface;
    private final UserManager userManager;
    private final BlockingCounter activeThreads = new BlockingCounter();
    private final MessageConsumer messageConsumer;
    private ExecutorService executorService;

    public TaskManagerImpl(JiraAuthenticationContext authenticationContext, ClusterServicesRegistry clusterServicesRegistry, CacheManager cacheManager, DelegatorInterface delegatorInterface, UserManager userManager) {
        this.authenticationContext = authenticationContext;
        this.clusterServicesRegistry = clusterServicesRegistry;
        this.delegatorInterface = delegatorInterface;
        this.userManager = userManager;
        this.taskMap = cacheManager.getCache(TaskManagerImpl.class.getName() + ".taskMap", null, TASKMAP_CACHE_SETTINGS);
        this.futureMap = cacheManager.getCache(TaskManagerImpl.class.getName() + ".futureMap", null, FUTUREMAP_CACHE_SETTINGS);
        this.messageConsumer = new MessageConsumer(this.futureMap);
        clusterServicesRegistry.getMessageHandlerService().registerListener(TASK_CANCEL, this.messageConsumer);
        this.start();
    }

    @Override
    public <V extends Serializable> TaskDescriptor<V> submitTask(@Nonnull Callable<V> callable, @Nonnull String taskDescription, @Nonnull TaskContext taskContext) throws RejectedExecutionException {
        return this.submitTask(callable, taskDescription, taskContext, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V extends Serializable> TaskDescriptor<V> submitTask(@Nonnull Callable<V> callable, @Nonnull String taskDescription, @Nonnull TaskContext taskContext, boolean cancellable) throws RejectedExecutionException {
        ApplicationUser user;
        Assertions.notNull((String)"callable", callable);
        Assertions.notNull((String)"taskContext", (Object)taskContext);
        Assertions.notNull((String)"taskDescription", (Object)taskDescription);
        Long taskId = this.getNextTaskId();
        log.debug((Object)("New task ID acquired: " + taskId));
        TaskProgressAdapter taskProgressAdapter = null;
        if (callable instanceof ProvidesTaskProgress) {
            taskProgressAdapter = new TaskProgressAdapter();
            taskProgressAdapter.addListener(this);
        }
        String userName = (user = this.authenticationContext.getUser()) == null ? null : user.getName();
        TaskDescriptorImpl taskDescriptor = new TaskDescriptorImpl(taskId, taskDescription, taskContext, userName, taskProgressAdapter, cancellable);
        FutureTask futureTask = new FutureTask(new TaskCallableDecorator(callable, taskDescriptor, this.authenticationContext, this.activeThreads));
        if (callable instanceof ProvidesTaskProgress) {
            taskProgressAdapter.setTaskDescriptor(taskDescriptor);
            ((ProvidesTaskProgress)((Object)callable)).setTaskProgressSink(taskProgressAdapter);
        }
        if (callable instanceof RequiresTaskInformation) {
            RequiresTaskInformation requiresTaskInformation = (RequiresTaskInformation)((Object)callable);
            requiresTaskInformation.setTaskDescriptor(taskDescriptor);
        }
        TaskManagerImpl taskManagerImpl = this;
        synchronized (taskManagerImpl) {
            TaskDescriptor<V> testTaskDescriptor = this.getLiveTask(taskContext);
            if (testTaskDescriptor != null) {
                throw new AlreadyExecutingException(testTaskDescriptor, "A task with this context has already been submitted");
            }
            this.taskMap.put((Object)taskId, taskDescriptor);
            this.futureMap.put((Object)taskId, futureTask);
        }
        this.submitTaskInternal(futureTask);
        return new TaskDescriptorImpl(taskDescriptor);
    }

    private Long getNextTaskId() {
        return this.delegatorInterface.getNextSeqId("TaskIdSequence");
    }

    @Override
    public void removeTask(@Nonnull Long taskId) {
        this.taskMap.remove((Object)taskId);
        this.futureMap.remove((Object)taskId);
    }

    @Override
    public void cancelTask(@Nonnull Long taskId) throws IllegalStateException {
        TaskDescriptorImpl task = (TaskDescriptorImpl)this.taskMap.get((Object)taskId);
        Future future = (Future)this.futureMap.get((Object)taskId);
        if (task == null) {
            throw new InvalidParameterException("Task not found for taskId = '" + taskId + "'");
        }
        if (!task.isCancellable()) {
            throw new IllegalStateException("Task '" + taskId + "' is not cancellable");
        }
        if (future != null) {
            future.cancel(false);
        } else {
            this.clusterServicesRegistry.getMessageHandlerService().sendMessage("ALL", new Message(TASK_CANCEL, taskId.toString()));
        }
        task.setCancelled(true);
        this.refreshTaskInTaskCache(task);
    }

    @Override
    public void cancelTaskIfRunningLocally(@Nonnull Long taskId) {
        this.messageConsumer.cancelTaskIfRunningLocally(taskId);
    }

    @Override
    public boolean isCancellable(@Nonnull Long taskId) {
        TaskDescriptor task = (TaskDescriptor)this.taskMap.get((Object)taskId);
        if (task == null) {
            throw new InvalidParameterException("Task not found for taskId = '" + taskId + "'");
        }
        return task.isCancellable();
    }

    @Override
    public boolean isCancelled(Long taskId) {
        TaskDescriptor task = (TaskDescriptor)this.taskMap.get((Object)taskId);
        if (task == null) {
            throw new InvalidParameterException("Task not found for taskId = '" + taskId + "'");
        }
        return task.isCancelled();
    }

    void submitTaskInternal(FutureTask<?> futureTask) {
        this.executorService.submit(futureTask);
    }

    @Override
    public void start() {
        if (this.executorService == null || this.executorService.isShutdown()) {
            this.executorService = new ForkedThreadExecutor(5, new TaskManagerThreadFactory());
        }
    }

    @Override
    public boolean shutdownAndWait(long waitSeconds) {
        return this.shutdownAndWait(waitSeconds, TimeUnit.SECONDS);
    }

    @Override
    public boolean shutdownAndWait(long timeout, TimeUnit unit) {
        boolean val;
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must be >= 0");
        }
        this.executorService.shutdown();
        try {
            val = this.executorService.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            val = this.executorService.isTerminated();
        }
        this.logRunningTasksOnShutdown();
        return val;
    }

    @Override
    public void shutdownNow() {
        this.executorService.shutdownNow();
    }

    @Override
    public boolean awaitUntilActiveTasksComplete(long seconds) {
        try {
            return this.activeThreads.await(seconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return this.activeThreads.getCount() == 0;
        }
    }

    @Override
    public void waitUntilTaskCompletes(Long taskId) throws ExecutionException, InterruptedException {
        Future future = (Future)this.futureMap.get((Object)taskId);
        if (future != null) {
            try {
                future.get();
            }
            catch (CancellationException e) {
                log.debug((Object)("Task - '" + taskId + "' was cancelled"));
            }
        }
    }

    @Override
    public <V extends Serializable> TaskDescriptor<V> getLiveTask(@Nonnull TaskContext taskContext) {
        Assertions.notNull((String)"taskContext", (Object)taskContext);
        TaskDescriptor<?> result = this.findFirstTask(new ActiveMatcher(taskContext));
        return result;
    }

    @Override
    public <V extends Serializable> TaskDescriptor<V> getTask(Long taskId) {
        if (taskId == null) {
            return null;
        }
        TaskDescriptorImpl input = (TaskDescriptorImpl)this.taskMap.get((Object)taskId);
        return TaskManagerImpl.copy(input);
    }

    @Override
    public boolean hasLiveTaskWithContext(@Nonnull TaskContext taskContext) {
        return this.hasTask(new ActiveMatcher(taskContext));
    }

    @Override
    public boolean hasTaskWithContext(final @Nonnull TaskContext taskContext) {
        Assertions.notNull((String)"taskContext", (Object)taskContext);
        return this.hasTask(new TaskMatcher(){

            @Override
            public boolean match(TaskDescriptor<?> descriptor) {
                return taskContext.equals(descriptor.getTaskContext());
            }
        });
    }

    @Override
    public TaskDescriptor<?> findFirstTask(@Nonnull TaskMatcher matcher) {
        return (TaskDescriptor)CollectionUtil.findFirstMatch(this.getTasks(this.taskMap), (Predicate)new TaskMatcherPredicate(matcher));
    }

    @ClusterSafe(value="We walk the keys of this map with the knowledge this is a canonical pinned cache of all existing tasks.")
    private Collection<? extends TaskDescriptorImpl<?>> getTasks(Cache<Long, TaskDescriptorImpl<?>> taskMap) {
        ArrayList<TaskDescriptorImpl> tasks = new ArrayList<TaskDescriptorImpl>();
        for (Long taskId : taskMap.getKeys()) {
            TaskDescriptorImpl taskDescriptor = (TaskDescriptorImpl)taskMap.get((Object)taskId);
            if (taskDescriptor == null) continue;
            tasks.add(taskDescriptor);
        }
        return tasks;
    }

    @Override
    public Collection<TaskDescriptor<?>> findTasks(@Nonnull TaskMatcher matcher) {
        return this.findTasksInternal(matcher);
    }

    @Override
    public Collection<TaskDescriptor<?>> getAllTasks() {
        return this.sortIntoIdOrder(Transformed.collection(this.getTasks(this.taskMap), COPY));
    }

    @Override
    public Collection<TaskDescriptor<?>> getLiveTasks() {
        return this.sortIntoIdOrder(this.findTasksInternal(new TaskMatcher(){

            @Override
            public boolean match(TaskDescriptor<?> descriptor) {
                return !descriptor.isFinished();
            }
        }));
    }

    private Collection<TaskDescriptor<?>> findTasksInternal(TaskMatcher matcher) {
        Assertions.notNull((String)"matcher", (Object)matcher);
        return CollectionUtil.toList((Iterable)CollectionUtil.transform((Iterable)CollectionUtil.filter(this.getTasks(this.taskMap), (Predicate)new TaskMatcherPredicate(matcher)), (Function)Functions.coerceToSuper()));
    }

    private boolean hasTask(TaskMatcher matcher) {
        return CollectionUtil.contains(this.getTasks(this.taskMap), (Predicate)new TaskMatcherPredicate(matcher));
    }

    private static <V extends Serializable> TaskDescriptor<V> copy(TaskDescriptorImpl<V> input) {
        if (input == null) {
            return null;
        }
        return new TaskDescriptorImpl<V>(input);
    }

    private List<TaskDescriptor<?>> sortIntoIdOrder(Collection<TaskDescriptor<?>> input) {
        ArrayList result = new ArrayList(input);
        Collections.sort(result, new Comparator<TaskDescriptor<?>>(){

            @Override
            public int compare(TaskDescriptor<?> o1, TaskDescriptor<?> o2) {
                return o1.getTaskId().compareTo(o2.getTaskId());
            }
        });
        return result;
    }

    private void logRunningTasksOnShutdown() {
        Collection<TaskDescriptor<?>> liveTasks = this.getLiveTasks();
        if (!liveTasks.isEmpty()) {
            log.warn((Object)"Shutting down task manager while the following tasks are still executing:");
            for (TaskDescriptor<?> taskDescriptor : liveTasks) {
                TaskProgressEvent event;
                StringBuilder sb = new StringBuilder();
                sb.append("Task Id ");
                sb.append(taskDescriptor.getTaskId());
                TaskProgressEvent taskProgressEvent = event = taskDescriptor.getTaskProgressIndicator() == null ? null : taskDescriptor.getTaskProgressIndicator().getLastProgressEvent();
                if (event != null) {
                    sb.append(" - ");
                    sb.append(event.getTaskProgress());
                    sb.append("% complete");
                }
                sb.append(" - ");
                sb.append(taskDescriptor.getDescription());
                log.warn((Object)sb.toString());
            }
        }
    }

    @Override
    public void onProgressMade(TaskProgressEvent event) {
        TaskDescriptorImpl taskDescriptor = (TaskDescriptorImpl)this.taskMap.get((Object)event.getTaskId());
        this.refreshTaskInTaskCache(taskDescriptor);
    }

    private void refreshTaskInTaskCache(TaskDescriptorImpl<?> taskDescriptor) {
        this.taskMap.put((Object)taskDescriptor.getTaskId(), taskDescriptor);
    }

    private static class MessageConsumer
    implements ClusterMessageConsumer {
        private final Cache<Long, Future<?>> futureMap;

        public MessageConsumer(Cache<Long, Future<?>> futureMap) {
            this.futureMap = futureMap;
        }

        public void receive(String channel, String message, String senderId) {
            if (channel.equals(TaskManagerImpl.TASK_CANCEL)) {
                long taskId = Long.valueOf(message);
                this.cancelTaskIfRunningLocally(taskId);
            }
        }

        public void cancelTaskIfRunningLocally(@Nonnull Long taskId) {
            Future future = (Future)this.futureMap.get((Object)taskId);
            if (future != null) {
                future.cancel(false);
            }
        }
    }

    private final class TaskMatcherPredicate
    implements Predicate<TaskDescriptor<?>> {
        final TaskMatcher matcher;

        TaskMatcherPredicate(TaskMatcher matcher) {
            this.matcher = (TaskMatcher)Assertions.notNull((String)"matcher", (Object)matcher);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean evaluate(TaskDescriptor<?> input) {
            TaskDescriptor<?> taskDescriptor = input;
            synchronized (taskDescriptor) {
                return this.matcher.match(input);
            }
        }
    }

    private static class TaskManagerThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadId = new AtomicLong(0L);

        private TaskManagerThreadFactory() {
        }

        @Override
        @Nonnull
        public Thread newThread(@Nonnull Runnable runnable) {
            Thread t = new Thread(runnable, "JiraTaskExectionThread-" + this.threadId.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }

    private static class ActiveMatcher
    implements TaskMatcher {
        private final TaskContext taskContext;

        public ActiveMatcher(TaskContext taskContext) {
            this.taskContext = taskContext;
        }

        @Override
        public boolean match(TaskDescriptor<?> descriptor) {
            return !descriptor.isFinished() && this.taskContext.equals(descriptor.getTaskContext());
        }
    }

    private class TaskCallableDecorator<V extends Serializable>
    implements Callable<V> {
        private final AtomicReference<Callable<V>> actualCallableRef;
        private final TaskDescriptorImpl<V> taskDescriptor;
        private final JiraAuthenticationContext context;
        private final BlockingCounter counter;

        private TaskCallableDecorator(Callable<V> callable, TaskDescriptorImpl<V> taskDescriptor, JiraAuthenticationContext context, BlockingCounter counter) {
            this.counter = counter;
            Assertions.notNull((String)"callable", callable);
            Assertions.notNull((String)"taskDescriptor", taskDescriptor);
            Assertions.notNull((String)"context", (Object)context);
            this.actualCallableRef = new AtomicReference<Callable<Callable<V>>>(callable);
            this.taskDescriptor = taskDescriptor;
            this.context = context;
        }

        @Override
        public V call() throws Exception {
            this.preCallSetup();
            this.taskDescriptor.setStartedTimestamp();
            TaskManagerImpl.this.refreshTaskInTaskCache(this.taskDescriptor);
            this.counter.up();
            try {
                Callable actualCallable = this.actualCallableRef.getAndSet(null);
                if (actualCallable != null) {
                    Serializable result = (Serializable)actualCallable.call();
                    this.taskDescriptor.setResult(result);
                    Serializable serializable = result;
                    return (V)serializable;
                }
                try {
                    throw new IllegalStateException("Callable executed twice.");
                }
                catch (Exception e) {
                    log.error((Object)("Task '" + this.taskDescriptor.getDescription() + "' failed."), (Throwable)e);
                    throw e;
                }
            }
            finally {
                this.postCallTearDown();
            }
        }

        private void preCallSetup() {
            JiraThreadLocalUtils.preCall();
            ApplicationUser user = TaskManagerImpl.this.userManager.getUserByName(this.taskDescriptor.getUserName());
            this.context.setLoggedInUser(user);
        }

        private void postCallTearDown() {
            this.taskDescriptor.setFinishedTimestamp();
            TaskManagerImpl.this.refreshTaskInTaskCache(this.taskDescriptor);
            this.counter.down();
            JiraThreadLocalUtils.postCall(log, new JiraThreadLocalUtil.WarningCallback(){

                public void onOpenTransaction() {
                    log.error((Object)("The task '" + TaskCallableDecorator.this.taskDescriptor.getDescription() + "' has left an open database transaction in play."));
                }
            });
        }
    }
}

