/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.tenancy;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.bc.dataimport.ImportStartedEvent;
import com.atlassian.jira.tenancy.JiraTenantAccessor;
import com.atlassian.jira.tenancy.JiraTenantImpl;
import com.atlassian.jira.tenancy.TenancyCondition;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.tenancy.api.Tenant;
import com.atlassian.tenancy.api.TenantContext;
import com.atlassian.tenancy.api.TenantUnavailableException;
import com.atlassian.tenancy.api.UnexpectedTenantChangeException;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultJiraTenantAccessor
implements JiraTenantAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraTenantAccessor.class);
    private final TenantContext tenantContext;
    private final ComponentLocator componentLocator;
    private Tenant systemTenant;
    private ResettableLazyReference<Iterable<Tenant>> tenantIterableRef = new ResettableLazyReference<Iterable<Tenant>>(){

        protected Iterable<Tenant> create() throws Exception {
            DefaultJiraTenantAccessor.this.initialiseSystemTenant();
            if (DefaultJiraTenantAccessor.this.systemTenant == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(DefaultJiraTenantAccessor.this.systemTenant);
        }
    };
    private volatile boolean doingImport;
    private boolean initialised;

    public DefaultJiraTenantAccessor(TenantContext tenantContext, ComponentLocator componentLocator) {
        this.tenantContext = tenantContext;
        this.componentLocator = componentLocator;
    }

    public Iterable<Tenant> getAvailableTenants() {
        return (Iterable)this.tenantIterableRef.get();
    }

    public <T> T asTenant(Tenant tenant, Callable<T> call) throws TenantUnavailableException, InvocationTargetException {
        Tenant currentTenant = this.tenantContext.getCurrentTenant();
        if (currentTenant == null) {
            log.warn("You are not associated with a tenant, so cannot call tenant specific code");
            throw new TenantUnavailableException();
        }
        if (tenant != currentTenant) {
            log.warn("You cannot invoke a runnable in another tenant's context");
            throw new UnexpectedTenantChangeException();
        }
        try {
            return call.call();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public synchronized void addTenant(Tenant tenant) {
        if (this.doingImport) {
            throw new IllegalStateException("Cannot add tenant while doing an import");
        }
        if (this.systemTenant != null) {
            throw new IllegalArgumentException("The system is already tenanted");
        }
        this.systemTenant = tenant;
        this.tenantIterableRef.reset();
    }

    @EventListener
    public void onImportStarted(ImportStartedEvent importStartedEvent) {
        this.doingImport = true;
    }

    @EventListener
    public void onImportCompleted(ImportCompletedEvent importCompletedEvent) {
        this.doingImport = false;
    }

    private void initialiseSystemTenant() {
        TenancyCondition tenancyCondition;
        if (!this.initialised && this.systemTenant == null && !(tenancyCondition = (TenancyCondition)this.componentLocator.getComponent(TenancyCondition.class)).isEnabled()) {
            this.systemTenant = new JiraTenantImpl("system");
        }
        this.initialised = true;
    }
}

